/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import com.ibm.etools.palette.PaletteReader;
import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.palette.PalettePlugin;
import com.ibm.etools.webedit.palette.customize.CustomizerSeparatorFactory;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteViewerPreferences;
import com.ibm.etools.webedit.palette.customize.PaletteDrawerEntryPage;
import com.ibm.etools.webedit.palette.customize.PaletteEntryPage;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import com.ibm.etools.webedit.palette.model.PaletteCategoryItem;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HTMLPaletteCustomizer
extends PaletteCustomizer {
    private List<EntryPage> changedPages = null;
    private Map<PaletteCategory, List> modifiedDrawers = null;
    private PaletteRoot paletteRoot = null;
    private List originalCategories = null;
    protected HTMLPaletteViewerPreferences prefs = null;

    public void performMoveDown(PaletteEntry entry) {
        this.handleDrawerModified(entry);
        super.performMoveDown(entry);
    }

    public void performMoveUp(PaletteEntry entry) {
        this.handleDrawerModified(entry);
        super.performMoveUp(entry);
    }

    private void handleDrawerModified(PaletteEntry entry) {
        if (entry instanceof PaletteCategoryItem) {
            PaletteCategory parentCategory = (PaletteCategory)entry.getParent();
            if (this.modifiedDrawers == null) {
                this.modifiedDrawers = new HashMap<PaletteCategory, List>();
            }
            if (this.modifiedDrawers.get((Object)parentCategory) == null) {
                this.modifiedDrawers.put(parentCategory, (List)((ArrayList)parentCategory.getChildren()).clone());
            }
        } else if (entry instanceof PaletteCategory && this.paletteRoot == null) {
            this.paletteRoot = (PaletteRoot)entry.getParent();
            this.originalCategories = (List)((ArrayList)this.paletteRoot.getChildren()).clone();
        }
    }

    public void revertToSaved() {
        if (this.changedPages != null) {
            int i = 0;
            while (i < this.changedPages.size()) {
                EntryPage entryPage = this.changedPages.get(i);
                if (entryPage instanceof PaletteEntryPage) {
                    ((PaletteEntryPage)entryPage).undoChanges();
                } else if (entryPage instanceof PaletteDrawerEntryPage) {
                    ((PaletteDrawerEntryPage)entryPage).undoChanges();
                }
                ++i;
            }
            this.changedPages = null;
        }
        if (this.modifiedDrawers != null) {
            for (PaletteCategory category : this.modifiedDrawers.keySet()) {
                category.getChildren().clear();
                category.addAll(this.modifiedDrawers.get((Object)category));
            }
            this.modifiedDrawers = null;
        }
        if (this.paletteRoot != null) {
            this.paletteRoot.getChildren().clear();
            this.paletteRoot.addAll(this.originalCategories);
            this.paletteRoot = null;
            this.originalCategories = null;
        }
    }

    public void save() {
        if (this.isDirty()) {
            try {
                Document prefDocument = null;
                String pref = PalettePlugin.getDefault().getPreferenceStore().getString("com.ibm.etools.webedit.palette.overlay");
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (pref.equals("")) {
                    prefDocument = builder.newDocument();
                    prefDocument.appendChild(prefDocument.createElement("paletteOverlay"));
                } else {
                    prefDocument = builder.parse(new InputSource(new StringReader(pref)));
                }
                if (this.changedPages != null) {
                    int i = 0;
                    while (i < this.changedPages.size()) {
                        EntryPage entryPage = this.changedPages.get(i);
                        if (entryPage instanceof PaletteEntryPage) {
                            PaletteEntryPage paletteEntrypage = (PaletteEntryPage)entryPage;
                            paletteEntrypage.mergeItemElement(prefDocument);
                            paletteEntrypage.doChanges();
                        } else if (entryPage instanceof PaletteDrawerEntryPage) {
                            PaletteDrawerEntryPage paletteDrawerEntrypage = (PaletteDrawerEntryPage)entryPage;
                            paletteDrawerEntrypage.mergeDrawerElement(prefDocument);
                            paletteDrawerEntrypage.doChanges();
                        }
                        ++i;
                    }
                    this.changedPages = null;
                }
                if (this.modifiedDrawers != null) {
                    for (PaletteCategory category : this.modifiedDrawers.keySet()) {
                        PaletteCategoryData data = category.getCategoryData();
                        data.getChildren().clear();
                        List children = category.getChildren();
                        int i = 0;
                        while (i < children.size()) {
                            PaletteCategoryItem child = (PaletteCategoryItem)children.get(i);
                            PaletteItemData paletteModelObject = (PaletteItemData)child.getTemplate();
                            paletteModelObject.setPreferredOffset(Integer.toString(i));
                            data.add(paletteModelObject);
                            String id = child.getId();
                            Element itemElement = this.findOrCreateElement(prefDocument, id, "item");
                            itemElement.setAttribute("category", data.getId());
                            itemElement.setAttribute("preferredoffset", Integer.toString(i));
                            ++i;
                        }
                    }
                    this.modifiedDrawers = null;
                }
                if (this.paletteRoot != null) {
                    PaletteCategory category;
                    List children = this.paletteRoot.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        category = (PaletteCategory)((Object)children.get(i));
                        PaletteCategoryData paletteModelObject = category.getCategoryData();
                        PaletteReader.getInstance().getDefinitions().removeCategory(paletteModelObject);
                        ++i;
                    }
                    i = 0;
                    while (i < children.size()) {
                        category = (PaletteCategory)((Object)children.get(i));
                        String id = category.getId();
                        PaletteCategoryData paletteModelObject = category.getCategoryData();
                        PaletteReader.getInstance().getDefinitions().addCategory(paletteModelObject);
                        Element drawerElement = this.findOrCreateElement(prefDocument, id, "category");
                        drawerElement.setAttribute("preferredoffset", Integer.toString(i));
                        ++i;
                    }
                    this.paletteRoot = null;
                }
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(prefDocument);
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                transformer.transform(source, result);
                String xmlString = sw.toString();
                PalettePlugin.getDefault().getPreferenceStore().putValue("com.ibm.etools.webedit.palette.overlay", xmlString);
                PaletteReader.getInstance().setPreferences(xmlString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List getNewEntryFactories() {
        ArrayList<CustomizerSeparatorFactory> list = new ArrayList<CustomizerSeparatorFactory>(1);
        list.add(new CustomizerSeparatorFactory(this));
        return list;
    }

    public EntryPage getPropertiesPage(PaletteEntry entry) {
        Object retVal = null;
        if (entry instanceof PaletteDrawer) {
            retVal = new PaletteDrawerEntryPage(this);
            ((PaletteDrawerEntryPage)((Object)retVal)).setPreferences(this.prefs);
        } else {
            retVal = new PaletteEntryPage(this);
            ((PaletteEntryPage)((Object)retVal)).setPreferences(this.prefs);
        }
        return retVal;
    }

    public void addToChangedPages(EntryPage changedPage) {
        if (this.changedPages == null) {
            this.changedPages = new ArrayList<EntryPage>();
        }
        this.changedPages.add(changedPage);
    }

    public void setPreferences(HTMLPaletteViewerPreferences newPrefs) {
        if (this.prefs != newPrefs) {
            this.prefs = newPrefs;
            if (this.changedPages != null) {
                int i = 0;
                while (i < this.changedPages.size()) {
                    EntryPage entry = this.changedPages.get(i);
                    if (entry instanceof PaletteEntryPage) {
                        ((PaletteEntryPage)entry).setPreferences(newPrefs);
                    } else if (entry instanceof PaletteDrawerEntryPage) {
                        ((PaletteDrawerEntryPage)entry).setPreferences(newPrefs);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean isDirty() {
        return this.changedPages != null || this.modifiedDrawers != null || this.paletteRoot != null;
    }

    private Element findOrCreateElement(Document document, String id, String itemOrDrawer) {
        Element itemElement = null;
        NodeList nodeList = document.getElementsByTagName(itemOrDrawer);
        int j = 0;
        while (j < nodeList.getLength()) {
            String elementId = ((Element)nodeList.item(j)).getAttribute("id");
            if (elementId.equals(id)) {
                itemElement = (Element)nodeList.item(j);
                break;
            }
            ++j;
        }
        if (itemElement == null) {
            itemElement = document.createElement(itemOrDrawer);
            document.getDocumentElement().appendChild(itemElement);
        }
        itemElement.setAttribute("id", id);
        return itemElement;
    }

    public void performItemCreation(PaletteCategory parentCategory) {
        if (parentCategory != null) {
            if (this.modifiedDrawers == null) {
                this.modifiedDrawers = new HashMap<PaletteCategory, List>();
            }
            if (this.modifiedDrawers.get((Object)parentCategory) == null) {
                this.modifiedDrawers.put(parentCategory, (List)((ArrayList)parentCategory.getChildren()).clone());
            }
        }
    }
}

