/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import com.ibm.etools.webedit.palette.ResourceHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class AttributeMenu
extends MenuManager
implements ICellEditorListener {
    private TableViewer tableViewer;
    private TableEditor tableEditor;
    private CellEditor cellEditor;
    private TableFocusListener focusListener = new TableFocusListener();
    private TableTraverseListener traverseListener = new TableTraverseListener();
    private int columnIndex;
    private TableItem tableItem;

    public AttributeMenu(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.tableEditor = new TableEditor(tableViewer.getTable());
        this.buildMenu();
    }

    public void cancelEditor() {
        this.deactivateCellEditor();
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    public void applyEditorValue() {
        int columnToEdit = this.tableEditor.getColumn();
        if (columnToEdit < 0 || this.cellEditor == null) {
            return;
        }
        TableItem ti = this.tableEditor.getItem();
        if (ti != null) {
            String oldText;
            boolean modified;
            String newText = (String)this.cellEditor.getValue();
            boolean bl = modified = newText != (oldText = ti.getText(columnToEdit)) || oldText == null || !newText.equals(oldText);
            if (modified) {
                String property;
                ti.setText(columnToEdit, newText);
                switch (columnToEdit) {
                    case 0: {
                        property = "name";
                        break;
                    }
                    case 1: {
                        property = "value";
                        break;
                    }
                    default: {
                        property = "";
                    }
                }
                this.tableViewer.getCellModifier().modify((Object)ti, property, (Object)newText);
            }
        }
        this.deactivateCellEditor();
    }

    private void buildMenu() {
        this.add((IAction)new EditAttrNameAction());
        this.add((IContributionItem)new Separator());
        this.add((IAction)new EditAttrValueAction());
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AttributeMenu.this.update(true);
            }
        });
    }

    private CellEditor getCellEditor(int columnToEdit) {
        CellEditor[] editors;
        if (this.tableViewer != null && (editors = this.tableViewer.getCellEditors()) != null && columnToEdit >= 0 && columnToEdit < editors.length) {
            return editors[columnToEdit];
        }
        return null;
    }

    private void disableCellEditor() {
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
    }

    private void deactivateCellEditor() {
        this.tableEditor.setEditor(null, null, this.tableEditor.getColumn());
        if (this.cellEditor != null) {
            this.cellEditor.removeListener((ICellEditorListener)this);
            this.cellEditor.getControl().removeFocusListener((FocusListener)this.focusListener);
            this.cellEditor.getControl().removeTraverseListener((TraverseListener)this.traverseListener);
            this.cellEditor.deactivate();
            this.cellEditor = null;
        }
    }

    private void activateCellEditor(TableItem item, int columnToEdit) {
        this.cellEditor = this.getCellEditor(columnToEdit);
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.setValue((Object)item.getText(columnToEdit));
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.tableViewer.getTable().showSelection();
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableEditor.grabHorizontal = layout.grabHorizontal;
        this.tableEditor.minimumWidth = item.getBounds((int)columnToEdit).width;
        this.tableEditor.setEditor(control, item, columnToEdit);
        this.cellEditor.setFocus();
        this.cellEditor.addListener((ICellEditorListener)this);
        this.cellEditor.getControl().addFocusListener((FocusListener)this.focusListener);
        this.cellEditor.getControl().addTraverseListener((TraverseListener)this.traverseListener);
    }

    private void handleTabNext(TraverseEvent e) {
        CellEditor[] editors;
        if (this.tableViewer != null && (editors = this.tableViewer.getCellEditors()) != null) {
            int start;
            int i = start = this.columnIndex + 1 < this.tableViewer.getTable().getColumnCount() ? this.columnIndex + 1 : 0;
            while (i <= editors.length) {
                TableItem[] items;
                if (this.getCellEditor(i) != null && (items = this.tableViewer.getTable().getSelection()).length == 1) {
                    this.columnIndex = i;
                    this.tableItem = items[0];
                    e.doit = false;
                    break;
                }
                ++i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void handleTabPrevious(TraverseEvent e) {
        CellEditor[] editors;
        if (this.tableViewer != null && (editors = this.tableViewer.getCellEditors()) != null) {
            int start;
            int i = start = this.columnIndex - 1 >= 0 ? this.columnIndex - 1 : this.tableViewer.getTable().getColumnCount() - 1;
            while (i >= 0) {
                TableItem[] items;
                if (this.getCellEditor(i) != null && (items = this.tableViewer.getTable().getSelection()).length == 1) {
                    this.columnIndex = i;
                    this.tableItem = items[0];
                    e.doit = false;
                    break;
                }
                --i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void startActivationThread() {
        new Thread(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AttributeMenu.this.activateCellEditor(AttributeMenu.this.tableItem, AttributeMenu.this.columnIndex);
                    }
                });
            }
        }.start();
    }

    private class EditAttrNameAction
    extends Action {
        public EditAttrNameAction() {
            super(ResourceHandler._UI_Edit_Name_1);
            this.setEnabled(true);
        }

        public void run() {
            AttributeMenu.this.disableCellEditor();
            Table attrControl = AttributeMenu.this.tableViewer.getTable();
            TableItem[] items = attrControl.getSelection();
            if (items.length == 1) {
                TableItem item = items[0];
                AttributeMenu.this.columnIndex = 0;
                AttributeMenu.this.activateCellEditor(item, 0);
            }
        }
    }

    private class EditAttrValueAction
    extends Action {
        public EditAttrValueAction() {
            super(ResourceHandler._UI_Edit_Value_2);
            this.setEnabled(true);
        }

        public void run() {
            AttributeMenu.this.disableCellEditor();
            Table attrControl = AttributeMenu.this.tableViewer.getTable();
            TableItem[] items = attrControl.getSelection();
            if (items.length == 1) {
                TableItem item = items[0];
                AttributeMenu.this.columnIndex = 1;
                AttributeMenu.this.activateCellEditor(item, 1);
            }
        }
    }

    private class TableFocusListener
    implements FocusListener {
        private TableFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            AttributeMenu.this.disableCellEditor();
        }
    }

    private class TableTraverseListener
    implements TraverseListener {
        private TableTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                AttributeMenu.this.applyEditorValue();
                AttributeMenu.this.handleTabNext(e);
            } else if (e.detail == 8) {
                AttributeMenu.this.applyEditorValue();
                AttributeMenu.this.handleTabPrevious(e);
            }
        }
    }
}

