/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;

abstract class AbstractPaletteViewerPreferences
implements PaletteViewerPreferences {
    private static final String DEFAULT_FONT = "Default";
    private IPropertyChangeListener listener;
    private IPropertyChangeListener fontListener;
    private FontData fontData;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private IPreferenceStore store;
    private int[] supportedModes;

    public AbstractPaletteViewerPreferences(IPreferenceStore store) {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.supportedModes = nArray;
        this.store = store;
        store.setDefault("Use Large Icons - Details", false);
        store.setDefault("Use Large Icons - Columns", true);
        store.setDefault("Use Large Icons - Icons", true);
        store.setDefault("Use Large Icons - List", false);
        store.setDefault("Layout Setting", 0);
        store.setDefault("Auto-Collapse Setting", 0);
        store.setDefault("Palette Font", DEFAULT_FONT);
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractPaletteViewerPreferences.this.handlePreferenceStorePropertyChanged(evt.getProperty());
            }
        };
        store.addPropertyChangeListener(this.listener);
        this.fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.dialogfont".equals(event.getProperty()) && AbstractPaletteViewerPreferences.this.getPreferenceStore().getString("Palette Font").equals(AbstractPaletteViewerPreferences.DEFAULT_FONT)) {
                    AbstractPaletteViewerPreferences.this.setFontData(JFaceResources.getDialogFont().getFontData()[0]);
                    AbstractPaletteViewerPreferences.this.handlePreferenceStorePropertyChanged("Palette Font");
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontListener);
    }

    public void releaseListeners() {
        if (this.listener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.listener);
            this.listener = null;
        }
        if (this.fontListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fontListener);
            this.fontListener = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public int getAutoCollapseSetting() {
        return this.getPreferenceStore().getInt("Auto-Collapse Setting");
    }

    public FontData getFontData() {
        if (this.fontData == null) {
            String value = this.getPreferenceStore().getString("Palette Font");
            this.fontData = value.equals(DEFAULT_FONT) ? JFaceResources.getDialogFont().getFontData()[0] : new FontData(value);
        }
        return this.fontData;
    }

    public int getLayoutSetting() {
        return this.getPreferenceStore().getInt("Layout Setting");
    }

    public int[] getSupportedLayoutModes() {
        return this.supportedModes;
    }

    public boolean isSupportedLayoutMode(int layout) {
        int i = 0;
        while (i < this.supportedModes.length) {
            if (this.supportedModes[i] == layout) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAutoCollapseSetting(int newVal) {
        this.getPreferenceStore().setValue("Auto-Collapse Setting", newVal);
    }

    public void setCurrentUseLargeIcons(boolean newVal) {
        this.setUseLargeIcons(this.getLayoutSetting(), newVal);
    }

    public void setFontData(FontData data) {
        this.fontData = data;
        String value = data.toString();
        if (this.fontData.equals((Object)JFaceResources.getDialogFont().getFontData()[0])) {
            value = DEFAULT_FONT;
        }
        this.getPreferenceStore().setValue("Palette Font", value);
    }

    public void setLayoutSetting(int newVal) {
        this.getPreferenceStore().setValue("Layout Setting", newVal);
    }

    public void setSupportedLayoutModes(int[] modes) {
        this.supportedModes = modes;
        if (!this.isSupportedLayoutMode(this.getPreferenceStore().getDefaultInt("Layout Setting"))) {
            this.getPreferenceStore().setDefault("Layout Setting", this.supportedModes[0]);
        }
        if (!this.isSupportedLayoutMode(this.getPreferenceStore().getInt("Layout Setting"))) {
            this.setLayoutSetting(this.supportedModes[0]);
        }
    }

    public void setUseLargeIcons(int layout, boolean newVal) {
        this.getPreferenceStore().setValue(DefaultPaletteViewerPreferences.convertLayoutToPreferenceName((int)layout), newVal);
    }

    public boolean useLargeIcons() {
        return this.useLargeIcons(this.getLayoutSetting());
    }

    public boolean useLargeIcons(int layout) {
        return this.getPreferenceStore().getBoolean(DefaultPaletteViewerPreferences.convertLayoutToPreferenceName((int)layout));
    }

    protected void handlePreferenceStorePropertyChanged(String property) {
        if (property.equals("Layout Setting")) {
            this.firePropertyChanged(property, new Integer(this.getLayoutSetting()));
        } else if (property.equals("Auto-Collapse Setting")) {
            this.firePropertyChanged(property, new Integer(this.getAutoCollapseSetting()));
        } else if (property.equals("Palette Font")) {
            this.firePropertyChanged(property, this.getFontData());
        } else {
            this.firePropertyChanged(property, new Boolean(this.useLargeIcons(DefaultPaletteViewerPreferences.convertPreferenceNameToLayout((String)property))));
        }
    }

    protected void firePropertyChanged(String property, Object newVal) {
        this.listeners.firePropertyChange(property, null, newVal);
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.store;
    }
}

