/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.action;

import com.ibm.etools.webedit.palette.FeedbackContributor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FeedbackContributorFactory {
    private static FeedbackContributorFactory instance = null;
    Map mapIDtoContributor = new HashMap();

    private FeedbackContributorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeedbackContributorFactory getInstance() {
        if (instance != null) return instance;
        Class<FeedbackContributorFactory> clazz = FeedbackContributorFactory.class;
        synchronized (FeedbackContributorFactory.class) {
            if (instance != null) return instance;
            instance = new FeedbackContributorFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addContributor(String id, String classname, IConfigurationElement element) {
        if (id != null && this.mapIDtoContributor != null) {
            Object obj = this.mapIDtoContributor.get(id);
            if (obj != null) {
                this.mapIDtoContributor.remove(id);
            }
            if (classname != null && element != null) {
                this.mapIDtoContributor.put(id, new FeedbackContributorEntry(classname, element));
            }
        }
    }

    public FeedbackContributor getContributor(String id) {
        FeedbackContributor contrib = null;
        if (this.mapIDtoContributor != null) {
            FeedbackContributorEntry ace;
            try {
                ace = (FeedbackContributorEntry)this.mapIDtoContributor.get(id);
            }
            catch (ClassCastException classCastException) {
                ace = null;
            }
            if (ace != null) {
                contrib = ace.getContributor();
            }
        }
        return contrib;
    }

    private class FeedbackContributorEntry {
        private String classname;
        private FeedbackContributor contrib;
        private IConfigurationElement elem;

        private FeedbackContributorEntry(String classname, IConfigurationElement elem) {
            this.classname = classname;
            this.elem = elem;
        }

        private FeedbackContributor getContributor() {
            Bundle bundle;
            if (this.contrib == null && (bundle = this.getBundle()) != null && this.classname != null) {
                try {
                    Class clazz = bundle.loadClass(this.classname);
                    if (clazz != null) {
                        this.contrib = (FeedbackContributor)clazz.newInstance();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.contrib = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.contrib = null;
                }
                catch (InstantiationException instantiationException) {
                    this.contrib = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.contrib = null;
                }
                catch (ClassCastException classCastException) {
                    this.contrib = null;
                }
            }
            return this.contrib;
        }

        private Bundle getBundle() {
            Bundle bundle = null;
            if (this.elem != null) {
                bundle = Platform.getBundle((String)this.elem.getDeclaringExtension().getContributor().getName());
            }
            return bundle;
        }
    }
}

