/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette;

import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import com.ibm.etools.webedit.palette.model.PaletteCategoryItem;
import com.ibm.etools.webedit.palette.model.PaletteItem;
import com.ibm.etools.webedit.palette.model.PaletteSeparatorItem;
import java.net.URL;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.resource.ImageDescriptor;

class PaletteFactory {
    private static PaletteFactory instance = null;

    private PaletteFactory() {
    }

    public static PaletteFactory getInstance() {
        if (instance == null) {
            instance = new PaletteFactory();
        }
        return instance;
    }

    public PaletteEntry createEntry(PaletteItemData entryTemplate) {
        PaletteCategoryItem retVal = null;
        if (entryTemplate.isSeparator()) {
            PaletteSeparatorItem item = new PaletteSeparatorItem(entryTemplate.getId());
            item.setTemplate(entryTemplate);
            item.setVisible(entryTemplate.isVisible());
            retVal = item;
        } else {
            URL iconSmallURL = entryTemplate.getSmallIcon();
            URL iconLargeURL = entryTemplate.getLargeIcon();
            ImageDescriptor iconSmall = ImageDescriptor.createFromURL((URL)iconSmallURL);
            ImageDescriptor iconLarge = ImageDescriptor.createFromURL((URL)iconLargeURL);
            String label = entryTemplate.getLabel();
            String value = entryTemplate.getDescription();
            PaletteItem item = new PaletteItem(label, value, entryTemplate, null, iconSmall, iconLarge);
            item.setTemplate(entryTemplate);
            item.setVisible(entryTemplate.isVisible());
            retVal = item;
        }
        return retVal;
    }

    public PaletteCategory createCategory(PaletteCategoryData entryTemplate) {
        ImageDescriptor iconSmall = ImageDescriptor.createFromURL((URL)entryTemplate.getSmallIcon());
        String label = entryTemplate.getLabel();
        String value = entryTemplate.getDescription();
        PaletteCategory item = new PaletteCategory(label, iconSmall);
        item.setCategoryData(entryTemplate);
        item.setDescription(value);
        item.setVisible(entryTemplate.isVisible());
        int initialState = 1;
        if (entryTemplate.isInitiallyOpen()) {
            initialState = entryTemplate.isInitiallyPinned() ? 2 : 0;
        }
        item.setInitialState(initialState);
        return item;
    }
}

