/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.PaletteContextInspector;
import com.ibm.etools.webedit.palette.PalettePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class PaletteContextRegistryReader {
    private static final String EXTENSION_PT_ID = "PageDesignerPaletteContexts";
    private static final String DEFINITION_ELM = "definition";
    private static final String INSPECTOR_CLASS_ATT = "inspectorClass";
    private static final String ID_ATT = "id";
    private static final String NAME_ATT = "name";
    private static final String PRIORITY_ATT = "priority";
    private static final String DEFAULT_CONTEXT = "HTML";
    private static final String FACET_ELM = "facet";
    private static final String VERSION_ATT = "version";
    private static PaletteContextRegistryReader singleton;
    private boolean contextsParsed = false;
    private List contexts;

    public static String getActiveContext(IProject proj, HTMLEditDomain domain) {
        if (singleton == null) {
            singleton = new PaletteContextRegistryReader();
        }
        return singleton.determineActiveContext(proj, domain);
    }

    public static List getContextNames(IProject proj, HTMLEditDomain domain) {
        if (singleton == null) {
            singleton = new PaletteContextRegistryReader();
        }
        return singleton.determineContextNames(proj, domain);
    }

    private List determineContextNames(IProject proj, HTMLEditDomain domain) {
        if (!this.contextsParsed) {
            this.parseContexts();
        }
        ArrayList<ContextDefinition> visibleContexts = new ArrayList<ContextDefinition>();
        int i = 0;
        while (i < this.contexts.size()) {
            ContextDefinition context = (ContextDefinition)this.contexts.get(i);
            boolean hasAllFacets = this.projectHasAllFacets(proj, context);
            if (hasAllFacets) {
                if (context.inspectorClass != null) {
                    if (this.inspectorSatisfied(context, domain)) {
                        visibleContexts.add(context);
                    }
                } else {
                    visibleContexts.add(context);
                }
            }
            ++i;
        }
        return Collections.unmodifiableList(visibleContexts);
    }

    private String determineActiveContext(IProject proj, HTMLEditDomain domain) {
        if (!this.contextsParsed) {
            this.parseContexts();
        }
        if (domain.getModel().getContentTypeIdentifier().equals("org.eclipse.wst.html.core.htmlsource")) {
            return DEFAULT_CONTEXT;
        }
        String activeContext = DEFAULT_CONTEXT;
        int i = 0;
        while (i < this.contexts.size()) {
            ContextDefinition context = (ContextDefinition)this.contexts.get(i);
            boolean hasAllFacets = this.projectHasAllFacets(proj, context);
            if (hasAllFacets) {
                if (context.inspectorClass != null) {
                    if (this.inspectorSatisfied(context, domain)) {
                        activeContext = context.id;
                        break;
                    }
                } else {
                    activeContext = context.id;
                    break;
                }
            }
            ++i;
        }
        return activeContext;
    }

    private boolean projectHasAllFacets(IProject proj, ContextDefinition context) {
        boolean hasAllFacets = true;
        int j = 0;
        while (j < context.facets.size()) {
            FacetDefinition facet = (FacetDefinition)context.facets.get(j);
            if (!PaletteContextRegistryReader.projectHasFacet(proj, facet.facetID, facet.facetVersion)) {
                hasAllFacets = false;
                break;
            }
            ++j;
        }
        return hasAllFacets;
    }

    private boolean inspectorSatisfied(ContextDefinition context, HTMLEditDomain domain) {
        boolean satisfied = false;
        PaletteContextInspector inspector = null;
        try {
            inspector = (PaletteContextInspector)context.inspectorClass.createExecutableExtension(INSPECTOR_CLASS_ATT);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (inspector != null && inspector.isContextActive(domain)) {
            satisfied = true;
        }
        return satisfied;
    }

    private void parseContexts() {
        String pluginId = PalettePlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pluginId, EXTENSION_PT_ID);
        IExtension[] extensions = point.getExtensions();
        this.contexts = new ArrayList();
        int i = 0;
        while (i < extensions.length) {
            ContextDefinition cd = new ContextDefinition();
            cd.facets = new ArrayList();
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String name = configElements[j].getName();
                if (DEFINITION_ELM.equals(name)) {
                    cd.id = configElements[j].getAttribute(ID_ATT);
                    cd.name = configElements[j].getAttribute(NAME_ATT);
                    cd.priority = Integer.parseInt(configElements[j].getAttribute(PRIORITY_ATT));
                    String inspectorClassName = configElements[j].getAttribute(INSPECTOR_CLASS_ATT);
                    if (inspectorClassName != null) {
                        cd.inspectorClass = configElements[j];
                    }
                } else if (FACET_ELM.equals(name)) {
                    FacetDefinition fd = new FacetDefinition();
                    fd.facetID = configElements[j].getAttribute(ID_ATT);
                    fd.facetVersion = configElements[j].getAttribute(VERSION_ATT);
                    cd.facets.add(fd);
                }
                ++j;
            }
            this.addContextDefinition(cd);
            ++i;
        }
        this.contextsParsed = true;
    }

    private void addContextDefinition(ContextDefinition cd) {
        boolean added = false;
        int index = 0;
        while (!added) {
            if (this.contexts.size() == index) {
                this.contexts.add(cd);
                added = true;
                continue;
            }
            if (((ContextDefinition)this.contexts.get((int)index)).priority > cd.priority) {
                ++index;
                continue;
            }
            this.contexts.add(index, cd);
            added = true;
        }
    }

    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }

    public final class ContextDefinition {
        public String id;
        public String name;
        public IConfigurationElement inspectorClass;
        public int priority;
        public List facets;
    }

    private class FacetDefinition {
        public String facetID;
        public String facetVersion;

        private FacetDefinition() {
        }
    }
}

