/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.palette;

import com.ibm.etools.palette.model.IDefinitions;
import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteItemData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class PaletteDefinitions
implements IDefinitions {
    protected List<PaletteCategoryData> fCategories = null;
    protected List<PaletteItemData> fItems = null;
    private Hashtable<String, PaletteCategoryData> fCategoriesHash = new Hashtable();
    private Hashtable<String, PaletteItemData> fItemsHash = new Hashtable();

    @Override
    public List<PaletteCategoryData> getCategories() {
        if (this.fCategories == null) {
            this.fCategories = new ArrayList<PaletteCategoryData>();
        }
        return this.fCategories;
    }

    @Override
    public void setCategories(List<PaletteCategoryData> categories) {
        this.fCategories = categories;
        Iterator<PaletteCategoryData> i = categories.iterator();
        PaletteCategoryData o = null;
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof PaletteCategoryData)) continue;
            this.fCategoriesHash.put(o.getId(), o);
        }
    }

    @Override
    public List<PaletteItemData> getItems() {
        if (this.fItems == null) {
            this.fItems = new ArrayList<PaletteItemData>();
        }
        return this.fItems;
    }

    @Override
    public List<PaletteItemData> getItemsForCategory(String qualifiedCategory) {
        ArrayList<PaletteItemData> items = new ArrayList<PaletteItemData>();
        for (PaletteItemData item : this.getItems()) {
            if (!item.getCategory().equals(qualifiedCategory)) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public PaletteCategoryData getCategory(String qualifiedCategory) {
        PaletteCategoryData retVal = this.fCategoriesHash.get(qualifiedCategory);
        return retVal;
    }

    @Override
    public PaletteItemData getItem(String id) {
        PaletteItemData retVal = this.fItemsHash.get(id);
        return retVal;
    }

    @Override
    public void setItems(List<PaletteItemData> items) {
        this.fItems = items;
        Iterator<PaletteItemData> i = items.iterator();
        PaletteItemData o = null;
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof PaletteItemData)) continue;
            this.fItemsHash.put(o.getId(), o);
        }
    }

    @Override
    public void addItem(PaletteItemData item) {
        this.getItems().add(item);
        this.fItemsHash.put(item.getId(), item);
    }

    @Override
    public void removeItem(PaletteItemData item) {
        this.getItems().remove(item);
        this.fItemsHash.remove(item.getId());
    }

    @Override
    public void addCategory(PaletteCategoryData category) {
        this.getCategories().add(category);
        this.fCategoriesHash.put(category.getId(), category);
    }

    @Override
    public void addCategory(int index, PaletteCategoryData category) {
        this.getCategories().add(index, category);
        this.fCategoriesHash.put(category.getId(), category);
    }

    @Override
    public void removeCategory(PaletteCategoryData category) {
        this.getCategories().remove(category);
        this.fCategoriesHash.remove(category.getId());
    }
}

