/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.selection;

import java.util.EventObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class HTMLSelectionChangedEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private Range range = null;
    private Node focusedNode = null;
    private NodeList nodeList = null;
    private Object nodeListData = null;

    public HTMLSelectionChangedEvent(Object source, NodeList nodeList, Object data) {
        super(source);
        this.nodeList = nodeList;
        this.nodeListData = data;
    }

    public HTMLSelectionChangedEvent(Object source, Range range, Node FocusedNode) {
        super(source);
        this.range = range;
        this.focusedNode = FocusedNode;
    }

    public Node getFocusedNode() {
        return this.focusedNode;
    }

    public NodeList getNodeList() {
        return this.nodeList;
    }

    public Object getNodeListData() {
        return this.nodeListData;
    }

    public Range getRange() {
        return this.range;
    }

    public boolean hasSelection() {
        return this.range != null && !this.range.getCollapsed();
    }

    @Override
    public String toString() {
        StringBuffer s;
        StringBuffer stringBuffer = s = this.range == null ? new StringBuffer("Range start=null") : new StringBuffer("Range start=" + this.range.getStartContainer().getNodeName() + " offset=" + this.range.getStartOffset() + " end=" + this.range.getEndContainer().getNodeName() + " offset=" + this.range.getEndOffset());
        if (this.focusedNode != null) {
            s.append(" FocusedNode = " + this.focusedNode.getNodeName());
        } else {
            s.append(" FocusedNode = null");
        }
        if (this.nodeList != null) {
            s.append(" NodeList = ");
            int i = 0;
            while (i < this.nodeList.getLength()) {
                s.append(this.nodeList.item(i).getNodeName()).append(" ");
                ++i;
            }
        } else {
            s.append(" NodeList = null");
        }
        if (this.nodeListData != null) {
            s.append(" NodeListData = " + this.nodeListData.toString());
        } else {
            s.append(" NodeListData = null");
        }
        return s.toString();
    }
}

