/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.links.util;

public class TextUtilities {
    public static final String[] fgDelimiters = new String[]{"\n", "\r", "\r\n"};

    public static String determineLineDelimiter(String text, String hint) {
        try {
            int[] info = TextUtilities.indexOf(fgDelimiters, text, 0);
            return fgDelimiters[info[1]];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return hint;
        }
    }

    public static int[] indexOf(String[] searchStrings, String text, int offset) {
        int[] result = new int[]{-1, -1};
        int zeroIndex = -1;
        int i = 0;
        while (i < searchStrings.length) {
            int length = searchStrings[i].length();
            if (length == 0) {
                zeroIndex = i;
            } else {
                int index = text.indexOf(searchStrings[i], offset);
                if (index >= 0) {
                    if (result[0] == -1) {
                        result[0] = index;
                        result[1] = i;
                    } else if (index < result[0]) {
                        result[0] = index;
                        result[1] = i;
                    } else if (index == result[0] && length > searchStrings[result[1]].length()) {
                        result[0] = index;
                        result[1] = i;
                    }
                }
            }
            ++i;
        }
        if (zeroIndex > -1 && result[0] == -1) {
            result[0] = 0;
            result[1] = zeroIndex;
        }
        return result;
    }

    public static int endsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.endsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int startsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.startsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int equals(String[] compareStrings, String text) {
        int i = 0;
        while (i < compareStrings.length) {
            if (text.equals(compareStrings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

