/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.links.util;

import com.ibm.etools.webedit.links.util.ContextRootManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ModuleUtil {
    public static final IVirtualComponent getComponent(IResource resource) {
        if (resource == null) {
            return null;
        }
        return ComponentCore.createComponent((IProject)resource.getProject());
    }

    public static boolean isDynamicWeb(IProject project) {
        boolean isDynamicWeb = false;
        if (project != null) {
            try {
                isDynamicWeb = ModuleUtil.projectHasFacet(project, "jst.web", null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return isDynamicWeb;
    }

    public static boolean isStaticWeb(IProject project) {
        boolean isStaticWeb = false;
        if (project != null) {
            try {
                isStaticWeb = ModuleUtil.projectHasFacet(project, "wst.web", null);
            }
            catch (CoreException coreException) {}
        }
        return isStaticWeb;
    }

    public static boolean isWebProject(IProject project) {
        if (ModuleUtil.isDynamicWeb(project)) {
            return true;
        }
        return ModuleUtil.isStaticWeb(project);
    }

    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) throws CoreException {
        IProjectFacet requiredFacet;
        IFacetedProject facetedProject;
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID) && (facetedProject = ProjectFacetsManager.create((IProject)project)) != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
            if (facetVersion != null) {
                IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                if (requiredFacetVersion != null) {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                }
            } else {
                hasFacet = facetedProject.hasProjectFacet(requiredFacet);
            }
        }
        return hasFacet;
    }

    public static final String getServerContextRoot(IProject project) {
        String serverContextRoot = null;
        if (project != null && (serverContextRoot = ContextRootManager.getServerContextRoot(project)) == null) {
            serverContextRoot = project.getFullPath().toString();
        }
        return serverContextRoot;
    }

    @Deprecated
    public static final String getServerContextRoot(IProject project, IResource resource) {
        if (project == null || resource == null) {
            return null;
        }
        return ModuleUtil.getServerContextRoot(project);
    }

    public static final String getDocumentRootLocation(IProject project) {
        String docRootLocation = ContextRootManager.getRootLocation(project);
        if (docRootLocation == null) {
            docRootLocation = project.getLocation().addTrailingSeparator().toString();
        }
        return docRootLocation;
    }

    public static final String getDocumentRootLocation(IProject project, IResource resource) {
        return ModuleUtil.getDocumentRootLocation(project);
    }

    public static IProject[] getReferencingEarProjects(IProject p) {
        return J2EEProjectUtilities.getReferencingEARProjects((IProject)p);
    }
}

