/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.internal.extension;

import com.ibm.etools.webedit.common.WebEditCommonPlugin;
import com.ibm.etools.webedit.common.internal.utils.Logger;
import com.ibm.etools.webedit.extension.override.ActionListenerProvider;
import com.ibm.etools.webedit.extension.override.CommandExtensionProvider;
import com.ibm.etools.webedit.extension.override.SubCommandProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class OverrideActionRegistryReader {
    private static OverrideActionRegistryReader instance = new OverrideActionRegistryReader();
    private static final String EXTENSION_POINT_ID = "overrideActions";
    private static final String ELEMENT_ACTION_LISTENER_PROVIDER = "actionListenerProvider";
    private static final String ELEMENT_COMMAND_EXTENSION_PROVIDER = "commandExtensionProvider";
    private static final String ELEMENT_SUB_COMMAND_PROVIDER = "subCommandProvider";
    private static final String ELEMENT_COMMAND = "command";
    private static final String PROPERTY_CLASS = "class";
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_PRIORITY = "priority";
    private static final String PRIORITY_DEFAULT = "normal";
    private List actionListenerProviders;
    private Map commandExtensionProviders;
    private Map commandMap;
    private List subCommandProviders;

    private OverrideActionRegistryReader() {
        this.read();
    }

    public static OverrideActionRegistryReader getInstance() {
        return instance;
    }

    private List internalGetActionListenerProviders() {
        if (this.actionListenerProviders == null) {
            this.actionListenerProviders = new ArrayList();
        }
        return this.actionListenerProviders;
    }

    private Map internalGetCommandExtensionProviders() {
        if (this.commandExtensionProviders == null) {
            this.commandExtensionProviders = new HashMap();
        }
        return this.commandExtensionProviders;
    }

    private Map internalGetCommandMap() {
        if (this.commandMap == null) {
            this.commandMap = new HashMap();
        }
        return this.commandMap;
    }

    private List internalGetSubCommandProviders() {
        if (this.subCommandProviders == null) {
            this.subCommandProviders = new ArrayList();
        }
        return this.subCommandProviders;
    }

    private void read() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(WebEditCommonPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        if (element.getName().equals(ELEMENT_ACTION_LISTENER_PROVIDER)) {
            this.internalGetActionListenerProviders().add(element);
        } else if (element.getName().equals(ELEMENT_COMMAND_EXTENSION_PROVIDER)) {
            IConfigurationElement[] elements = element.getChildren();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                if (ce.getName().equals(ELEMENT_COMMAND)) {
                    String id = ce.getAttribute(PROPERTY_ID);
                    String priority = ce.getAttribute(PROPERTY_PRIORITY);
                    this.addCommandExtensionProvider(element, id, priority);
                }
                ++i;
            }
        } else if (element.getName().equals(ELEMENT_SUB_COMMAND_PROVIDER)) {
            this.internalGetSubCommandProviders().add(element);
        }
    }

    private void addCommandExtensionProvider(IConfigurationElement element, String id, String priority) {
        if (id == null || id.length() <= 0) {
            return;
        }
        if (priority == null || priority.length() <= 0) {
            priority = PRIORITY_DEFAULT;
        }
        Map idMap = this.internalGetCommandMap();
        HashMap<String, ArrayList<IConfigurationElement>> priorityGroup = (HashMap<String, ArrayList<IConfigurationElement>>)idMap.get(id);
        ArrayList<IConfigurationElement> elements = null;
        if (priorityGroup == null) {
            priorityGroup = new HashMap<String, ArrayList<IConfigurationElement>>();
        } else {
            elements = (ArrayList<IConfigurationElement>)priorityGroup.get(priority);
        }
        if (elements == null) {
            elements = new ArrayList<IConfigurationElement>();
        }
        elements.add(element);
        priorityGroup.put(priority, elements);
        idMap.put(id, priorityGroup);
    }

    public ActionListenerProvider[] getActionListenerProviders() {
        ArrayList<Object> providers = null;
        if (this.actionListenerProviders != null) {
            for (IConfigurationElement element : this.actionListenerProviders) {
                Object provider = this.getNewInstance(element, PROPERTY_CLASS);
                if (!(provider instanceof ActionListenerProvider)) continue;
                if (providers == null) {
                    providers = new ArrayList<Object>();
                }
                providers.add(provider);
            }
        }
        if (providers == null) {
            return new ActionListenerProvider[0];
        }
        return providers.toArray(new ActionListenerProvider[providers.size()]);
    }

    public CommandExtensionProvider[] getCommandExtensionProvider(String id, String priority) {
        ArrayList providers = null;
        List elements = this.getElements(id, priority);
        if (elements != null) {
            Map instances = this.internalGetCommandExtensionProviders();
            for (IConfigurationElement element : elements) {
                Object provider = instances.get(element);
                if (provider == null) {
                    provider = this.getNewInstance(element, PROPERTY_CLASS);
                    if (!(provider instanceof CommandExtensionProvider)) continue;
                    instances.put(element, provider);
                }
                if (providers == null) {
                    providers = new ArrayList();
                }
                providers.add(provider);
            }
        }
        if (providers == null) {
            return new CommandExtensionProvider[0];
        }
        return providers.toArray(new CommandExtensionProvider[providers.size()]);
    }

    private List getElements(String id, String priority) {
        Map priorityGroup;
        if (this.commandMap != null && (priorityGroup = (Map)this.commandMap.get(id)) != null) {
            return (List)priorityGroup.get(priority);
        }
        return null;
    }

    public SubCommandProvider[] getSubCommandProviders() {
        ArrayList<Object> providers = null;
        if (this.subCommandProviders != null) {
            for (IConfigurationElement element : this.subCommandProviders) {
                Object provider = this.getNewInstance(element, PROPERTY_CLASS);
                if (!(provider instanceof SubCommandProvider)) continue;
                if (providers == null) {
                    providers = new ArrayList<Object>();
                }
                providers.add(provider);
            }
        }
        if (providers == null) {
            return new SubCommandProvider[0];
        }
        return providers.toArray(new SubCommandProvider[providers.size()]);
    }

    private Object getNewInstance(IConfigurationElement element, String propertyName) {
        String className = element.getAttribute(propertyName);
        if (className != null && className.length() > 0) {
            return this.createNewInstance(element, className);
        }
        return null;
    }

    private Object createNewInstance(IConfigurationElement element, String className) {
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        if (bundle == null) {
            return null;
        }
        try {
            Class clazz = bundle.loadClass(className);
            if (clazz != null) {
                return clazz.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            Logger.log(e);
        }
        catch (IllegalAccessException e) {
            Logger.log(e);
        }
        catch (InstantiationException e) {
            Logger.log(e);
        }
        return null;
    }
}

