/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.internal.extension;

import com.ibm.etools.webedit.common.internal.utils.Logger;
import com.ibm.etools.webedit.extension.CommandProvider;
import com.ibm.etools.webedit.internal.extension.RegistryReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class DesignActionProviderRegistryReader
extends RegistryReader {
    public static final String PLUGIN_ID = "com.ibm.etools.webedit.common";
    public static final String EXTENSION_POINT = "designActionProvider";
    public static final String TAG_COMMAND = "command";
    public static final String TAG_DESIGN_ACTION = "designAction";
    public static final String ATT_CLASS = "class";
    public static final String ATT_URI = "uri";
    public static final String ATT_NAME = "name";
    public static final String ATT_SINGLETON = "singleton";
    public static final String ATT_METHOD = "method";
    public static final String ATT_PRIORITY = "priority";
    public static final String[] PRIORITIES = new String[]{"highest", "high", "mid", "low", "lowest"};
    public static final String TRUE = "true";
    public static final String ANY = "*";
    private ArrayList contributions;
    private HashMap commandMap;

    public DesignActionProviderRegistryReader() {
        this.readContributions(EXTENSION_POINT);
    }

    public static CommandProvider createCommandProvider(IConfigurationElement element) {
        Object obj = null;
        try {
            obj = DesignActionProviderRegistryReader.createExtension(element, ATT_CLASS);
            if (obj instanceof CommandProvider) {
                return (CommandProvider)obj;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        return null;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        if (bundle != null && (bundle.getState() == 8 || bundle.getState() == 32 || bundle.getState() == 16)) {
            return DesignActionProviderRegistryReader.createExecutableExtension(element, classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = DesignActionProviderRegistryReader.createExecutableExtension(element, classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    static Object createExecutableExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Object obj;
        block8: {
            obj = null;
            String singleton = element.getAttribute(ATT_SINGLETON);
            String method = element.getAttribute(ATT_METHOD);
            if (TRUE.equalsIgnoreCase(singleton) && method != null) {
                try {
                    Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
                    if (bundle != null) {
                        String name = element.getAttribute(ATT_CLASS);
                        Class cls = bundle.loadClass(name);
                        Method mtd = cls.getMethod(method, new Class[0]);
                        obj = mtd.invoke(null, null);
                        break block8;
                    }
                    obj = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    obj = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    obj = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    obj = null;
                }
                catch (InvocationTargetException invocationTargetException) {
                    obj = null;
                }
            } else {
                obj = element.createExecutableExtension(classAttribute);
            }
        }
        return obj;
    }

    private List getList(String name, String uri) {
        int num = this.contributions.size();
        if (num == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        int p = 0;
        while (p < PRIORITIES.length) {
            int i = 0;
            while (i < num) {
                IConfigurationElement element;
                Object obj = this.contributions.get(i);
                if (obj instanceof IConfigurationElement && name.equalsIgnoreCase((element = (IConfigurationElement)obj).getName()) && this.matches(uri, element) && (PRIORITIES[p].equals(element.getAttribute(ATT_PRIORITY)) || p == 2 && element.getAttribute(ATT_PRIORITY) == null)) {
                    list.add(element);
                }
                ++i;
            }
            ++p;
        }
        return list;
    }

    public List getCommandList(String uri) {
        List list;
        if (this.commandMap == null) {
            this.commandMap = new HashMap();
        }
        if (uri == null) {
            uri = "";
        }
        if ((list = (List)this.commandMap.get(uri)) == null) {
            list = this.getList(TAG_COMMAND, uri);
            this.commandMap.put(uri, list);
        }
        return list;
    }

    private boolean matches(String uri, IConfigurationElement element) {
        if (uri.equals(ANY)) {
            return true;
        }
        String u = element.getAttribute(ATT_URI);
        return u == null || u.length() == 0 || u.equals(uri);
    }

    private void readContributions(String extensionPoint) {
        this.contributions = new ArrayList();
        this.readRegistry(Platform.getExtensionRegistry(), PLUGIN_ID, extensionPoint);
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_COMMAND)) {
            this.contributions.add(element);
            return true;
        }
        this.readElementChildren(element);
        return true;
    }
}

