/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.internal.commands.table.TableRowColumnData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class SelectionUtil {
    private SelectionUtil() {
    }

    public static NodeList extractNodeList(NodeList nodeList, Range range, Node focusedNode, boolean includeParents) {
        return SelectionUtil.extractNodeList(nodeList, null, range, focusedNode, includeParents);
    }

    public static NodeList extractNodeList(NodeList nodeList, Object nodeListData, Range range, Node focusedNode, boolean includeParents) {
        class MyNodeList
        extends NodeListImpl {
            MyNodeList() {
            }

            protected Node appendNode(Node node) {
                return super.appendNode(node);
            }

            protected Node appendUnique(Node node) {
                int i = 0;
                while (i < this.getLength()) {
                    if (node == this.item(i)) {
                        return null;
                    }
                    ++i;
                }
                return this.appendNode(node);
            }
        }
        if (nodeList == null) {
            MyNodeList nl = new MyNodeList();
            if (range != null && !range.getCollapsed()) {
                Node n;
                Node start = range.getStartContainer();
                int so = range.getStartOffset();
                Node end = range.getEndContainer();
                int eo = range.getEndOffset();
                if (start == null) {
                    start = end;
                }
                if (end == null) {
                    end = start;
                }
                if (start == null) {
                    return null;
                }
                if (start.getNodeType() == 3) {
                    so = SelectionUtil.getNodeIndex(start) + 1;
                    if ((start = start.getParentNode()) == null) {
                        return null;
                    }
                }
                if (end.getNodeType() == 3) {
                    eo = SelectionUtil.getNodeIndex(end);
                    if ((end = end.getParentNode()) == null) {
                        return null;
                    }
                }
                if (start == end) {
                    NodeList c;
                    if (so > eo) {
                        int s = so;
                        so = eo;
                        eo = s;
                    }
                    if ((c = start.getChildNodes()) != null) {
                        int i = so;
                        while (i < eo) {
                            if (i >= 0 && c.getLength() > i) {
                                if (c.item(i).getNodeType() != 3) break;
                                if (i == eo - 1) {
                                    nl.appendNode(start);
                                    nodeList = nl;
                                }
                            }
                            ++i;
                        }
                    }
                } else if (start instanceof IDOMNode && end instanceof IDOMNode && SelectionUtil.calcFlatModelOffset((IDOMNode)start, so) > SelectionUtil.calcFlatModelOffset((IDOMNode)end, eo)) {
                    n = start;
                    start = end;
                    end = n;
                    int s = so;
                    so = eo;
                    eo = s;
                }
                if (nodeList == null) {
                    if (includeParents || SelectionUtil.isParentOfElements(start)) {
                        nl.appendNode(start);
                    }
                    n = null;
                    NodeList children = start.getChildNodes();
                    if (children != null) {
                        n = children.getLength() == 0 || so < 0 ? start : (so >= children.getLength() ? children.item(children.getLength() - 1) : children.item(so));
                    }
                    while (n != null) {
                        if (end != n && n.getNodeType() != 3 && (includeParents || SelectionUtil.isParentOfElements(n))) {
                            nl.appendNode(n);
                        }
                        n = SelectionUtil.getNextNode(n, end, eo);
                    }
                    if (start != end && (includeParents || SelectionUtil.isParentOfElements(end))) {
                        nl.appendNode(end);
                    }
                    if (nl.getLength() == 0) {
                        nl.appendNode(end);
                    }
                    nodeList = nl;
                }
            } else if (focusedNode != null) {
                nl.appendNode(focusedNode);
                nodeList = nl;
            } else if (range != null) {
                nl.appendNode(range.getEndContainer());
                nodeList = nl;
            }
        } else if (nodeListData != null && nodeListData instanceof TableRowColumnData && ((TableRowColumnData)nodeListData).isRow()) {
            MyNodeList nl = new MyNodeList();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node;
                Node tr = node = nodeList.item(i);
                while (tr != null) {
                    if (tr.getNodeName().equalsIgnoreCase("TR")) {
                        nl.appendUnique(tr);
                        break;
                    }
                    tr = tr.getParentNode();
                }
                nl.appendNode(node);
                ++i;
            }
            nodeList = nl;
        }
        return nodeList;
    }

    private static boolean isParentOfElements(Node node) {
        if (node.hasChildNodes()) {
            Node child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeType() != 3) {
                    return false;
                }
                child = child.getNextSibling();
            }
        }
        return true;
    }

    private static Node getNextNode(Node node, Node end, int eo) {
        if (node == end && eo == 0) {
            return null;
        }
        Node next = node.getFirstChild();
        if (next == null) {
            Node parent = node;
            while (parent != null) {
                next = parent.getNextSibling();
                if (next != null) break;
                if (parent.getParentNode() == end && SelectionUtil.getNodeIndex(parent) + 1 >= eo) {
                    return null;
                }
                parent = parent.getParentNode();
            }
        }
        return next != null && (next.getParentNode() != end || SelectionUtil.getNodeIndex(next) < eo) ? next : null;
    }

    private static int getNodeIndex(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return 0;
        }
        NodeList c = parent.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            if (node == c.item(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int calcFlatModelOffset(IDOMNode node, int offset) {
        int flagModelOffset = 0;
        if (node == null) {
            return flagModelOffset;
        }
        if (node.getNodeType() == 3) {
            int newOffset = 0;
            String value = ((IDOMText)node).getNodeValue();
            String valueSource = ((IDOMText)node).getValueSource();
            if (value != null) {
                byte[] bytes = valueSource.getBytes();
                int i = 0;
                while (i < offset && newOffset < valueSource.length()) {
                    if (bytes[newOffset] == 38) {
                        int tempOffset = newOffset + 1;
                        while (tempOffset < valueSource.length()) {
                            if (bytes[tempOffset] == 38) break;
                            if (bytes[tempOffset] == 59) {
                                if (newOffset + 1 >= tempOffset) break;
                                newOffset = tempOffset;
                                break;
                            }
                            ++tempOffset;
                        }
                    }
                    ++newOffset;
                    ++i;
                }
            }
            flagModelOffset = node.getStartOffset() + newOffset;
        } else {
            NodeList children = node.getChildNodes();
            if (children.getLength() == 0) {
                IStructuredDocumentRegion fn;
                flagModelOffset = node.getStartOffset();
                if (!SelectionUtil.isEmptyElementCustomTag(node) && node.isContainer() && (fn = node.getStartStructuredDocumentRegion()) != null) {
                    flagModelOffset = fn.getEndOffset();
                }
            } else if (children.getLength() <= offset) {
                IDOMNode n = (IDOMNode)children.item(children.getLength() - 1);
                flagModelOffset = n.getEndOffset();
            } else {
                IDOMNode n = (IDOMNode)children.item(offset);
                flagModelOffset = n.getStartOffset();
            }
        }
        return flagModelOffset;
    }

    private static boolean isCustomTag(IDOMNode node) {
        if (node instanceof IDOMElement) {
            return !((IDOMElement)node).isGlobalTag();
        }
        return false;
    }

    private static boolean isEmptyElementCustomTag(IDOMNode node) {
        if (SelectionUtil.isCustomTag(node)) {
            return !((IDOMElement)node).hasEndTag();
        }
        return false;
    }

    public static IDOMNode getNodeFromSourceOffset(IStructuredModel model, int offset) {
        IDOMNode node = (IDOMNode)model.getIndexedRegion(offset);
        if (node == null) {
            node = (IDOMNode)model.getIndexedRegion(offset - 1);
        }
        return node;
    }

    public static int calcRangeOffset(IDOMNode node, int flatNodeOffset) {
        int offset = 0;
        if (node != null) {
            if (node.getNodeType() == 3) {
                offset = flatNodeOffset - node.getStartOffset();
                int newOffset = 0;
                String value = ((IDOMText)node).getNodeValue();
                String valueSource = ((IDOMText)node).getValueSource();
                if (value != null) {
                    byte[] bytes = valueSource.getBytes();
                    int i = 0;
                    while (i < offset && newOffset < value.length()) {
                        if (bytes[i] == 38) {
                            int tempOffset = i + 1;
                            while (tempOffset < valueSource.length()) {
                                if (bytes[tempOffset] == 38) break;
                                if (bytes[tempOffset] == 59) {
                                    if (i + 1 >= tempOffset) break;
                                    i = tempOffset;
                                    break;
                                }
                                ++tempOffset;
                            }
                        }
                        ++newOffset;
                        ++i;
                    }
                    offset = newOffset;
                }
            } else {
                NodeList children;
                IStructuredDocumentRegion endFlatNode = node.getEndStructuredDocumentRegion();
                if (endFlatNode != null && flatNodeOffset >= endFlatNode.getStartOffset() && (children = node.getChildNodes()) != null) {
                    offset = node.getChildNodes().getLength();
                }
            }
        }
        return offset;
    }

    private static Point getSelectedStartLengthWithOrder(ISelection sel, boolean structureFirst) {
        SelectionObjects o = SelectionUtil.getSelectedObjectsFromSelection(sel, structureFirst);
        return new Point(o.startNodePos, o.nodeLength);
    }

    public static Point getSelectedStructuredStartLength(ISelection sel) {
        return SelectionUtil.getSelectedStartLengthWithOrder(sel, true);
    }

    public static Point getSelectedFlatStartLength(ISelection sel) {
        return SelectionUtil.getSelectedStartLengthWithOrder(sel, false);
    }

    private static int getSelectedStartPosWithOrder(ISelection sel, boolean structureFirst) {
        if (sel == null || sel.isEmpty()) {
            return -1;
        }
        int structuredStart = -1;
        if (sel instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)sel).getFirstElement();
            if (o instanceof IndexedRegion) {
                structuredStart = ((IndexedRegion)o).getStartOffset();
            } else if (o instanceof ITextRegion) {
                structuredStart = ((ITextRegion)o).getStart();
            }
        }
        int flatStart = -1;
        if (sel instanceof ITextSelection) {
            flatStart = ((ITextSelection)sel).getOffset();
        }
        if (structureFirst) {
            return structuredStart != -1 ? structuredStart : flatStart;
        }
        return flatStart != -1 ? flatStart : structuredStart;
    }

    public static int getSelectedStructuredStartPos(ISelection sel) {
        return SelectionUtil.getSelectedStartPosWithOrder(sel, true);
    }

    public static int getSelectedFlatStartPos(ISelection sel) {
        return SelectionUtil.getSelectedStartPosWithOrder(sel, false);
    }

    public static Object[] getSelectedObjectsFromModel(int offset, int length, IStructuredModel model) {
        Object[] selectedStructures = null;
        if (model != null) {
            IndexedRegion region = model.getIndexedRegion(offset);
            int end = offset + length;
            if (region != null) {
                if (end <= region.getEndOffset()) {
                    selectedStructures = new Object[]{region};
                } else {
                    int maxLength = model.getStructuredDocument().getLength();
                    ArrayList<IndexedRegion> structures = new ArrayList<IndexedRegion>(2);
                    while (region != null && region.getEndOffset() <= end && region.getEndOffset() < maxLength) {
                        structures.add(region);
                        region = model.getIndexedRegion(region.getEndOffset() + 1);
                    }
                    selectedStructures = structures.toArray();
                }
            }
            if (selectedStructures == null && model instanceof IDOMModel) {
                selectedStructures = new Object[]{((IDOMModel)model).getDocument()};
            }
        }
        if (selectedStructures == null) {
            selectedStructures = new Object[]{};
        }
        return selectedStructures;
    }

    public static SelectionObjects getSelectedObjectsFromSelection(ISelection sel, boolean structureFirst) {
        if (sel == null || sel.isEmpty()) {
            return new SelectionObjects(-1, 0, -1, 0, Arrays.asList(new Object[0]));
        }
        int structuredNodeStart = -1;
        int structuredNodeLength = 0;
        int structuredOffset = -1;
        int structuredLength = 0;
        List structuredList = Arrays.asList(new Object[0]);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object o = selection.getFirstElement();
            if (o != null) {
                if (o instanceof IndexedRegion) {
                    structuredNodeStart = ((IndexedRegion)o).getStartOffset();
                } else if (o instanceof ITextRegion) {
                    structuredNodeStart = ((ITextRegion)o).getStart();
                }
                structuredOffset = sel instanceof ITextSelection ? ((ITextSelection)sel).getOffset() : structuredNodeStart;
            }
            Object o2 = null;
            o2 = selection.size() > 1 ? selection.toArray()[selection.size() - 1] : o;
            if (o2 != null) {
                if (o2 instanceof IndexedRegion) {
                    structuredNodeLength = ((IndexedRegion)o2).getEndOffset() - structuredNodeStart;
                } else if (o2 instanceof ITextRegion) {
                    structuredNodeLength = ((ITextRegion)o2).getEnd() - structuredNodeStart;
                }
                structuredLength = sel instanceof ITextSelection ? ((ITextSelection)sel).getLength() : structuredNodeLength;
            }
            structuredList = selection.toList();
        }
        if (structureFirst && structuredNodeStart != -1) {
            return new SelectionObjects(structuredNodeStart, structuredNodeLength, structuredOffset, structuredLength, structuredList);
        }
        int flatStart = -1;
        int flatLength = 0;
        List<Object> flatList = Arrays.asList(new Object[0]);
        if (sel instanceof ITextSelection) {
            flatStart = ((ITextSelection)sel).getOffset();
            flatLength = ((ITextSelection)sel).getLength();
        }
        return flatStart != -1 ? new SelectionObjects(flatStart, flatLength, flatStart, flatLength, flatList) : new SelectionObjects(structuredNodeStart, structuredNodeLength, structuredOffset, structuredLength, structuredList);
    }

    public static class SelectionObjects {
        public int startNodePos;
        public int nodeLength;
        public int startPos;
        public int length;
        public List objects;

        public SelectionObjects(int startNodePos, int nodeLength, int startPos, int length, List objects) {
            this.startNodePos = startNodePos;
            this.nodeLength = nodeLength;
            this.startPos = startPos;
            this.length = length;
            this.objects = objects;
        }
    }
}

