/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.utils.EditNodeUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReadOnlySupport {
    public static final Element getChildEditableCommentElement(Node node, boolean recurse) {
        if (node == null) {
            return null;
        }
        if (ReadOnlySupport.isEditableCommentElement(node)) {
            return (Element)node;
        }
        if (recurse) {
            Node child = node.getFirstChild();
            while (child != null) {
                Element e = ReadOnlySupport.getChildEditableCommentElement(child, true);
                if (e != null) {
                    return e;
                }
                child = child.getNextSibling();
            }
        } else {
            Node child = node.getFirstChild();
            while (child != null) {
                if (ReadOnlySupport.isEditableCommentElement(child)) {
                    return (Element)child;
                }
                child = child.getNextSibling();
            }
        }
        return null;
    }

    private static final boolean isEditableCommentElement(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        IDOMElement element = (IDOMElement)node;
        return element.isChildEditable() && element.isCommentTag();
    }

    public static final boolean canEdit(Node node) {
        return node != null ? EditNodeUtil.canEdit(node) : false;
    }

    public static final boolean isRemovableNode(Node node) {
        Node parent = node != null ? node.getParentNode() : null;
        return parent != null ? ReadOnlySupport.isChildEditable(parent) : false;
    }

    public static boolean isChildEditable(Node node) {
        return node != null ? EditNodeUtil.isChildEditable(node) : false;
    }

    public static boolean isDataEditable(Node node) {
        return node != null ? EditNodeUtil.isDataEditable(node) : false;
    }
}

