/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionUtil {
    private static final String[] ENCTYPE_VALUES = new String[]{"text/plain"};
    private static final String[] TARGET_VALUES = new String[]{"_blank", "_parent", "_self", "_top"};
    private static final String[] LABEL_NAME_NAMES = new String[]{"name"};

    private static void collect(Node node, List v, Extractor extractor) {
        if (node != null) {
            extractor.extractAttributes(node, v);
            NodeList children = node.getChildNodes();
            if (children != null) {
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child.getNodeType() == 1) {
                        CollectionUtil.collect(children.item(i), v, extractor);
                    }
                    ++i;
                }
            }
        }
    }

    public static String[] collectAccessKeys(final Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node target, List v) {
                String value;
                if (target != null && target != node && (value = CollectionUtil.getAttributeValue(target, "accesskey")) != null && !v.contains(value) && value.length() == 1) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectEnctypes(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                String value;
                if (node != null && (value = CollectionUtil.getAttributeValue(node, "enctype")) != null && !v.contains(value) && !CollectionUtil.isPredefinedEnctype(value)) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectIDs(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                String value;
                if (node != null && (value = CollectionUtil.getAttributeValue(node, "id")) != null && !v.contains(value) && !CollectionUtil.isPredefinedTarget(value)) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectInputIDs(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                String value;
                if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("INPUT") && (value = CollectionUtil.getAttributeValue(node, "id")) != null && !v.contains(value)) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectLabelname(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                if (node != null && node.getNodeName().equalsIgnoreCase("A")) {
                    String[] attributes = LABEL_NAME_NAMES;
                    int i = 0;
                    while (i < attributes.length) {
                        String value = CollectionUtil.getAttributeValue(node, attributes[i]);
                        if (value != null && !v.contains(value)) {
                            v.add(value);
                        }
                        ++i;
                    }
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectNamename(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                if (node != null && node.getNodeName().equalsIgnoreCase("do")) {
                    String[] attributes = LABEL_NAME_NAMES;
                    int i = 0;
                    while (i < attributes.length) {
                        String value = CollectionUtil.getAttributeValue(node, attributes[i]);
                        if (value != null && !v.contains(value)) {
                            v.add(value);
                        }
                        ++i;
                    }
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectIDsOf(Node node, final String[] tagNames) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                if (node != null) {
                    int i = 0;
                    while (i < tagNames.length) {
                        if (node.getNodeName().equalsIgnoreCase(tagNames[i])) {
                            String value = CollectionUtil.getAttributeValue(node, "id");
                            if (value == null || v.contains(value)) break;
                            v.add(value);
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectNAMEs(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                String value;
                if (node != null && (value = CollectionUtil.getAttributeValue(node, "name")) != null && !v.contains(value) && !CollectionUtil.isPredefinedTarget(value)) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectRadioNames(Node node) {
        if (node == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>();
        Node form = CollectionUtil.findAncestorNode(node, "FORM");
        if (form == null) {
            form = CollectionUtil.findRoot(node);
        }
        if (form == null) {
            String value;
            if (CollectionUtil.isRadio(node) && (value = CollectionUtil.getAttributeValue(node, "name")) != null) {
                v.add(value);
            }
        } else {
            Extractor extractor = new Extractor(){

                @Override
                public void extractAttributes(Node node, List v) {
                    String value;
                    if (CollectionUtil.isRadio(node) && (value = CollectionUtil.getAttributeValue(node, "name")) != null && !v.contains(value)) {
                        v.add(value);
                    }
                }
            };
            CollectionUtil.collect(form, v, extractor);
        }
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectTabIndexes(final Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node target, List v) {
                String value;
                if (target != null && target != node && (value = CollectionUtil.getAttributeValue(target, "tabindex")) != null && !v.contains(value) && CollectionUtil.isValidTabIndex(value)) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static String[] collectTargets(Node node) {
        Node root = CollectionUtil.findRoot(node);
        if (root == null) {
            return null;
        }
        ArrayList v = new ArrayList();
        Extractor extractor = new Extractor(){

            @Override
            public void extractAttributes(Node node, List v) {
                String value;
                if (node != null && (value = CollectionUtil.getAttributeValue(node, "target")) != null && !v.contains(value) && !CollectionUtil.isPredefinedTarget(value)) {
                    v.add(value);
                }
            }
        };
        CollectionUtil.collect(root, v, extractor);
        if (v.size() < 1) {
            return null;
        }
        String[] values = new String[v.size()];
        v.toArray(values);
        return values;
    }

    public static Node findAncestorNode(Node node, String name) {
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase(name)) {
                return node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private static Node findRoot(Node node) {
        EditModelQuery query = EditQueryUtil.getEditQuery(node);
        while (node != null) {
            if (node.getNodeType() == 9) {
                return node;
            }
            if (node.getNodeType() == 11) {
                return node;
            }
            String nodeName = node.getNodeName().toUpperCase(Locale.US);
            if (nodeName.equals("BODY")) {
                return node;
            }
            if (query != null && query.isRenderRoot(node)) {
                return node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private static String getAttributeValue(Node node, String name) {
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Attr attr = ((Element)node).getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return NodeDataAccessor.getAttribute(attr);
    }

    private static boolean isPredefinedEnctype(String value) {
        if (value != null) {
            int i = 0;
            while (i < ENCTYPE_VALUES.length) {
                if (value.equalsIgnoreCase(ENCTYPE_VALUES[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isPredefinedTarget(String value) {
        if (value != null) {
            int i = 0;
            while (i < TARGET_VALUES.length) {
                if (value.equalsIgnoreCase(TARGET_VALUES[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isRadio(Node node) {
        if (node == null || node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("INPUT")) {
            return false;
        }
        Attr attr = ((Element)node).getAttributeNode("type");
        return attr != null && NodeDataAccessor.getAttribute(attr) != null && NodeDataAccessor.getAttribute(attr).equalsIgnoreCase("radio");
    }

    private static boolean isValidTabIndex(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() > 0) {
            String validString = new String("0123456789");
            int j = 0;
            while (j < value.length()) {
                if (validString.indexOf(value.substring(j, j + 1)) == -1) {
                    return false;
                }
                ++j;
            }
        }
        if (value.length() < 5) {
            return true;
        }
        if (value.length() > 5) {
            return false;
        }
        return value.compareTo("32767") <= 0;
    }

    static interface Extractor {
        public void extractAttributes(Node var1, List var2);
    }
}

