/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttributeDataUtil {
    public static Attr getAttributeNode(Element element, String name) {
        if (element != null) {
            return element.getAttributeNode(name);
        }
        return null;
    }

    public static Attr getAttributeNode(Node node, String name) {
        if (node != null && node.getNodeType() == 1) {
            return AttributeDataUtil.getAttributeNode((Element)node, name);
        }
        return null;
    }

    public static String getAttributeValue(Attr attr) {
        if (attr != null) {
            return NodeDataAccessor.getAttribute(attr);
        }
        return null;
    }

    public static Attr[] getAttributesNode(Element element) {
        NamedNodeMap map;
        if (element != null && (map = element.getAttributes()) != null) {
            int len = map.getLength();
            Attr[] attrs = new Attr[len];
            int i = 0;
            while (i < len) {
                Node item = map.item(i);
                if (item != null && item instanceof Attr) {
                    attrs[i] = (Attr)item;
                }
                ++i;
            }
            return attrs;
        }
        return null;
    }

    public static Attr[] getAttributesNode(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return AttributeDataUtil.getAttributesNode((Element)node);
        }
        return null;
    }

    public static String[] getAttributesValue(Node node) {
        Attr[] attrs = AttributeDataUtil.getAttributesNode(node);
        if (attrs != null) {
            String[] values = new String[attrs.length];
            int i = 0;
            while (i < attrs.length) {
                values[i] = AttributeDataUtil.getAttributeValue(attrs[i]);
                ++i;
            }
            return values;
        }
        return null;
    }

    public static String getAttributeValue(Node node) {
        if (node != null && node.getNodeType() == 2) {
            return NodeDataAccessor.getAttribute((Attr)node);
        }
        return null;
    }

    public static String getAttributeValue(Node node, String name) {
        return AttributeDataUtil.getAttributeValue(AttributeDataUtil.getAttributeNode(node, name));
    }

    public static String getChildTextValue(Node node, boolean first) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            if (first) {
                return AttributeDataUtil.getTextValue(children.item(0));
            }
            String value = new String();
            int i = 0;
            while (i < children.getLength()) {
                String childValue = AttributeDataUtil.getTextValue(children.item(i));
                if (childValue != null) {
                    value = String.valueOf(value) + childValue;
                }
                ++i;
            }
            return value.length() > 0 ? value : null;
        }
        return null;
    }

    public static String getCommentValue(Node node) {
        if (node != null) {
            if (node instanceof Comment) {
                return NodeDataAccessor.getCommentData((Comment)node);
            }
            return node.getNodeValue();
        }
        return null;
    }

    public static String getTextValue(Node node) {
        if (node != null) {
            if (node.getNodeType() == 3) {
                return NodeDataAccessor.getTextData((Text)node);
            }
            return node.getNodeValue();
        }
        return null;
    }

    public static int parseInteger(String value, int fallback) {
        if (value != null) {
            try {
                return Integer.parseInt(AttributeDataUtil.parseIntegerString(value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return fallback;
    }

    public static String parseIntegerString(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        char[] p = value.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (!Character.isDigit(p[index])) break;
            ++index;
        }
        if (index == 0) {
            return null;
        }
        if (index < p.length) {
            return value.substring(0, index);
        }
        return value;
    }

    public static String parseSuffixString(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        char[] p = value.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (!Character.isDigit(p[index])) break;
            ++index;
        }
        if (index == 0) {
            return value;
        }
        if (index < p.length) {
            return value.substring(index);
        }
        return null;
    }

    public static String trimForeZeros(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return value;
        }
        char[] p = value.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (p[index] != '0') break;
            ++index;
        }
        if (index == 0) {
            return value;
        }
        if (index < p.length) {
            if (!Character.isDigit(p[index])) {
                return value.substring(index - 1);
            }
            return value.substring(index);
        }
        return "0";
    }
}

