/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.preference;

import com.ibm.etools.webedit.common.preference.BrowserInfo;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class WebeditCommonPrefsTool {
    public static Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Combo createCombo(Composite parent, int iStyle) {
        Combo fCombo = new Combo(parent, iStyle);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        fCombo.setLayoutData((Object)data);
        return fCombo;
    }

    public static Composite createDummyComposite(Composite parent, int numColumns) {
        return WebeditCommonPrefsTool.createGridComposite(parent, numColumns, false, false, true);
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        return WebeditCommonPrefsTool.createGridComposite(parent, numColumns, false, false);
    }

    public static Composite createGridComposite(Composite parent, int numColumns, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        return WebeditCommonPrefsTool.createGridComposite(parent, numColumns, grabExcessHorizontalSpace, grabExcessVerticalSpace, false);
    }

    private static Composite createGridComposite(Composite parent, int numColumns, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, boolean noMargin) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (noMargin) {
            layout.horizontalSpacing = 3;
            layout.verticalSpacing = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = 7;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    public static Label createLabel(Composite parent, String text) {
        return WebeditCommonPrefsTool.createLabel(parent, text, 1);
    }

    public static Label createLabel(Composite parent, String text, int numColumns) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createText(Composite parent, int width, int numColumns) {
        Text text = new Text(parent, 18432);
        GridData data = new GridData(768);
        data.horizontalSpan = numColumns;
        data.widthHint = width;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Link createLink(Composite parent, String text) {
        Link link = new Link(parent, 0);
        link.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        link.setLayoutData((Object)data);
        return link;
    }

    public static Table createList(Composite parent, int iStyle) {
        Table t = new Table(parent, 2052);
        GridData data = new GridData(1808);
        data.heightHint = t.getItemHeight() * 3;
        t.setLayoutData((Object)data);
        return t;
    }

    public static Button createPushButton(Composite parent, String label) {
        return WebeditCommonPrefsTool.createPushButton(parent, label, true);
    }

    public static Button createPushButton(Composite parent, String label, boolean fill) {
        Button button = new Button(parent, 8);
        button.setText(label);
        if (fill) {
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            button.setLayoutData((Object)data);
        }
        return button;
    }

    public static Button createRadioButton(Composite group, String label) {
        Button button = new Button(group, 16400);
        button.setText(label);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)data);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return button;
    }

    public static int findComboItem(Combo combo, String str) {
        int icount = combo.getItemCount();
        int i = 0;
        while (i < icount) {
            if (str.equals(combo.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static BrowserInfo[] getBrowserInfo(IPreferenceStore store) {
        String key = "Preferences.browsers";
        int numOfBrowsers = store.getInt(key);
        BrowserInfo[] ret = new BrowserInfo[numOfBrowsers];
        key = WebeditCommonPrefsTool.getPreferencekey("browsers");
        int i = 0;
        while (i < numOfBrowsers) {
            ret[i] = new BrowserInfo();
            String newKey = String.valueOf(key) + Integer.toString(i) + "." + "name";
            ret[i].name = store.getString(newKey);
            newKey = String.valueOf(key) + Integer.toString(i) + "." + "path";
            ret[i].path = store.getString(newKey);
            newKey = String.valueOf(key) + Integer.toString(i) + "." + "sizeSpecified";
            ret[i].sizeSpecified = Boolean.valueOf(store.getString(newKey));
            newKey = String.valueOf(key) + Integer.toString(i) + "." + "width";
            String val = store.getString(newKey);
            if (val != null) {
                ret[i].width = Integer.parseInt(val);
            }
            if ((val = store.getString(newKey = String.valueOf(key) + Integer.toString(i) + "." + "height")) != null) {
                ret[i].height = Integer.parseInt(val);
            }
            ++i;
        }
        return ret;
    }

    public static String getPreferencekey(String group) {
        return "Preferences." + group + ".";
    }

    public static void setHorizontalIndent(Composite composite) {
        WebeditCommonPrefsTool.setHorizontalIndent((Control)composite, 18);
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).horizontalIndent = horizontalIndent;
            } else {
                GridData gridData = new GridData();
                gridData.horizontalIndent = horizontalIndent;
                control.setLayoutData((Object)gridData);
            }
        }
    }
}

