/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.page;

import com.ibm.etools.webedit.common.page.SavePreparation;
import com.ibm.etools.webedit.common.page.SavePreparationFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IEditorPart;

public class SavePreparationFactoryRegistry {
    private static SavePreparationFactoryRegistry registry;
    private List factories = new ArrayList();

    public static SavePreparationFactoryRegistry getInstance() {
        if (registry == null) {
            registry = new SavePreparationFactoryRegistry();
        }
        return registry;
    }

    private SavePreparationFactoryRegistry() {
    }

    public void registerSavePreparationFactory(SavePreparationFactory prepFactory) {
        if (prepFactory != null && !this.factories.contains(prepFactory)) {
            this.factories.add(prepFactory);
        }
    }

    public void unregisterSavePreparationFactory(SavePreparationFactory prepFactory) {
        if (prepFactory != null && this.factories != null) {
            this.factories.remove(prepFactory);
        }
    }

    public List getPreparationsFor(IEditorPart pageDesigner) {
        ArrayList<SavePreparation> preparations = new ArrayList<SavePreparation>();
        Iterator it = this.factories.iterator();
        while (it.hasNext()) {
            SavePreparation[] preps = ((SavePreparationFactory)it.next()).getSavePreparations(pageDesigner);
            int i = 0;
            while (preps != null && i < preps.length) {
                if (preps[i] != null && !preparations.contains(preps[i])) {
                    preparations.add(preps[i]);
                }
                ++i;
            }
        }
        return preparations;
    }
}

