/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.preference;

import com.ibm.etools.webedit.common.internal.preference.ICompactedPropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.progress.UIJob;

public class PreferenceUpdateJob
implements IPropertyChangeListener {
    private IJobChangeListener jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            if (PreferenceUpdateJob.this.job != null) {
                PreferenceUpdateJob.this.job.done();
            }
        }
    };
    private PreferenceJob job;
    private volatile ListenerList compactedPropertyChangeListeners = new ListenerList();
    private IPreferenceStore store;

    public PreferenceUpdateJob(IPreferenceStore store) {
        this.store = store;
    }

    public void addCompactedPropertyChangeListener(ICompactedPropertyChangeListener l) {
        this.compactedPropertyChangeListeners.add((Object)l);
        if (this.compactedPropertyChangeListeners.size() == 1) {
            this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void removeCompactedPropertyChangeListener(ICompactedPropertyChangeListener l) {
        this.compactedPropertyChangeListeners.remove((Object)l);
        if (this.compactedPropertyChangeListeners.size() == 0) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
            if (this.job != null) {
                this.job.done();
                this.job.removeJobChangeListener(this.jobListener);
                this.job.cancel();
                this.job = null;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.job == null || this.job.getState() == 4 && !this.job.isDone()) {
            ArrayList pending = null;
            if (this.job != null) {
                pending = this.job.getPendingEvents();
                this.job.done();
                this.job.removeJobChangeListener(this.jobListener);
                this.job.cancel();
                this.job = null;
            }
            this.job = new PreferenceJob(event);
            this.job.addJobChangeListener(this.jobListener);
            if (pending == null) {
                this.job.schedule(300L);
            } else {
                Iterator itr = pending.iterator();
                while (itr.hasNext()) {
                    this.job.reschedule((PropertyChangeEvent)itr.next(), 300L);
                }
            }
        } else {
            this.job.reschedule(event, 300L);
        }
    }

    private class PreferenceJob
    extends UIJob {
        private volatile ArrayList events;
        private boolean callingListeners;

        public PreferenceJob(PropertyChangeEvent event) {
            super(PreferenceUpdateJob.this.getClass().getName());
            this.events = new ArrayList();
            this.events.add(event);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor != null && monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.isDone()) {
                return Status.CANCEL_STATUS;
            }
            final PropertyChangeEvent[] e = new PropertyChangeEvent[this.events.size()];
            this.events.toArray(e);
            Object[] listeners = PreferenceUpdateJob.this.compactedPropertyChangeListeners.getListeners();
            try {
                this.callingListeners = true;
                int i = 0;
                while (i < listeners.length) {
                    final ICompactedPropertyChangeListener l = (ICompactedPropertyChangeListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() {
                            l.compactedPropertyChange(e);
                        }
                    });
                    ++i;
                }
            }
            finally {
                this.callingListeners = false;
            }
            this.events = new ArrayList();
            return Status.OK_STATUS;
        }

        void reschedule(PropertyChangeEvent event, long delay) {
            this.events.add(event);
            this.schedule(delay);
        }

        void done() {
            this.events = new ArrayList();
        }

        boolean isDone() {
            return this.events.size() == 0;
        }

        ArrayList getPendingEvents() {
            return this.events.size() == 0 || this.callingListeners ? null : this.events;
        }
    }
}

