/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.CleanupTag;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.internal.commands.utils.FormatRange;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class UpdatedNodeFormatter
extends FormatRange {
    private Document domdoc = null;
    private MyNodeList clist = null;
    private MyNodeList flist = null;
    private MyXMLModelNotifier myNotifier = null;

    public UpdatedNodeFormatter(Document doc) {
        this.domdoc = doc;
        this.flist = new MyNodeList(doc);
        this.clist = new MyNodeList(doc);
    }

    public void activate() {
        if (this.domdoc == null || !(this.domdoc instanceof IDOMNode)) {
            return;
        }
        IDOMModel model = ((IDOMNode)this.domdoc).getModel();
        if (model == null) {
            return;
        }
        this.myNotifier = new MyXMLModelNotifier(model.getModelNotifier());
        model.setModelNotifier((XMLModelNotifier)this.myNotifier);
    }

    public Node appendCleanupNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        return this.clist.appendNode(node);
    }

    public Node appendFormatNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        return this.flist.appendNode(node);
    }

    public void cleanupHtml(Range range) {
        CleanupTag clean = new CleanupTag(range);
        int i = 0;
        while (i < this.clist.getLength()) {
            clean.cleanup(this.clist.item(i));
            ++i;
        }
    }

    public void clear() {
        this.flist.clear();
        this.clist.clear();
    }

    public void deactivate() {
        if (this.domdoc == null || !(this.domdoc instanceof IDOMNode)) {
            return;
        }
        if (this.myNotifier == null) {
            return;
        }
        IDOMModel model = ((IDOMNode)this.domdoc).getModel();
        if (model == null) {
            return;
        }
        XMLModelNotifier notifier = this.myNotifier.getOriginalNotifier();
        model.setModelNotifier(notifier);
    }

    public void format(Range range) {
        this.flist.normalize();
        int numNode = this.flist.getLength();
        int i = 0;
        while (i < numNode) {
            this.formatNode(this.flist.item(i), range);
            ++i;
        }
        this.flist.clear();
    }

    public Node removeCleanupNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        return this.clist.removeNode(node);
    }

    public Node removeFormatNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        return this.flist.removeNode(node);
    }

    class MyNodeList
    implements NodeList {
        private Vector nodes = null;
        private EditModelQuery query = null;
        private Document mydoc = null;

        public MyNodeList(Document mydoc) {
            this.mydoc = mydoc;
            this.query = EditQueryUtil.getEditQuery(mydoc);
        }

        public MyNodeList cloneList() {
            int len = this.nodes != null ? this.nodes.size() : 0;
            MyNodeList ret = new MyNodeList(this.mydoc);
            int i = 0;
            while (i < len) {
                ret.appendNode((Node)this.nodes.get(i));
                ++i;
            }
            return ret;
        }

        @Override
        public int getLength() {
            if (this.nodes == null) {
                return 0;
            }
            return this.nodes.size();
        }

        @Override
        public Node item(int i) {
            if (this.nodes == null) {
                return null;
            }
            if (i < 0 || i >= this.getLength()) {
                return null;
            }
            return (Node)this.nodes.get(i);
        }

        private Node removeNode(Node node) {
            if (this.nodes != null && this.nodes.remove(node)) {
                return node;
            }
            return null;
        }

        private void removeNode(int i) {
            if (this.nodes == null) {
                return;
            }
            if (i < 0 || i >= this.getLength()) {
                return;
            }
            this.nodes.remove(i);
        }

        private Node appendNode(Node node) {
            if (node == null) {
                return null;
            }
            int len = this.getLength();
            int i = 0;
            while (i < len) {
                Node item = this.item(i);
                if (item == node) {
                    return node;
                }
                ++i;
            }
            if (node == null) {
                return null;
            }
            if (this.nodes == null) {
                this.nodes = new Vector();
            }
            this.nodes.add(node);
            return node;
        }

        private boolean normalize() {
            if (this.query == null) {
                return false;
            }
            boolean normalized = false;
            int i = 0;
            while (i < this.getLength()) {
                Node item = this.item(i);
                int j = i + 1;
                while (j < this.getLength()) {
                    Node check = this.item(j);
                    if (this.query.isAncestor(item, check)) {
                        normalized = true;
                        this.removeNode(j);
                        --j;
                    }
                    ++j;
                }
                ++i;
            }
            return normalized;
        }

        private void clear() {
            if (this.nodes == null) {
                return;
            }
            this.nodes.clear();
            this.nodes = null;
        }
    }

    class MyXMLModelNotifier
    implements XMLModelNotifier {
        XMLModelNotifier orgNotifier = null;

        public XMLModelNotifier getOriginalNotifier() {
            return this.orgNotifier;
        }

        public MyXMLModelNotifier(XMLModelNotifier notifier) {
            this.orgNotifier = notifier;
        }

        public void attrReplaced(Element element, Attr newAttr, Attr oldAttr) {
            this.orgNotifier.attrReplaced(element, newAttr, oldAttr);
        }

        public void beginChanging() {
            this.orgNotifier.beginChanging();
        }

        public void beginChanging(boolean newModel) {
            this.orgNotifier.beginChanging(newModel);
        }

        public void childReplaced(Node parentNode, Node newChild, Node oldChild) {
            this.orgNotifier.childReplaced(parentNode, newChild, oldChild);
            if (newChild != null) {
                UpdatedNodeFormatter.this.removeFormatNode(oldChild);
                UpdatedNodeFormatter.this.appendFormatNode(newChild);
                UpdatedNodeFormatter.this.removeCleanupNode(oldChild);
                UpdatedNodeFormatter.this.appendCleanupNode(newChild);
            } else if (oldChild != null) {
                UpdatedNodeFormatter.this.removeFormatNode(oldChild);
                UpdatedNodeFormatter.this.removeCleanupNode(oldChild);
            }
        }

        public void endChanging() {
            this.orgNotifier.endChanging();
        }

        public void endTagChanged(Element element) {
            this.orgNotifier.endTagChanged(element);
        }

        public boolean isChanging() {
            return this.orgNotifier.isChanging();
        }

        public boolean hasChanged() {
            return this.orgNotifier.hasChanged();
        }

        public void propertyChanged(Node node) {
            this.orgNotifier.propertyChanged(node);
            UpdatedNodeFormatter.this.appendFormatNode(node);
            UpdatedNodeFormatter.this.appendCleanupNode(node);
        }

        public void startTagChanged(Element element) {
            this.orgNotifier.startTagChanged(element);
            UpdatedNodeFormatter.this.appendCleanupNode(element);
        }

        public void structureChanged(Node node) {
            this.orgNotifier.structureChanged(node);
            UpdatedNodeFormatter.this.appendFormatNode(node);
            UpdatedNodeFormatter.this.appendCleanupNode(node);
        }

        public void valueChanged(Node node) {
            this.orgNotifier.valueChanged(node);
            UpdatedNodeFormatter.this.appendFormatNode(node);
            UpdatedNodeFormatter.this.appendCleanupNode(node);
        }

        public void editableChanged(Node node) {
            this.orgNotifier.editableChanged(node);
        }

        public void cancelPending() {
            this.orgNotifier.cancelPending();
        }
    }
}

