/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.commands.utils;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.commands.exceptions.HTMLCommandException;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class SourceCommand {
    private IStructuredDocument structuredDocument = null;
    private StyledText styledText = null;
    private NodeFactory factory = null;
    private Document doc = null;

    public SourceCommand(HTMLEditDomain domain, NodeFactory factory, Document doc) {
        if (domain != null) {
            this.styledText = domain.getTextWidget();
            IDOMModel model = domain.getActiveModel();
            if (model != null) {
                this.structuredDocument = model.getStructuredDocument();
            }
        }
        this.factory = factory;
        this.doc = doc;
    }

    public boolean canExecute() {
        if (this.styledText == null || this.doc == null || this.factory == null) {
            return false;
        }
        return this.factory.canCreateNode(this.doc);
    }

    public void doExecute() {
        this.doInsertTag(this.factory, this.doc);
    }

    public void replaceText(String str) {
        if (this.styledText == null) {
            return;
        }
        String sel = this.styledText.getSelectionText();
        Point pt = this.styledText.getSelection();
        if (this.structuredDocument != null && this.structuredDocument.containsReadOnly(pt.x, sel.length())) {
            throw new HTMLCommandException(ResourceHandler._UI_Cannot_edit_selection__The_selection_is_read_only_1);
        }
        this.styledText.replaceTextRange(pt.x, sel.length(), str);
        this.styledText.setSelection(pt.x, pt.x + str.length());
    }

    private void doInsertTag(NodeFactory factory, Document doc) {
        if (this.styledText == null) {
            return;
        }
        IDOMModel model = null;
        if (doc instanceof IDOMNode) {
            model = ((IDOMNode)doc).getModel();
        }
        if (model == null) {
            return;
        }
        Range dummyRange = ((DocumentRange)((Object)doc)).createRange();
        Node node = factory.createNode(doc, dummyRange);
        if (node == null) {
            return;
        }
        ISourceGenerator gen = model.getGenerator();
        if (gen == null) {
            return;
        }
        String rep = null;
        if (node.getNodeType() == 1) {
            if (this.isReplaceSelection(node)) {
                rep = gen.generateSource(node);
            } else {
                String end;
                String sel = this.styledText.getSelectionText();
                rep = gen.generateStartTag((Element)node);
                if (sel != null) {
                    rep = String.valueOf(rep) + sel;
                }
                if ((end = gen.generateEndTag((Element)node)) != null) {
                    rep = String.valueOf(rep) + end;
                }
            }
        } else {
            rep = gen.generateSource(node);
        }
        if (rep != null) {
            this.replaceText(rep);
        }
    }

    private boolean isReplaceSelection(Node node) {
        if (node.getNodeType() != 1) {
            return true;
        }
        Element element = (Element)node;
        EditModelQuery query = EditQueryUtil.getEditQuery(element);
        if (query == null) {
            return true;
        }
        if (query.isSolidElement(node) || query.isEmptyNode(node)) {
            return true;
        }
        String tag = element.getNodeName();
        if (tag.equals("P")) {
            return true;
        }
        if (tag.equals("H1")) {
            return true;
        }
        if (tag.equals("H2")) {
            return true;
        }
        if (tag.equals("H3")) {
            return true;
        }
        if (tag.equals("H4")) {
            return true;
        }
        if (tag.equals("H5")) {
            return true;
        }
        if (tag.equals("H6")) {
            return true;
        }
        if (tag.equals("ADDRESS")) {
            return true;
        }
        if (tag.equals("BLOCKQUOTE")) {
            return true;
        }
        if (tag.equals("PRE")) {
            return true;
        }
        if (tag.equals("UL")) {
            return true;
        }
        if (tag.equals("OL")) {
            return true;
        }
        if (tag.equals("DL")) {
            return true;
        }
        if (tag.equals("HR")) {
            return true;
        }
        if (tag.equals("FORM")) {
            return true;
        }
        if (tag.equals("B")) {
            return false;
        }
        if (tag.equals("I")) {
            return false;
        }
        if (tag.equals("U")) {
            return false;
        }
        if (tag.equals("TT")) {
            return false;
        }
        if (tag.equals("S")) {
            return false;
        }
        if (tag.equals("BLINK")) {
            return false;
        }
        if (tag.equals("SUP")) {
            return false;
        }
        if (tag.equals("SUB")) {
            return false;
        }
        if (tag.equals("EM")) {
            return false;
        }
        if (tag.equals("STRONG")) {
            return false;
        }
        if (tag.equals("CODE")) {
            return false;
        }
        if (tag.equals("SAMP")) {
            return false;
        }
        if (tag.equals("KBD")) {
            return false;
        }
        if (tag.equals("VAR")) {
            return false;
        }
        if (tag.equals("DFN")) {
            return false;
        }
        return !tag.equals("CITE");
    }
}

