/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.DOMTreeWaker;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class FormatRange {
    private IStructuredFormatProcessor formatProcessor;

    private boolean formatNode(Node node) {
        if (node != null && node instanceof IDOMNode) {
            if (node.getNodeType() == 3) {
                return false;
            }
            if (this.formatProcessor == null) {
                this.formatProcessor = new HTMLFormatProcessorImpl();
            }
            int offset = ((IDOMNode)node).getStartOffset();
            int length = ((IDOMNode)node).getEndOffset() - offset;
            this.formatProcessor.formatModel((IStructuredModel)((IDOMNode)node).getModel(), offset, length);
            return true;
        }
        return false;
    }

    protected boolean formatNode(Node node, Range range) {
        RangeKeeper keeper = new RangeKeeper(range);
        boolean rc = this.formatNode(node);
        keeper.restore();
        return rc;
    }

    public boolean formatNodes(NodeList c) {
        if (c == null) {
            return false;
        }
        int i = 0;
        while (i < c.getLength()) {
            Node node = c.item(i);
            this.formatNode(node);
            ++i;
        }
        return true;
    }

    public boolean formatNodes(Range range) {
        if (range == null) {
            return false;
        }
        RangeKeeper keeper = new RangeKeeper(range);
        Node start = range.getStartContainer();
        Node end = range.getEndContainer();
        Node node = start;
        EditModelQuery query = EditQueryUtil.getEditQuery(node);
        if (query == null) {
            return false;
        }
        Node startFormatNode = null;
        Node endFormatNode = null;
        DOMTreeWaker tw = new DOMTreeWaker(node);
        while (node != null) {
            if (startFormatNode == null) {
                startFormatNode = node;
            }
            endFormatNode = node;
            Node next = tw.toNext();
            if (next != null) {
                node = next;
                continue;
            }
            next = tw.toParent();
            if (next == null) continue;
            if (query.isAncestor(next, end)) break;
            startFormatNode = node = next;
            endFormatNode = node;
        }
        node = startFormatNode;
        boolean exit = false;
        while (node != null && !exit) {
            exit = node == endFormatNode;
            Node next = node.getNextSibling();
            this.formatNode(node);
            node = next;
        }
        keeper.restore();
        return true;
    }

    private class RangeKeeper {
        private Range range;
        private Node startParentNode;
        private Node startChildNode;
        private int startOffset;
        private Node endParentNode;
        private Node endChildNode;
        private int endOffset;

        protected RangeKeeper(Range kept) {
            block2: {
                int offset;
                Node container;
                block5: {
                    EditModelQuery query;
                    block3: {
                        block4: {
                            this.range = null;
                            this.startParentNode = null;
                            this.startChildNode = null;
                            this.startOffset = 0;
                            this.endParentNode = null;
                            this.endChildNode = null;
                            this.endOffset = 0;
                            this.range = kept;
                            if (this.range == null) break block2;
                            container = this.range.getStartContainer();
                            offset = this.range.getStartOffset();
                            if (container == null) break block3;
                            if (container.getNodeType() == 3) break block4;
                            this.startParentNode = container;
                            if (!container.hasChildNodes() || (query = EditQueryUtil.getEditQuery(container)) == null || query.isEmptyNode(container) || query.isSolidElement(container)) break block3;
                            this.startChildNode = container.getChildNodes().item(offset);
                            if (this.startChildNode != null) break block3;
                            this.startChildNode = container.getLastChild();
                            this.startOffset = 1;
                            break block3;
                        }
                        this.startParentNode = container.getParentNode();
                        this.startChildNode = container.getPreviousSibling();
                        this.startOffset = offset;
                        while (this.startChildNode != null && this.startChildNode.getNodeType() == 3) {
                            this.startOffset += ((Text)this.startChildNode).getLength();
                            this.startChildNode = this.startChildNode.getPreviousSibling();
                        }
                    }
                    container = this.range.getEndContainer();
                    offset = this.range.getEndOffset();
                    if (container == null) break block2;
                    if (container.getNodeType() == 3) break block5;
                    this.endParentNode = container;
                    if (!container.hasChildNodes() || (query = EditQueryUtil.getEditQuery(container)) == null || query.isEmptyNode(container) || query.isSolidElement(container)) break block2;
                    this.endChildNode = container.getChildNodes().item(offset);
                    if (this.endChildNode != null) break block2;
                    this.endChildNode = container.getLastChild();
                    this.endOffset = 1;
                    break block2;
                }
                this.endParentNode = container.getParentNode();
                this.endChildNode = container.getPreviousSibling();
                this.endOffset = offset;
                while (this.endChildNode != null && this.endChildNode.getNodeType() == 3) {
                    this.endOffset += ((Text)this.endChildNode).getLength();
                    this.endChildNode = this.endChildNode.getPreviousSibling();
                }
            }
        }

        protected void restore() {
            int length;
            Node text;
            Node last;
            int len;
            if (this.range == null) {
                return;
            }
            Node container = this.range.getStartContainer();
            if (container != null) {
                if (container.getNodeType() != 3) {
                    if (this.startChildNode != null) {
                        if (this.startOffset == 0) {
                            this.range.setStartBefore(this.startChildNode);
                        } else {
                            this.range.setStartAfter(this.startChildNode);
                            Node start = this.range.getStartContainer();
                            if (start != null && (len = start.getChildNodes().getLength()) < this.range.getStartOffset()) {
                                this.range.setStart(start, len);
                            }
                        }
                    }
                } else if (container.getParentNode() != null) {
                    int length2 = ((Text)container).getLength();
                    if (this.range.getStartOffset() > length2) {
                        this.range.setStart(container, length2);
                    }
                } else if (this.startParentNode != null) {
                    last = this.startChildNode;
                    Node next = null;
                    next = last != null ? last.getNextSibling() : this.startParentNode.getFirstChild();
                    text = null;
                    while (next != null && next.getNodeType() == 3) {
                        length = ((Text)next).getLength();
                        if (this.startOffset <= length) {
                            text = next;
                            break;
                        }
                        this.startOffset -= length;
                        last = next;
                        next = last.getNextSibling();
                    }
                    if (text != null) {
                        this.range.setStart(text, this.startOffset);
                    } else if (last != null) {
                        this.range.setStartAfter(last);
                    } else {
                        this.range.setStart(this.startParentNode, 0);
                    }
                }
            }
            if ((container = this.range.getEndContainer()) != null) {
                if (container.getNodeType() != 3) {
                    if (this.endChildNode != null) {
                        if (this.endOffset == 0) {
                            this.range.setEndBefore(this.endChildNode);
                        } else {
                            this.range.setEndAfter(this.endChildNode);
                            Node end = this.range.getEndContainer();
                            if (end != null && (len = end.getChildNodes().getLength()) < this.range.getEndOffset()) {
                                this.range.setEnd(end, len);
                            }
                        }
                    }
                } else if (container.getParentNode() != null) {
                    int length3 = ((Text)container).getLength();
                    if (this.range.getEndOffset() > length3) {
                        this.range.setEnd(container, length3);
                    }
                } else if (this.endParentNode != null) {
                    last = this.endChildNode;
                    Node next = null;
                    next = last != null ? last.getNextSibling() : this.endParentNode.getFirstChild();
                    text = null;
                    while (next != null && next.getNodeType() == 3) {
                        length = ((Text)next).getLength();
                        if (this.endOffset <= length) {
                            text = next;
                            break;
                        }
                        this.endOffset -= length;
                        last = next;
                        next = last.getNextSibling();
                    }
                    if (text != null) {
                        this.range.setEnd(text, this.endOffset);
                    } else if (last != null) {
                        this.range.setEndAfter(last);
                    } else {
                        this.range.setEnd(this.endParentNode, 0);
                    }
                }
            }
        }
    }
}

