/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.commands.utils;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.commands.exceptions.HTMLCommandException;
import com.ibm.etools.webedit.common.commands.utils.DOMTreeWaker;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.FragmentQuery;
import com.ibm.etools.webedit.common.internal.commands.utils.CommandDomUtil;
import com.ibm.etools.webedit.common.internal.commands.utils.FragmentDetectorRegistry;
import com.ibm.etools.webedit.common.internal.commands.utils.IFragmentDetector;
import com.ibm.etools.webedit.common.internal.utils.StructuredModelFacade;
import com.ibm.etools.webedit.common.utils.ReadOnlySupport;
import com.ibm.etools.webedit.extension.DesignTimeTagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

abstract class AbstractEditModelQuery
implements EditModelQuery,
INodeAdapter,
FragmentQuery {
    static Map MAPPED_CUSTOM_TAGS = null;
    private Boolean isFragment = null;
    private String fragmentContext = null;
    private Boolean acceptEditAsCompleteDocument = null;
    static NodeList NULL_NODELIST;

    static {
        MAPPED_CUSTOM_TAGS = new HashMap();
        MAPPED_CUSTOM_TAGS.put("portalhtml:html".toLowerCase(Locale.US), "HTML");
        MAPPED_CUSTOM_TAGS.put("portalhtml:body".toLowerCase(Locale.US), "BODY");
        MAPPED_CUSTOM_TAGS.put("portalhtml:head".toLowerCase(Locale.US), "HEAD");
        MAPPED_CUSTOM_TAGS.put("portal-html:html".toLowerCase(Locale.US), "HTML");
        MAPPED_CUSTOM_TAGS.put("portal-html:body".toLowerCase(Locale.US), "BODY");
        MAPPED_CUSTOM_TAGS.put("portal-html:head".toLowerCase(Locale.US), "HEAD");
        MAPPED_CUSTOM_TAGS.put("html:html".toLowerCase(Locale.US), "HTML");
        NULL_NODELIST = new SingleNodeList(null);
    }

    AbstractEditModelQuery() {
    }

    private void addContent(List contentList, CMContent content) {
        if (content == null) {
            return;
        }
        if (content instanceof CMGroup) {
            CMNodeList children = ((CMGroup)content).getChildNodes();
            if (children == null) {
                return;
            }
            int i = 0;
            while (i < children.getLength()) {
                CMNode child = children.item(i);
                if (child.getNodeType() == 5) {
                    contentList.add(child);
                } else if (child.getNodeType() == 7) {
                    this.addContent(contentList, (CMContent)child);
                } else {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
        } else {
            contentList.add(content);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean canContainByElementDeclaration(CMElementDeclaration decl, Node child) {
        if (decl == null) {
            return true;
        }
        contentType = decl.getContentType();
        child_decl = this.getCMElementDeclaration(child);
        childType = child.getNodeType();
        switch (contentType) {
            case 0: {
                return true;
            }
            case 5: {
                if (childType == 4) {
                    return true;
                }
                if (childType != 3) break;
                return true;
            }
            case 4: {
                if (childType == 3) {
                    return true;
                }
                if (childType == 8) {
                    return true;
                }
                if (this.isJsp(child_decl) || this.isSsi(child_decl)) {
                    return true;
                }
                cnode = child_decl;
                if (cnode == null) break;
                if (cnode instanceof TLDElementDeclaration) {
                    return true;
                }
                if (!(cnode instanceof CMNodeWrapper) || (c = ((CMNodeWrapper)cnode).getOriginNode()) == cnode) break;
                cnode = c;
                break;
            }
            case 1: {
                return false;
            }
            case 2: 
            case 3: {
                if (childType != 1) ** GOTO lbl48
                if (child_decl == null) {
                    return true;
                }
                if (this.isJsp(child_decl) || this.isSsi(child_decl)) {
                    return true;
                }
                child_prefix = child.getPrefix();
                if (child_prefix != null && child_prefix.equals("METADATA")) {
                    return true;
                }
                cnode = child_decl;
                while (cnode != null) {
                    if (cnode instanceof TLDElementDeclaration) {
                        return true;
                    }
                    if (cnode instanceof CMNodeWrapper && (c = ((CMNodeWrapper)cnode).getOriginNode()) != cnode) {
                        cnode = c;
                        continue;
                    }
                    ** GOTO lbl55
                }
                ** GOTO lbl55
lbl48:
                // 1 sources

                if (childType == 8) {
                    return true;
                }
                if (childType == 3) {
                    if (this.isEmptyText((Text)child)) {
                        return true;
                    }
                    if (contentType == 3) {
                        return true;
                    }
                }
lbl55:
                // 6 sources

                v0 = num = (childList = this.getAvailableChildNodes(decl)) != null ? childList.size() : 0;
                if (num <= 0) {
                    return false;
                }
                i = 0;
                while (i < num) {
                    content = (CMContent)childList.get(i);
                    if (content.getNodeName().equalsIgnoreCase(child.getNodeName())) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    String getMappedElementName(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Object value = MAPPED_CUSTOM_TAGS.get(node.getNodeName().toLowerCase(Locale.US));
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean canContain(Node parent, Node child) {
        if (child == null) {
            return false;
        }
        if (DesignTimeTagUtil.isBodyContentEmpty(parent)) {
            return false;
        }
        Node orgParent = parent;
        while (parent != null && this.isLogicalElement(parent)) {
            parent = parent.getParentNode();
        }
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() == 9) {
            if (this.isFragment(AbstractEditModelQuery.getSafeDocument(parent))) {
                return true;
            }
            if (this.isHeadChildElement(child)) {
                Node head = this.getHeadCorrespondentNode(parent, false);
                while (orgParent != parent) {
                    if (orgParent == head) {
                        return true;
                    }
                    orgParent = orgParent.getParentNode();
                }
                if (parent == head) {
                    return true;
                }
            } else {
                Node render = this.getRenderRootNode(parent, false);
                while (orgParent != parent) {
                    if (orgParent == render) {
                        return true;
                    }
                    orgParent = orgParent.getParentNode();
                }
                if (parent == render) {
                    return true;
                }
            }
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(parent);
        if (decl == null) {
            return true;
        }
        if (!this.canContainByElementDeclaration(decl, child)) {
            if (child.getNodeName().equalsIgnoreCase("DEL") || child.getNodeName().equalsIgnoreCase("INS")) {
                while (parent != null) {
                    if (this.isRenderRoot(parent)) break;
                    if (parent.getNodeName().equalsIgnoreCase(this.getHtmlElementName(AbstractEditModelQuery.getSafeDocument(parent)))) {
                        return false;
                    }
                    parent = parent.getParentNode();
                }
                return true;
            }
            return false;
        }
        Node node = parent;
        while (node != null) {
            this.isIncluded(node, child);
            if (this.isExcluded(node, child)) {
                return false;
            }
            node = node.getParentNode();
        }
        return true;
    }

    @Override
    public boolean canContainText(Node node) {
        if (node == null || node.getNodeType() != 1 && node.getNodeType() != 9) {
            return false;
        }
        Document doc = AbstractEditModelQuery.getSafeDocument(node);
        Text text = doc.createTextNode("#");
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return false;
        }
        return query.canContain(node, text);
    }

    @Override
    public boolean canMergeBlock(Node block) {
        if (block == null) {
            return false;
        }
        if (block.getNodeType() != 1) {
            return false;
        }
        String str = block.getNodeName();
        return !this.isBodyElement(block) && !str.equalsIgnoreCase("TD") && !str.equalsIgnoreCase("TH") && !str.equalsIgnoreCase("CAPTION") && !str.equalsIgnoreCase("FORM") && !str.equalsIgnoreCase("BUTTON");
    }

    @Override
    public boolean canRemoveByDelkey(Node node, boolean withChildren) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return true;
        }
        String sAttr = ((Element)node).getAttribute("type");
        if (sAttr != null && sAttr.equalsIgnoreCase("hidden")) {
            return false;
        }
        if (((Element)node).getNodeName().equalsIgnoreCase("MAP")) {
            return false;
        }
        Element element = (Element)node;
        if (this.isEmptyNode(element) || this.isSolidElement(element)) {
            return true;
        }
        String adaptiveParent = this.getAdaptParent(element.getNodeName());
        if (adaptiveParent != null && adaptiveParent.length() > 0) {
            Node parent = element.getParentNode();
            while (parent != null) {
                if (parent.getNodeType() == 1 && !this.isLogicalElement(parent)) {
                    String adaptiveChild;
                    if (!parent.getNodeName().equalsIgnoreCase(adaptiveParent) || (adaptiveChild = this.getAdaptChild(parent.getNodeName())) == null || !adaptiveChild.equalsIgnoreCase(element.getNodeName())) break;
                    return false;
                }
                parent = parent.getParentNode();
            }
        }
        if (!withChildren) {
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() != 3) {
                    return false;
                }
                if (!this.isEmptyText((Text)child)) {
                    return false;
                }
                child = child.getNextSibling();
            }
        }
        return true;
    }

    @Override
    public Element createTdElement(Document doc) {
        if (doc == null) {
            return null;
        }
        return doc.createElement("TD");
    }

    @Override
    public Element createTrElement(Document doc) {
        if (doc == null) {
            return null;
        }
        return doc.createElement("TR");
    }

    @Override
    public String getAdaptChild(String str) {
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("HTML") || str.equalsIgnoreCase("NOFRAMES")) {
            return "BODY";
        }
        if (str.equalsIgnoreCase("FRAMESET")) {
            return "NOFRAMES";
        }
        if (str.equalsIgnoreCase("TABLE")) {
            return "TBODY";
        }
        if (str.equalsIgnoreCase("TBODY")) {
            return "TR";
        }
        if (str.equalsIgnoreCase("TR")) {
            return "TD";
        }
        if (str.equalsIgnoreCase("UL") || str.equalsIgnoreCase("OL") || str.equalsIgnoreCase("MENU") || str.equalsIgnoreCase("DIR")) {
            return "LI";
        }
        if (str.equalsIgnoreCase("DL")) {
            return "DD";
        }
        Object mapped = MAPPED_CUSTOM_TAGS.get(str.toLowerCase(Locale.US));
        if (mapped instanceof String) {
            return this.getAdaptChild((String)mapped);
        }
        return null;
    }

    @Override
    public String getAdaptParent(String str) {
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("HEAD") || str.equalsIgnoreCase("BODY") || str.equalsIgnoreCase("FRAMESET")) {
            return "HTML";
        }
        if (str.equalsIgnoreCase("FRAME") || str.equalsIgnoreCase("NOFRAMES")) {
            return "FRAMESET";
        }
        if (str.equalsIgnoreCase("BASE") || str.equalsIgnoreCase("LINK") || str.equalsIgnoreCase("META") || str.equalsIgnoreCase("TITLE") || str.equalsIgnoreCase("STYLE")) {
            return "HEAD";
        }
        if (str.equalsIgnoreCase("THEAD") || str.equalsIgnoreCase("TFOOT") || str.equalsIgnoreCase("TBODY") || str.equalsIgnoreCase("CAPTION") || str.equalsIgnoreCase("COL") || str.equalsIgnoreCase("COLGROUP")) {
            return "TABLE";
        }
        if (str.equalsIgnoreCase("TR")) {
            return "TBODY";
        }
        if (str.equalsIgnoreCase("TH") || str.equalsIgnoreCase("TD")) {
            return "TR";
        }
        if (str.equalsIgnoreCase("LI")) {
            return "UL";
        }
        if (str.equalsIgnoreCase("DD") || str.equalsIgnoreCase("DT")) {
            return "DL";
        }
        if (str.equalsIgnoreCase("OPTION") || str.equalsIgnoreCase("OPTGROUP")) {
            return "SELECT";
        }
        if (str.equalsIgnoreCase("LEGEND")) {
            return "FIELDSET";
        }
        if (str.equalsIgnoreCase("PARAM")) {
            return "OBJECT";
        }
        if (str.equalsIgnoreCase("AREA")) {
            return "MAP";
        }
        if (str.equalsIgnoreCase("NOEMBED")) {
            return "EMBED";
        }
        Object mapped = MAPPED_CUSTOM_TAGS.get(str.toLowerCase(Locale.US));
        if (mapped instanceof String) {
            return this.getAdaptParent((String)mapped);
        }
        return null;
    }

    private List getAvailableChildNodes(CMElementDeclaration ed) {
        if (ed == null) {
            return null;
        }
        Vector content = new Vector();
        this.addContent(content, ed.getContent());
        return content;
    }

    public Element getBodyElement(Document doc) {
        return this.getBodyElement(doc, false);
    }

    @Override
    public String getBaseLocation(Node node) {
        IDOMModel model;
        if (node != null && node instanceof IDOMNode && (model = ((IDOMNode)node).getModel()) != null) {
            return StructuredModelFacade.getBaseLocation((IStructuredModel)model);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Element getBodyElement(Document doc, boolean create) {
        if (doc == null) {
            return null;
        }
        iter = ((DocumentTraversal)doc).createNodeIterator(doc, 1, null, false);
        if (iter != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            if (!this.isBodyElement(node)) continue;
            return (Element)node;
lbl8:
            // 2 sources

            ** while ((node = iter.nextNode()) != null)
        }
lbl9:
        // 1 sources

        if (create) {
            if (this.isFragment(doc) && !this.acceptEditingAsComplete()) {
                throw new HTMLCommandException(ResourceHandler._UI_This_document_is_treated_as_fragment_file_so_you_cannot_insert__body__tag__5);
            }
            html = this.getHtmlElement(doc, true);
            if (html == null) {
                return null;
            }
            head = this.getHeadElement(doc, false);
            noframes = null;
            framesetList = html.getElementsByTagName("FRAMESET");
            if (framesetList != null && framesetList.getLength() > 0) {
                frameset = (Element)framesetList.item(0);
                parent = frameset.getParentNode();
                while (parent != null && parent != html) {
                    if (parent.getNodeType() == 1 && parent.getNodeName().equalsIgnoreCase("FRAMESET")) {
                        frameset = (Element)parent;
                    }
                    parent = parent.getParentNode();
                }
                noframesList = frameset.getElementsByTagName("NOFRAMES");
                if (noframesList == null || noframesList.getLength() == 0) {
                    noframes = doc.createElement("NOFRAMES");
                    frameset.appendChild(noframes);
                } else {
                    noframes = (Element)noframesList.item(0);
                }
            }
            body = doc.createElement(this.getBodyElementName(doc));
            if (noframes != null) {
                noframes.appendChild(body);
            } else if (head == null) {
                html.appendChild(body);
                headRange = this.getHeadCorrespondentRange(doc);
                if (headRange != null) {
                    child = headRange.getEndContainer().getChildNodes().item(headRange.getEndOffset() - 1);
                    if (child == null) {
                        child = headRange.getEndContainer();
                    }
                    while (child != null) {
                        if (child.getParentNode() == html) break;
                        child = child.getParentNode();
                    }
                    while (child != null) {
                        if ((child = child.getNextSibling()) == null || child.getNodeType() != 3 || !this.isEmptyText((Text)child)) break;
                    }
                    if (child == null) {
                        child = html.getFirstChild();
                    }
                    while (child != body) {
                        next = child.getNextSibling();
                        body.appendChild(child);
                        child = next;
                    }
                } else {
                    child = html.getFirstChild();
                    while (child != body) {
                        next = child.getNextSibling();
                        body.appendChild(child);
                        child = next;
                    }
                }
            } else {
                child = head.getNextSibling();
                while (child != null) {
                    if (child.getNodeType() != 3 || !this.isEmptyText((Text)child)) break;
                    child = child.getNextSibling();
                }
                head.getParentNode().insertBefore(body, child);
                while (child != null) {
                    next = child.getNextSibling();
                    body.appendChild(child);
                    child = next;
                }
            }
            this.flushFragmentCache();
            return body;
        }
        return null;
    }

    @Override
    public int getChildIndex(Node node) {
        Node parent;
        Node node2 = parent = node != null ? node.getParentNode() : null;
        if (parent == null) {
            return -1;
        }
        NodeList c = parent.getChildNodes();
        if (c == null) {
            return -1;
        }
        int i = 0;
        while (i < c.getLength()) {
            Node child = c.item(i);
            if (child == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final CMElementDeclaration getCMElementDeclaration(Node node) {
        CMNode n;
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        CMElementDeclaration decl = this.getElementDeclaration(node);
        if (decl != null && decl instanceof CMNodeWrapper && (n = ((CMNodeWrapper)decl).getOriginNode()) instanceof TLDElementDeclaration) {
            return (CMElementDeclaration)n;
        }
        return decl;
    }

    private final CMElementDeclaration getElementDeclaration(Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)AbstractEditModelQuery.getSafeDocument(node));
        String mappedName = this.getMappedElementName(node);
        return modelQuery != null ? modelQuery.getCMElementDeclaration(mappedName == null ? (Element)node : AbstractEditModelQuery.getSafeDocument(node).createElement(mappedName)) : null;
    }

    @Override
    public final CMElementDeclaration getElementDeclaration(String tagName, Document document) {
        if (tagName == null || document == null) {
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery == null) {
            return null;
        }
        CMDocument cmdoc = null;
        Element element = document.createElement(tagName);
        cmdoc = modelQuery.getCorrespondingCMDocument((Node)element);
        if (cmdoc == null) {
            cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
        }
        if (cmdoc == null) {
            return null;
        }
        CMNamedNodeMap map = cmdoc.getElements();
        if (map == null) {
            return null;
        }
        return (CMElementDeclaration)map.getNamedItem(tagName);
    }

    public boolean isExcludedTagTarget(Node parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        String name = parent.getNodeName();
        return name.equalsIgnoreCase("FORM") || name.equalsIgnoreCase("BUTTON");
    }

    @Override
    public Vector getExcludedTagNames(Node parent) {
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() != 1) {
            return null;
        }
        Vector<String> ret = null;
        if (parent.getNodeName().equalsIgnoreCase("FORM")) {
            ret = new Vector<String>();
            ret.add("FORM");
        } else if (parent.getNodeName().equalsIgnoreCase("BUTTON")) {
            ret = new Vector();
            ret.add("FORM");
            ret.add("INPUT");
            ret.add("TEXTAREA");
            ret.add("SELECT");
            ret.add("FIELDSET");
            ret.add("BUTTON");
            ret.add("A");
        }
        return ret;
    }

    public Element getHeadElement(Document doc, boolean create) {
        if (doc == null) {
            return null;
        }
        NodeList c = doc.getElementsByTagName(this.getHeadElementName(doc));
        if (c != null) {
            int i = c.getLength() - 1;
            while (i >= 0) {
                Element element = (Element)c.item(i);
                if (element != null) {
                    Node n = element;
                    while (n != null) {
                        if (n.getNodeType() == 1 && n.getNodeName().equalsIgnoreCase(this.getHeadElementName(doc))) {
                            element = n;
                        }
                        n = n.getParentNode();
                    }
                    return element;
                }
                --i;
            }
        }
        if (create) {
            if (this.isFragment(doc) && !this.acceptEditingAsComplete()) {
                throw new HTMLCommandException(ResourceHandler._UI_This_document_is_treated_as_fragment_file_so_you_cannot_insert__head__tag__6);
            }
            DocumentQuery.InsertionTarget target = this.getHeadInsertionTarget(doc);
            if (target != null) {
                Element head = doc.createElement(this.getHeadElementName(doc));
                target.getParent().insertBefore(head, target.getRef());
                Node child = target.getParent().getFirstChild();
                boolean startHeadChild = false;
                while (child != null) {
                    Node next = child.getNextSibling();
                    if (child == head) break;
                    boolean keepOut = false;
                    if (!startHeadChild && this.canLocateOutsideHtmlElement(child)) {
                        keepOut = true;
                    } else if (this.isHeadChildElement(child)) {
                        head.appendChild(child);
                    } else if (child.getNodeType() == 3 && this.isEmptyText((Text)child)) {
                        head.appendChild(child);
                    } else {
                        if (this.isStaticTag(child)) break;
                        head.appendChild(child);
                    }
                    child = next;
                    if (keepOut) continue;
                    startHeadChild = true;
                }
                this.flushFragmentCache();
                return head;
            }
            Element html = this.getHtmlElement(doc, true);
            if (html == null) {
                return null;
            }
            Element body = this.getBodyElement(doc, false);
            Element head = doc.createElement(this.getHeadElementName(doc));
            Node parent = body != null ? body.getParentNode() : html;
            Node child = parent.getFirstChild();
            parent.insertBefore(head, parent.getFirstChild());
            boolean startHeadChild = false;
            while (child != null) {
                Node next = child.getNextSibling();
                boolean keepOut = false;
                if (!startHeadChild && this.canLocateOutsideHtmlElement(child)) {
                    keepOut = true;
                } else if (this.isHeadChildElement(child)) {
                    head.appendChild(child);
                } else {
                    if (child.getNodeType() != 3 || !this.isEmptyText((Text)child)) break;
                    head.appendChild(child);
                }
                child = next;
                if (keepOut) continue;
                startHeadChild = true;
            }
            this.flushFragmentCache();
        }
        return null;
    }

    public Element getHtmlElement(Document doc) {
        return this.getHtmlElement(doc, false);
    }

    /*
     * Unable to fully structure code
     */
    public Element getHtmlElement(Document doc, boolean create) {
        if (doc == null) {
            return null;
        }
        docElement = doc.getDocumentElement();
        if (docElement != null && !docElement.getTagName().equals("jsp:root") && this.isHtmlElement(docElement)) {
            return docElement;
        }
        iter = ((DocumentTraversal)doc).createNodeIterator(doc, 1, null, false);
        if (iter != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            if (node.getNodeType() != 1 || !this.isHtmlElement(node)) continue;
            return (Element)node;
lbl11:
            // 2 sources

            ** while ((node = iter.nextNode()) != null)
        }
lbl12:
        // 1 sources

        if (create) {
            if (this.isFragment(doc) && !this.acceptEditingAsComplete()) {
                throw new HTMLCommandException(ResourceHandler._UI_This_document_is_treated_as_fragment_file_so_you_cannot_insert__html__tag__7);
            }
            html = doc.createElement(this.getHtmlElementName(doc));
            parent = null;
            parent = docElement != null && docElement.getTagName().equals("jsp:root") != false ? docElement : doc;
            parent.appendChild(html);
            child = parent.getFirstChild();
            while (child != null) {
                if (child.equals(html)) {
                    child = null;
                    break;
                }
                if (!this.canLocateOutsideHtmlElement(child)) break;
                child = child.getNextSibling();
            }
            while (child != null) {
                if (child.equals(html)) break;
                next = child.getNextSibling();
                html.appendChild(child);
                child = next;
            }
            this.flushFragmentCache();
            return html;
        }
        return null;
    }

    @Override
    public boolean canLocateOutsideHtmlElement(Node node) {
        String nodeName;
        short nodeType = node.getNodeType();
        if (nodeType == 3) {
            if (!this.isEmptyText((Text)node)) {
                return false;
            }
        } else if (!(nodeType != 1 || (nodeName = node.getNodeName()).equals("jsp:directive.page") || nodeName.equals("jsp:directive.taglib") || nodeName.equals("jsp:useBean") || nodeName.equals("jsp:declaration") || nodeName.equals("jsp:text") || nodeName.equals("jsp:scriptlet"))) {
            return node instanceof IDOMElement && ((IDOMElement)node).isCommentTag() && !this.hasElementOrText((Element)node);
        }
        return true;
    }

    @Override
    public boolean canLocateOutsideBodyElement(Node node) {
        return this.canLocateOutsideHtmlElement(node) || this.isHeadChildElement(node) || this.isHeadElement(node);
    }

    public Vector getIncludedTagNames(Node parent) {
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() != 1) {
            return null;
        }
        CMElementDeclaration cm_decl = this.getCMElementDeclaration(parent);
        if (cm_decl == null) {
            return null;
        }
        if (!cm_decl.supports("prohibitedAncestors")) {
            return null;
        }
        Object obj = cm_decl.getProperty("prohibitedAncestors");
        if (obj == null || !(obj instanceof CMNamedNodeMap)) {
            return null;
        }
        CMNamedNodeMap map = (CMNamedNodeMap)obj;
        Vector<String> ret = null;
        int len = map.getLength();
        if (len > 0) {
            int i = 0;
            while (i < len) {
                String str;
                CMContent content = (CMContent)map.item(i);
                String string = str = content != null ? content.getNodeName() : null;
                if (str != null) {
                    if (ret == null) {
                        ret = new Vector<String>();
                    }
                    ret.add(str);
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    private Node getNextNode(Node node, DOMTreeWaker tw) {
        Node next;
        if (node == null && tw == null) {
            return null;
        }
        if (tw == null) {
            tw = new DOMTreeWaker(node);
        }
        while ((next = tw.toNext()) == null && (next = tw.toParent()) != null) {
        }
        return next;
    }

    @Override
    public Node getNextNode(Node node, boolean ignoreChild) {
        return this.getNextNode(node, ignoreChild, false);
    }

    @Override
    public Node getNextNode(Node node, boolean ignoreChild, boolean ignoreOffspring) {
        if (node == null) {
            return null;
        }
        DOMTreeWaker tw = new DOMTreeWaker(node);
        Node next = node;
        do {
            Node child;
            if (ignoreChild) continue;
            while ((child = tw.toFirstChild()) != null) {
                next = child;
                if (!ignoreOffspring) continue;
            }
        } while (next == node && (next = this.getNextNode(null, tw)) != null);
        return next;
    }

    public Node getPreviousNode(Node node, boolean ignorechild) {
        if (node == null) {
            return null;
        }
        DOMTreeWaker tw = new DOMTreeWaker(node);
        boolean checkChild = !ignorechild;
        Node p = node;
        while (true) {
            if (checkChild && p.hasChildNodes()) {
                while (p.hasChildNodes()) {
                    p = tw.toLastChild();
                }
                if (p != null) {
                    return p;
                }
            }
            if ((p = tw.toPrevious()) != null) {
                if (!ignorechild && p.hasChildNodes()) {
                    while (p.hasChildNodes()) {
                        p = tw.toLastChild();
                    }
                    if (p != null) {
                        return p;
                    }
                }
                return p;
            }
            p = tw.toParent();
            if (p == null) break;
            checkChild = false;
        }
        return p;
    }

    @Override
    public String[] getRemovedAttributesForNewCell() {
        String[] attrs = new String[]{"id"};
        return attrs;
    }

    @Override
    public String getTableElementName() {
        return "TABLE";
    }

    @Override
    public String getTbodyElementName() {
        return "TBODY";
    }

    @Override
    public String getTdElementName() {
        return "TD";
    }

    @Override
    public String getTrElementName() {
        return "TR";
    }

    @Override
    public String getTextSource(Node root, boolean crlf) {
        if (root == null) {
            return null;
        }
        String ret = "";
        boolean checkChild = true;
        if (root.getNodeType() == 1) {
            if (crlf && root.getNodeName().equalsIgnoreCase("BR")) {
                ret = String.valueOf(ret) + "\r\n";
            } else if (this.isSolidElement(root) || this.isEmptyNode(root)) {
                checkChild = false;
            }
        } else if (root.getNodeType() == 3) {
            ret = root instanceof IDOMText ? String.valueOf(ret) + ((IDOMText)root).getValueSource() : String.valueOf(ret) + ((Text)root).getData();
        }
        if (checkChild) {
            Node child = root.getFirstChild();
            while (child != null) {
                ret = String.valueOf(ret) + this.getTextSource(child, crlf);
                child = child.getNextSibling();
            }
        }
        return ret;
    }

    private TLDElementDeclaration getTLDElementDeclaration(Element element) {
        CMElementDeclaration decl = this.getElementDeclaration(element);
        if (decl != null && decl instanceof CMNodeWrapper) {
            TLDElementDeclaration d;
            CMNode n = ((CMNodeWrapper)decl).getOriginNode();
            try {
                d = (TLDElementDeclaration)n;
            }
            catch (ClassCastException classCastException) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return null;
    }

    @Override
    public boolean isEqual(Element elm1, Element elm2) {
        CommandDomUtil util = CommandDomUtil.getInstance();
        return util.isEqual(elm1, elm2);
    }

    @Override
    public boolean isAncestor(Node ans, Node child) {
        CommandDomUtil util = CommandDomUtil.getInstance();
        return util.isAncestor(ans, child);
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(AbstractEditModelQuery.class) || type.equals(EditModelQuery.class);
    }

    @Override
    public boolean isAlignTarget(Node node) {
        return this.isBlockElement(node);
    }

    private CMAttributeDeclaration getAttributeDeclaration(CMElementDeclaration decl, String attr) {
        if (decl == null) {
            return null;
        }
        CMNamedNodeMap map = decl.getAttributes();
        if (map == null) {
            return null;
        }
        CMNode cmnode = map.getNamedItem(attr);
        if (cmnode == null || !(cmnode instanceof CMAttributeDeclaration)) {
            return null;
        }
        return (CMAttributeDeclaration)cmnode;
    }

    private CMAttributeDeclaration getAttributeDeclaration(Element element, String attr) {
        if (element == null) {
            return null;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(element);
        return this.getAttributeDeclaration(decl, attr);
    }

    public boolean isElementAvailable(Element element) {
        CMElementDeclaration decl = this.getCMElementDeclaration(element);
        return decl != null;
    }

    @Override
    public boolean isAttributeAvailable(Element element, String attr) {
        CMAttributeDeclaration attr_decl = this.getAttributeDeclaration(element, attr);
        return attr_decl != null;
    }

    @Override
    public boolean isAttributeAvailable(String tagName, String attr, Document doc) {
        CMElementDeclaration decl = this.getElementDeclaration(tagName, doc);
        CMAttributeDeclaration attr_decl = this.getAttributeDeclaration(decl, attr);
        return attr_decl != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAttributeValueAvailable(Element element, String attr, String Value) {
        CMAttributeDeclaration attr_decl = this.getAttributeDeclaration(element, attr);
        if (attr_decl == null) {
            return false;
        }
        boolean rc = true;
        try {
            CMDataType cmDataType = attr_decl.getAttrType();
            if (cmDataType == null) {
                return false;
            }
            String attr_type = cmDataType.getDataTypeName();
            if (!attr_type.equalsIgnoreCase("ENUM")) return rc;
            String[] values = cmDataType.getEnumeratedValues();
            if (values == null) {
                return false;
            }
            int j = 0;
            while (true) {
                if (j >= values.length) {
                    return rc;
                }
                rc = false;
                if (Value.compareToIgnoreCase(values[j]) == 0) {
                    return true;
                }
                ++j;
            }
        }
        catch (NullPointerException nullPointerException) {
            return rc;
        }
        catch (ClassCastException classCastException) {}
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAttributeValueAvailable(String tagName, String attr, String Value, Document doc) {
        CMElementDeclaration decl = this.getElementDeclaration(tagName, doc);
        CMAttributeDeclaration attr_decl = this.getAttributeDeclaration(decl, attr);
        if (attr_decl == null) {
            return false;
        }
        boolean rc = true;
        try {
            CMDataType cmDataType = attr_decl.getAttrType();
            if (cmDataType == null) {
                return false;
            }
            String attr_type = cmDataType.getDataTypeName();
            if (!attr_type.equalsIgnoreCase("ENUM")) return rc;
            String[] values = cmDataType.getEnumeratedValues();
            if (values == null) {
                return false;
            }
            int j = 0;
            while (true) {
                if (j >= values.length) {
                    return rc;
                }
                rc = false;
                if (Value.compareToIgnoreCase(values[j]) == 0) {
                    return true;
                }
                ++j;
            }
        }
        catch (NullPointerException nullPointerException) {
            return rc;
        }
        catch (ClassCastException classCastException) {}
        return rc;
    }

    @Override
    public boolean isBlockElement(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(node);
        return decl != null && decl.supports("layoutType") && decl.getProperty("layoutType") == "layoutBlock";
    }

    @Override
    public boolean isBr(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        return node.getNodeName().equalsIgnoreCase("BR");
    }

    @Override
    public boolean isCellElement(Element element) {
        return element != null && element.getNodeName().equalsIgnoreCase("TD") || element.getNodeName().equalsIgnoreCase("TH");
    }

    public boolean isDtc(Node node) {
        return false;
    }

    public boolean isEditable(Node node) {
        return node != null;
    }

    public boolean isIncluded(Node parent, Node child) {
        String tagName;
        if (child == null) {
            return false;
        }
        String string = tagName = child.getNodeType() == 1 ? child.getNodeName() : null;
        if (tagName == null || tagName.length() == 0) {
            return false;
        }
        Vector vec = this.getIncludedTagNames(parent);
        if (vec == null) {
            return false;
        }
        int i = 0;
        while (i < vec.size()) {
            String str = (String)vec.get(i);
            if (str.equalsIgnoreCase(tagName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEmptyBlock(Element element) {
        if (element == null) {
            return false;
        }
        if (!element.hasChildNodes()) {
            return true;
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return false;
            }
            if (child.getNodeType() != 3) {
                return false;
            }
            if (!this.isEmptyText((Text)child)) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    @Override
    public boolean isEmptyNode(Node node) {
        if (node == null) {
            return false;
        }
        if (node instanceof Document) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return true;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(node);
        if (decl == null) {
            if (node instanceof IDOMElement && ((IDOMElement)node).isCommentTag()) {
                return !((IDOMElement)node).isContainer();
            }
            NodeList c = node.getChildNodes();
            return c.getLength() <= 0;
        }
        int content_type = decl.getContentType();
        if (content_type == 0) {
            return false;
        }
        if (content_type == 1) {
            return true;
        }
        if (content_type == 4) {
            return true;
        }
        List childList = this.getAvailableChildNodes(decl);
        return childList == null || childList.size() == 0;
    }

    @Override
    public boolean isEmptyText(Text text) {
        if (text == null) {
            return false;
        }
        String str = text.getData();
        if (str.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isExcluded(Node parent, Node child) {
        String tagName;
        if (child == null) {
            return false;
        }
        String string = tagName = child.getNodeType() == 1 ? child.getNodeName() : null;
        if (tagName == null || tagName.length() == 0) {
            return false;
        }
        Vector vec = this.getExcludedTagNames(parent);
        if (vec == null) {
            return false;
        }
        int i = 0;
        while (i < vec.size()) {
            String str = (String)vec.get(i);
            if (str.equalsIgnoreCase(tagName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isJsp(Node node) {
        CMElementDeclaration decl = this.getCMElementDeclaration(node);
        return this.isJsp(decl);
    }

    private boolean isJsp(CMElementDeclaration decl) {
        if (decl == null) {
            return false;
        }
        Object jsp = decl.getProperty("isJSP");
        return jsp instanceof Boolean && (Boolean)jsp != false;
    }

    private boolean isSsi(CMElementDeclaration decl) {
        if (decl == null) {
            return false;
        }
        Object ssi = decl.getProperty("isSSI");
        return ssi instanceof Boolean && (Boolean)ssi != false;
    }

    @Override
    public boolean isLineElement(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(node);
        return decl != null && decl.supports("layoutType") && decl.getProperty("layoutType") == "layoutBlock" && node.getNodeName().equalsIgnoreCase("HR");
    }

    @Override
    public boolean isLogicalElement(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        TLDElementDeclaration decl = this.getTLDElementDeclaration((Element)node);
        if (decl != null) {
            return !this.isEmptyNode(node);
        }
        return node instanceof IDOMElement && ((IDOMElement)node).isCommentTag();
    }

    @Override
    public boolean isParagraph(Element element) {
        if (element == null) {
            return false;
        }
        if (element.getNodeName().equalsIgnoreCase("H1") || element.getNodeName().equalsIgnoreCase("H2") || element.getNodeName().equalsIgnoreCase("H3") || element.getNodeName().equalsIgnoreCase("H4") || element.getNodeName().equalsIgnoreCase("H5") || element.getNodeName().equalsIgnoreCase("H6") || element.getNodeName().equalsIgnoreCase("P") || element.getNodeName().equalsIgnoreCase("ADDRESS") || element.getNodeName().equalsIgnoreCase("BLOCKQUOTE")) {
            return true;
        }
        return element.getNodeName().equalsIgnoreCase("PRE");
    }

    @Override
    public boolean isPlainElement(Element element) {
        if (element == null) {
            return false;
        }
        if (element.getNodeName().equalsIgnoreCase("PRE")) {
            return true;
        }
        return element.getNodeName().equalsIgnoreCase("TEXTAREA");
    }

    @Override
    public boolean isSolidElement(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(node);
        if (decl != null && decl.supports("layoutType") && decl.getProperty("layoutType") == "layoutObject") {
            return true;
        }
        String nodename = node.getNodeName();
        if (nodename != null) {
            if (nodename.equalsIgnoreCase("jsp:useBean")) {
                return true;
            }
            if (nodename.equalsIgnoreCase("jsp:declaration")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSplitableNode(Node node) {
        while (node != null && this.isLogicalElement(node)) {
            node = node.getParentNode();
        }
        if (node == null) {
            return false;
        }
        if (!this.isEditable(node)) {
            return false;
        }
        switch (node.getNodeType()) {
            case 1: {
                if (this.isSolidElement(node)) {
                    return false;
                }
                if (this.isEmptyNode(node)) {
                    return false;
                }
                CMElementDeclaration decl = this.getCMElementDeclaration(node);
                if (decl == null) {
                    IDOMElement ele = (IDOMElement)node;
                    if (ele.isCommentTag()) {
                        return ele.isContainer();
                    }
                    if (ele.isJSPTag()) {
                        return false;
                    }
                    if (ele.isJSPTag() && !ele.isCommentTag() && ele.isContainer()) {
                        return false;
                    }
                    return false;
                }
                return !this.isBodyElement(node) && !this.isHtmlElement(node) && !node.getNodeName().equalsIgnoreCase("CAPTION") && !node.getNodeName().equalsIgnoreCase("TH") && !node.getNodeName().equalsIgnoreCase("TD") && !node.getNodeName().equalsIgnoreCase("DIV") && !node.getNodeName().equalsIgnoreCase("CENTER");
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTableCell(Element element) {
        if (element == null) {
            return false;
        }
        String nodeName = element.getNodeName();
        return nodeName.equalsIgnoreCase("TD") || nodeName.equalsIgnoreCase("TH");
    }

    @Override
    public boolean isTableElement(Element element) {
        if (element == null) {
            return false;
        }
        return element.getNodeName().equalsIgnoreCase("TABLE");
    }

    @Override
    public boolean isTableRowGroupElement(Element element) {
        return element != null && element.getNodeName().equalsIgnoreCase("TBODY") || element.getNodeName().equalsIgnoreCase("TFOOT") || element.getNodeName().equalsIgnoreCase("THEAD");
    }

    @Override
    public boolean isTextAttribute(Element element) {
        if (element == null) {
            return false;
        }
        if (element.getNodeName().equalsIgnoreCase("B") || element.getNodeName().equalsIgnoreCase("I") || element.getNodeName().equalsIgnoreCase("U") || element.getNodeName().equalsIgnoreCase("S") || element.getNodeName().equalsIgnoreCase("TT") || element.getNodeName().equalsIgnoreCase("STRIKE") || element.getNodeName().equalsIgnoreCase("BLINK") || element.getNodeName().equalsIgnoreCase("SUB") || element.getNodeName().equalsIgnoreCase("SUP") || element.getNodeName().equalsIgnoreCase("FONT")) {
            return true;
        }
        if (element.getNodeName().equalsIgnoreCase("EM") | element.getNodeName().equalsIgnoreCase("CODE") || element.getNodeName().equalsIgnoreCase("SAMP") || element.getNodeName().equalsIgnoreCase("KBD") || element.getNodeName().equalsIgnoreCase("VAR") || element.getNodeName().equalsIgnoreCase("DFN") || element.getNodeName().equalsIgnoreCase("CITE") || element.getNodeName().equalsIgnoreCase("STRONG")) {
            return true;
        }
        return element.getNodeName().equalsIgnoreCase("BIG") | element.getNodeName().equalsIgnoreCase("SMALL") || element.getNodeName().equalsIgnoreCase("SPAN");
    }

    @Override
    public boolean isTrElement(Element element) {
        if (element == null) {
            return false;
        }
        return element.getNodeName().equalsIgnoreCase("TR");
    }

    @Override
    public boolean isViewable(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return true;
        }
        CMElementDeclaration decl = this.getCMElementDeclaration(node);
        return decl == null || !decl.supports("layoutType") || decl.getProperty("layoutType") != "layoutHidden";
    }

    @Override
    public boolean loveBody(Node node) {
        if (node == null) {
            return true;
        }
        switch (node.getNodeType()) {
            case 1: {
                IDOMElement impl;
                IDOMElement iDOMElement = impl = node instanceof IDOMElement ? (IDOMElement)node : null;
                if (impl.isCommentTag() && impl.isContainer()) {
                    return true;
                }
                CMElementDeclaration decl = this.getCMElementDeclaration(node);
                if (decl == null) {
                    return true;
                }
                if (this.isJsp(decl) || this.isSsi(decl)) {
                    return true;
                }
                if (decl instanceof TLDElementDeclaration) {
                    return true;
                }
                if (node.getNodeName().equalsIgnoreCase("SCRIPT") || node.getNodeName().equalsIgnoreCase("MAP")) {
                    return true;
                }
                if (node.getNodeName().equalsIgnoreCase("OBJECT") && this.isDtc(node)) {
                    return false;
                }
                return false;
            }
            case 8: {
                return true;
            }
            case 3: {
                return this.isEmptyText((Text)node);
            }
        }
        return true;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof Document) {
            this.flushFragmentCache();
            this.addAdapterIfNecessary(oldValue);
            this.addAdapterIfNecessary(newValue);
        } else if (notifier instanceof IDOMElement && ((IDOMElement)notifier).isCommentTag()) {
            this.flushFragmentCache();
            this.addAdapterIfNecessary(oldValue);
            this.addAdapterIfNecessary(newValue);
        } else if (notifier instanceof Element && ((Element)notifier).getNodeName().equals("jsp:root")) {
            this.flushFragmentCache();
        }
    }

    private void flushFragmentCache() {
        this.isFragment = null;
        this.fragmentContext = null;
    }

    private void addAdapterIfNecessary(Object node) {
        if (node instanceof Element && (((Element)node).getNodeName().equals("jsp:root") || ((IDOMElement)node).isCommentTag())) {
            ((INodeNotifier)node).getAdapterFor(EditModelQuery.class);
        }
    }

    public boolean shouldAdaptParagraph(Node node) {
        return true;
    }

    @Override
    public boolean shouldCopy(Node node) {
        IDOMElement elem;
        if (node == null) {
            return false;
        }
        if (this.isSolidElement(node)) {
            return true;
        }
        if (this.isEmptyNode(node)) {
            return true;
        }
        if (this.isJsp(node)) {
            return true;
        }
        if (node.getNodeType() == 8) {
            return true;
        }
        return node instanceof IDOMElement && ((elem = (IDOMElement)node).isCommentTag() || !elem.isGlobalTag());
    }

    @Override
    public Node skipEmptyText(Node node, boolean back) {
        while (node != null) {
            if (node.getNodeType() != 3) {
                return node;
            }
            Text text = (Text)node;
            if (!this.isEmptyText(text)) {
                return node;
            }
            Node node2 = node = back ? node.getPreviousSibling() : node.getNextSibling();
        }
        return null;
    }

    @Override
    public Element getSibling(Node li, String[] tagNames, boolean previous, boolean self) {
        Node prev = self ? li : (previous ? li.getPreviousSibling() : li.getNextSibling());
        while (prev != null) {
            if (prev.getNodeType() == 1) {
                int i = 0;
                while (i < tagNames.length) {
                    if (prev.getNodeName().equalsIgnoreCase(tagNames[i])) {
                        return (Element)prev;
                    }
                    ++i;
                }
                break;
            }
            if (prev.getNodeType() != 3 || !this.isEmptyText((Text)prev)) break;
            Node node = prev = previous ? prev.getPreviousSibling() : prev.getNextSibling();
        }
        return null;
    }

    public String getBodyElementName() {
        return this.getBodyElementName(null);
    }

    @Override
    public String getBodyElementName(Document doc) {
        if (doc instanceof DocumentTraversal) {
            NodeIterator itr = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, null, false);
            Node node = itr.nextNode();
            while (node != null) {
                if (this.isBodyElement(node)) {
                    return node.getNodeName();
                }
                node = itr.nextNode();
            }
        }
        return this.getDefaultRenderElementName();
    }

    protected String getDefaultRenderElementName() {
        return "BODY";
    }

    protected boolean isBodyElement(Node node) {
        Object mappedName;
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        String body = this.getDefaultRenderElementName();
        if (node.getNodeName().equalsIgnoreCase(body)) {
            return true;
        }
        return node.getLocalName().equalsIgnoreCase(body) && (mappedName = MAPPED_CUSTOM_TAGS.get(node.getNodeName().toLowerCase(Locale.US))) != null;
    }

    @Override
    public String getHeadElementName(Document doc) {
        if (doc instanceof DocumentTraversal) {
            NodeIterator itr = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, null, false);
            Node node = itr.nextNode();
            while (node != null) {
                if (this.isHeadElement(node)) {
                    return node.getNodeName();
                }
                node = itr.nextNode();
            }
        }
        return "HEAD";
    }

    protected boolean isStaticTag(Node node) {
        if (node != null && node.getNodeType() == 1) {
            IDOMElement ele = (IDOMElement)node;
            return ele.isGlobalTag() && this.getElementDeclaration((Node)ele) != null;
        }
        return false;
    }

    protected boolean isHeadElement(Node node) {
        Object mappedName;
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        if (node.getNodeName().equalsIgnoreCase("HEAD")) {
            return true;
        }
        return node.getLocalName().equalsIgnoreCase("HEAD") && (mappedName = MAPPED_CUSTOM_TAGS.get(node.getNodeName().toLowerCase(Locale.US))) != null;
    }

    protected boolean isHeadChildElement(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        return node.getNodeName().equalsIgnoreCase("META") || node.getNodeName().equalsIgnoreCase("TITLE") || node.getNodeName().equalsIgnoreCase("LINK") || node.getNodeName().equalsIgnoreCase("STYLE") || node.getNodeName().equalsIgnoreCase("BASE") || node.getNodeName().equalsIgnoreCase("ISINDEX");
    }

    @Override
    public String getHtmlElementName(Document doc) {
        if (doc instanceof DocumentTraversal) {
            NodeIterator itr = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, null, false);
            Node node = itr.nextNode();
            while (node != null) {
                if (this.isHtmlElement(node)) {
                    return node.getNodeName();
                }
                node = itr.nextNode();
            }
        }
        return this.getDefaultRootElementName();
    }

    protected String getDefaultRootElementName() {
        return "HTML";
    }

    protected boolean isHtmlElement(Node node) {
        Object mappedName;
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        String root = this.getDefaultRootElementName();
        if (node.getNodeName().equalsIgnoreCase(root)) {
            return true;
        }
        return node.getLocalName().equalsIgnoreCase(root) && (mappedName = MAPPED_CUSTOM_TAGS.get(node.getNodeName().toLowerCase(Locale.US))) != null;
    }

    @Override
    public boolean existsAsEntity(String name) {
        return !"euro".equals(name);
    }

    @Override
    public NodeList collectRenderRoots(Document doc) {
        Range range;
        if (doc == null) {
            return NULL_NODELIST;
        }
        if (this.isFragment(doc)) {
            if ("editingContextBody".equals(this.getFragmentContext(doc))) {
                return new SingleNodeList(doc);
            }
            return NULL_NODELIST;
        }
        NodeIterator itr = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, null, false);
        Node node = null;
        MyNodeList list = new MyNodeList();
        while ((node = itr.nextNode()) != null) {
            if (!this.isBodyElement(node)) continue;
            list.add(node);
        }
        if (list.size() <= 0 && (range = this.getRenderRootRange(doc)) != null && !range.getCollapsed()) {
            list.add(range.getStartContainer());
        }
        return list;
    }

    @Override
    public boolean isFragment(Document doc) {
        if (this.isFragment == null) {
            FragmentDetectorRegistry reg = FragmentDetectorRegistry.getInstance();
            IFragmentDetector[] detectors = reg.getDetectors();
            if (detectors != null && detectors.length > 0) {
                int i = 0;
                while (i < detectors.length) {
                    short state;
                    if ((state = detectors[i++].detectFragment(doc)) == 2) {
                        this.isFragment = Boolean.TRUE;
                        break;
                    }
                    if (state == 0) {
                        this.isFragment = Boolean.FALSE;
                        break;
                    }
                    if (state == 3) break;
                }
            }
            if (this.isFragment == null) {
                this.isFragment = this.isFragmentDetectWithHTMLTags(doc, true) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.isFragment;
    }

    private boolean isFragmentDetectWithHTMLTags(Document doc, boolean isQuasiFragment) {
        NodeIterator iter = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if (this.isHtmlElement(node) || this.isHeadElement(node) || this.isBodyElement(node)) {
                return false;
            }
            if (!(!this.isHeadChildElement(node) || isQuasiFragment && node.getParentNode().getNodeType() == 9 && node.getNodeName().equalsIgnoreCase("LINK"))) {
                return false;
            }
            node = iter.nextNode();
        }
        return true;
    }

    private boolean isQuasiFragment(Document doc) {
        if (!this.isFragment(doc)) {
            return false;
        }
        Node child = doc.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("LINK")) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    @Override
    public boolean isRenderRoot(Node node, boolean shouldBe) {
        if (node == null) {
            return false;
        }
        if (this.isBodyElement(node)) {
            return true;
        }
        if (this.isFragment(AbstractEditModelQuery.getSafeDocument(node))) {
            if ("editingContextBody".equals(this.getFragmentContext(AbstractEditModelQuery.getSafeDocument(node)))) {
                return node.getNodeType() == 9;
            }
        } else if (!shouldBe && this.getBodyElement(AbstractEditModelQuery.getSafeDocument(node), false) == null) {
            Range range = this.getRenderRootRange(AbstractEditModelQuery.getSafeDocument(node));
            return range != null && node == range.getEndContainer();
        }
        return false;
    }

    public boolean isRenderRoot(Node node) {
        return this.isRenderRoot(node, false);
    }

    public boolean isHeadCorrespondent(Node node) {
        return this.isHeadCorrespondent(node, false);
    }

    @Override
    public boolean isHeadCorrespondent(Node node, boolean shouldBe) {
        if (node == null) {
            return false;
        }
        if (this.isHeadElement(node)) {
            return true;
        }
        Element head = this.getHeadElement(AbstractEditModelQuery.getSafeDocument(node), false);
        if (this.isFragment(AbstractEditModelQuery.getSafeDocument(node))) {
            if ("editingContextHead".equals(this.getFragmentContext(AbstractEditModelQuery.getSafeDocument(node)))) {
                return node.getNodeType() == 9;
            }
        } else {
            if (!shouldBe && head == null) {
                Range range = this.getHeadCorrespondentRange(AbstractEditModelQuery.getSafeDocument(node));
                return range != null && node == range.getEndContainer();
            }
            if (!shouldBe && !ReadOnlySupport.isChildEditable(head) && node.getNodeType() == 1 && ((IDOMElement)node).isCommentTag()) {
                Node child = node;
                while (child != null) {
                    if (head == child) {
                        return true;
                    }
                    child = child.getParentNode();
                }
            }
        }
        return false;
    }

    public Range getHeadCorrespondentRange(Document doc) {
        if (doc == null) {
            return null;
        }
        if (this.isFragment(doc) && !this.isQuasiFragment(doc)) {
            if ("editingContextHead".equals(this.getFragmentContext(doc))) {
                Range range = ((DocumentRange)((Object)doc)).createRange();
                range.setStart(doc, 0);
                range.setEnd(doc, doc.getChildNodes().getLength());
                return range;
            }
            return null;
        }
        Element head = this.getHeadElement(doc, false);
        if (head != null) {
            Range range = ((DocumentRange)((Object)doc)).createRange();
            range.setStart(head, 0);
            range.setEnd(head, head.getChildNodes().getLength());
            return range;
        }
        Node htmlNode = this.getHtmlCorrespondentNode(doc, false);
        Node start = null;
        Node end = null;
        Node child = htmlNode.getFirstChild();
        block0: while (child != null) {
            if (this.isHeadChildElement(child)) {
                if (start == null) {
                    start = child;
                }
                end = child;
            } else {
                if (this.isStaticTag(child) || child.getNodeType() == 3 && !this.isEmptyText((Text)child)) break;
                if (child.hasChildNodes()) {
                    child = child.getFirstChild();
                    continue;
                }
            }
            Node next = null;
            while (child != null) {
                next = child.getNextSibling();
                if (next != null) {
                    child = next;
                    continue block0;
                }
                if ((child = child.getParentNode()) != htmlNode) continue;
                child = null;
            }
        }
        if (end != null) {
            Range range = ((DocumentRange)((Object)doc)).createRange();
            range.setStart(start.getParentNode(), this.getChildIndex(start));
            range.setEnd(end.getParentNode(), this.getChildIndex(end) + 1);
            return range;
        }
        return null;
    }

    private boolean mustRender(Node node) {
        String nodeName;
        if (node == null) {
            return false;
        }
        if (node.getNodeType() == 1 && ("jsp:declaration".equals(nodeName = node.getNodeName()) || "jsp:expression".equals(nodeName) || "jsp:scriptlet".equals(nodeName) || "jsp:forward".equals(nodeName) || "jsp:useBean".equals(nodeName))) {
            return false;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (this.mustRender(child)) {
                return true;
            }
            child = child.getNextSibling();
        }
        if (node.getNodeType() == 1) {
            if (((IDOMElement)node).isGlobalTag() && !this.canLocateOutsideBodyElement(node)) {
                return true;
            }
        } else if (node.getNodeType() == 3) {
            return !this.isEmptyText((Text)node);
        }
        return false;
    }

    private Range getFirstRenderCaretLocation(Node node) {
        int i = 0;
        int firstRender = -1;
        int length = node.getChildNodes().getLength();
        while (i < length) {
            Node child = node.getChildNodes().item(i);
            if (!this.canLocateOutsideBodyElement(child)) {
                if (firstRender < 0) {
                    firstRender = i;
                }
                if (this.mustRender(child)) {
                    break;
                }
            } else if (!this.canLocateOutsideHtmlElement(child)) {
                firstRender = -1;
            }
            ++i;
        }
        Document doc = AbstractEditModelQuery.getSafeDocument(node);
        Range range = ((DocumentRange)((Object)doc)).createRange();
        if (firstRender < 0) {
            return this.getLastRenderCaretLocation(node);
        }
        range.setStart(node, firstRender);
        range.collapse(true);
        return range;
    }

    private Range getLastRenderCaretLocation(Node node) {
        int i = node.getChildNodes().getLength() - 1;
        while (i >= 0) {
            Node child = node.getChildNodes().item(i);
            if (child == null || child.getNodeType() != 3 || !this.isEmptyText((Text)child)) break;
            --i;
        }
        Document doc = AbstractEditModelQuery.getSafeDocument(node);
        Range range = ((DocumentRange)((Object)doc)).createRange();
        range.setEnd(node, node.getChildNodes().getLength());
        range.collapse(false);
        return range;
    }

    public Range getRenderRootRange(Document doc) {
        if (doc == null) {
            return null;
        }
        if (this.isFragment(doc)) {
            if ("editingContextBody".equals(this.getFragmentContext(doc))) {
                Range range = ((DocumentRange)((Object)doc)).createRange();
                Range startRange = this.getFirstRenderCaretLocation(doc);
                range.setStart(startRange.getStartContainer(), startRange.getStartOffset());
                Range endRange = this.getLastRenderCaretLocation(doc);
                range.setEnd(endRange.getEndContainer(), endRange.getEndOffset());
                return range;
            }
            return null;
        }
        Element body = this.getBodyElement(doc, false);
        if (body != null) {
            Range range = ((DocumentRange)((Object)doc)).createRange();
            range.setStart(body, 0);
            range.setEnd(body, body.getChildNodes().getLength());
            return range;
        }
        Node head = this.getHeadCorrespondentNode(doc, false);
        Node html = this.getHtmlCorrespondentNode(doc, false);
        Range headRange = null;
        if (head != null && this.isHeadElement(head)) {
            Range range = ((DocumentRange)((Object)doc)).createRange();
            Node headNext = null;
            Node parent = head;
            while (parent != null) {
                headNext = parent.getNextSibling();
                if ((parent = parent.getParentNode()) == doc || parent == html || headNext != null) break;
            }
            while (headNext != null) {
                if (headNext.getNodeType() != 3 || !this.isEmptyText((Text)headNext)) break;
                headNext = headNext.getNextSibling();
            }
            if (headNext == null) {
                range.setEnd(parent, parent.getChildNodes().getLength());
                range.collapse(false);
            } else {
                range.setStart(headNext.getParentNode(), this.getChildIndex(headNext));
                range.setEnd(parent, parent.getChildNodes().getLength());
            }
            return range;
        }
        if (head != null && (headRange = this.getHeadCorrespondentRange(doc)) != null) {
            Range range = ((DocumentRange)((Object)doc)).createRange();
            Node headEnd = headRange.getEndContainer().getChildNodes().item(headRange.getEndOffset());
            Node parent = headRange.getEndContainer();
            if (headEnd == null) {
                while (parent != null) {
                    if (parent == doc || parent == html) break;
                    headEnd = parent.getNextSibling();
                    parent = parent.getParentNode();
                    if (headEnd != null) break;
                }
            }
            while (headEnd != null) {
                if (headEnd.getNodeType() != 3 || !this.isEmptyText((Text)headEnd)) break;
                headEnd = headEnd.getNextSibling();
            }
            if (headEnd == null) {
                range.setEnd(parent, parent.getChildNodes().getLength());
                range.collapse(false);
            } else {
                range.setStart(headEnd.getParentNode(), this.getChildIndex(headEnd));
                range.setEnd(parent, parent.getChildNodes().getLength());
            }
            return range;
        }
        if (html != null) {
            Range range = ((DocumentRange)((Object)doc)).createRange();
            Range startRange = this.getFirstRenderCaretLocation(html);
            range.setStart(startRange.getStartContainer(), startRange.getStartOffset());
            Range endRange = this.getLastRenderCaretLocation(html);
            range.setEnd(endRange.getEndContainer(), endRange.getEndOffset());
            return range;
        }
        Range range = ((DocumentRange)((Object)doc)).createRange();
        Range startRange = this.getFirstRenderCaretLocation(doc);
        range.setStart(startRange.getStartContainer(), startRange.getStartOffset());
        Range endRange = this.getLastRenderCaretLocation(doc);
        range.setEnd(endRange.getEndContainer(), endRange.getEndOffset());
        return range;
    }

    @Override
    public IPath getBaseFolderLocation(Document doc) {
        return null;
    }

    @Override
    public IPath getDefaultStyleSheet(Document doc) {
        return null;
    }

    @Override
    public String getFragmentContext(Document doc) {
        if (!this.isFragment(doc)) {
            return null;
        }
        if (this.fragmentContext == null) {
            FragmentDetectorRegistry reg = FragmentDetectorRegistry.getInstance();
            IFragmentDetector[] detectors = reg.getDetectors();
            if (detectors != null && detectors.length > 0) {
                int i = 0;
                while (i < detectors.length) {
                    short state;
                    if ((state = detectors[i++].detectFragmentContext(doc)) == 0) {
                        this.fragmentContext = "editingContextBody";
                        break;
                    }
                    if (state != 2) continue;
                    this.fragmentContext = "editingContextHead";
                    break;
                }
            }
            if (this.fragmentContext == null) {
                this.fragmentContext = "editingContextBody";
            }
        }
        return this.fragmentContext;
    }

    protected static Document getSafeDocument(Node node) {
        if (node == null) {
            return null;
        }
        Document doc = node.getOwnerDocument();
        return node.getNodeType() == 9 ? (Document)node : doc;
    }

    public Node getHeadCorrespondentNode(Node childOrDocument, boolean create) {
        if (childOrDocument == null) {
            return null;
        }
        Document doc = null;
        if (childOrDocument.getNodeType() != 9) {
            Node target = childOrDocument;
            while (target != null) {
                if (this.isHeadCorrespondent(target)) {
                    return target;
                }
                target = target.getParentNode();
            }
            doc = childOrDocument.getOwnerDocument();
        } else {
            doc = (Document)childOrDocument;
        }
        Element head = this.getHeadElement(doc, false);
        if (head != null) {
            return head;
        }
        if (this.isFragment(doc)) {
            if ("editingContextHead".equals(this.getFragmentContext(doc))) {
                return doc;
            }
            if (create) {
                if (!this.acceptEditingAsComplete()) {
                    throw new HTMLCommandException(ResourceHandler._UI_This_document_is_treated_as_fragment_file_so_you_cannot_insert__head__tag__8);
                }
            } else {
                return null;
            }
        }
        if (create) {
            return this.getHeadElement(doc, create);
        }
        Range range = this.getHeadCorrespondentRange(doc);
        return range != null ? range.getEndContainer() : null;
    }

    public Node getHtmlCorrespondentNode(Node childOrDocument, boolean create) {
        Element htmlNode = this.getHtmlElement(AbstractEditModelQuery.getSafeDocument(childOrDocument), create);
        if (htmlNode == null && !create) {
            return AbstractEditModelQuery.getSafeDocument(childOrDocument);
        }
        return htmlNode;
    }

    public Node getRenderRootNode(Node childOrDocument, boolean create) {
        Element body;
        if (childOrDocument == null) {
            return null;
        }
        Document doc = null;
        if (childOrDocument.getNodeType() != 9) {
            Node target = childOrDocument;
            while (target != null) {
                if (this.isRenderRoot(target)) {
                    return target;
                }
                target = target.getParentNode();
            }
            doc = childOrDocument.getOwnerDocument();
        } else {
            doc = (Document)childOrDocument;
        }
        if (this.isFragment(doc)) {
            if ("editingContextBody".equals(this.getFragmentContext(doc))) {
                return doc;
            }
            if (create) {
                if (!this.acceptEditingAsComplete()) {
                    throw new HTMLCommandException(ResourceHandler._UI_This_document_is_treated_as_fragment_file_so_you_cannot_edit__body__tag__9);
                }
            } else {
                return null;
            }
        }
        if ((body = this.getBodyElement(doc, create)) == null && !create) {
            Range range = this.getRenderRootRange(doc);
            return range != null && !range.getCollapsed() ? range.getStartContainer() : null;
        }
        return body;
    }

    public FragmentQuery getFragmentQuery() {
        return this;
    }

    public DocumentQuery.InsertionTarget getHeadInsertionTarget(Document doc) {
        Node parent = null;
        Node child = null;
        Node head = this.getHeadCorrespondentNode(doc, false);
        if (head != null && head.getNodeType() != 9) {
            parent = head;
            child = null;
        } else {
            Range range = this.getHeadCorrespondentRange(doc);
            if (range != null) {
                Node node = range.getEndContainer();
                Node target = null;
                int offset = range.getEndOffset();
                if (node != null && (node.getNodeType() == 1 || node.getNodeType() == 9)) {
                    NodeList nodes = node.getChildNodes();
                    if (offset < nodes.getLength()) {
                        target = nodes.item(offset);
                    }
                } else {
                    target = node;
                    node = node.getParentNode();
                }
                parent = node;
                child = target;
            } else {
                Node html = this.getHtmlCorrespondentNode(doc, false);
                if (html != null && html.getNodeType() != 9) {
                    parent = html;
                    child = html.getFirstChild();
                } else {
                    return this.getPageInsertionTarget(doc);
                }
            }
        }
        if (!ReadOnlySupport.isChildEditable(parent)) {
            parent = ReadOnlySupport.getChildEditableCommentElement(parent, true);
            child = null;
        }
        if (parent == null) {
            return null;
        }
        return new DocumentQuery.InsertionTarget(parent, child);
    }

    public DocumentQuery.InsertionTarget getPageInsertionTarget(Document doc) {
        Node parent = null;
        Node child = null;
        Node html = this.getHtmlCorrespondentNode(doc, false);
        if (html != null && html.getNodeType() != 9) {
            parent = html.getParentNode();
            child = html;
        } else {
            parent = doc;
            Node current = parent.getFirstChild();
            while (current != null) {
                if (current.getNodeType() == 1 && current.getNodeName().equals("jsp:root")) {
                    parent = current;
                    current = current.getFirstChild();
                    continue;
                }
                if (!this.canLocateOutsideHtmlElement(current)) break;
                current = current.getNextSibling();
            }
            child = current;
        }
        if (!ReadOnlySupport.isChildEditable(parent)) {
            child = parent;
            parent = parent.getParentNode();
            while (child != null && parent != null) {
                if (ReadOnlySupport.isChildEditable(parent)) break;
                child = parent;
                parent = child.getParentNode();
            }
        }
        if (parent == null) {
            return null;
        }
        return new DocumentQuery.InsertionTarget(parent, child);
    }

    protected boolean hasElementOrText(Element commentElement) {
        Node node = commentElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 ? !(node instanceof IDOMElement) || !((IDOMElement)node).isCommentTag() || this.hasElementOrText((Element)node) : node.getNodeType() == 3 && !this.isEmptyText((Text)node)) break;
            node = node.getNextSibling();
        }
        return node != null;
    }

    @Override
    public boolean acceptEditingAsComplete() {
        if (this.acceptEditAsCompleteDocument == null) {
            FragmentDetectorRegistry reg = FragmentDetectorRegistry.getInstance();
            IFragmentDetector[] detectors = reg.getDetectors();
            if (detectors != null && detectors.length > 0) {
                int i = 0;
                while (i < detectors.length) {
                    short state;
                    if ((state = detectors[i++].detectAcceptEditAsComplete()) == 0) {
                        this.acceptEditAsCompleteDocument = Boolean.TRUE;
                        break;
                    }
                    if (state != 2) continue;
                    this.acceptEditAsCompleteDocument = Boolean.FALSE;
                    break;
                }
            }
            if (this.acceptEditAsCompleteDocument == null) {
                this.acceptEditAsCompleteDocument = Boolean.TRUE;
            }
        }
        return this.acceptEditAsCompleteDocument;
    }

    static class MyNodeList
    extends ArrayList
    implements NodeList {
        private static final long serialVersionUID = 1L;

        MyNodeList() {
        }

        @Override
        public int getLength() {
            return this.size();
        }

        @Override
        public Node item(int i) {
            if (i < 0 || this.size() <= i) {
                return null;
            }
            return (Node)this.get(i);
        }
    }

    static class SingleNodeList
    implements NodeList {
        Node singleNode;

        public SingleNodeList(Node node) {
            this.singleNode = node;
        }

        @Override
        public int getLength() {
            return this.singleNode != null ? 1 : 0;
        }

        @Override
        public Node item(int i) {
            if (i < 0 || this.getLength() <= i) {
                return null;
            }
            return this.singleNode;
        }
    }
}

