/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.attrview;

import com.ibm.etools.webedit.common.internal.attrview.StyleSelectionListener;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StyleFieldController {
    protected static final boolean DEBUG = false;
    private static final String STYLE_FIELD_CONTROLLER = "org.eclipse.StyleFieldController";
    private static final String STYLE_FOCUS_LISTENER = "org.eclipse.StyleFieldController.styleFocusListener";
    private static final String STYLE_HYPERLINK_HANDLER = "org.eclipse.StyleFieldController.styleHyperLinkHandler";
    private static String fgPlatform = SWT.getPlatform();
    private static boolean fgCarbon = "carbon".equals(fgPlatform);
    private static boolean fgWin32 = "win32".equals(fgPlatform);
    private Control fCueControl;
    private Control fHoverControl;
    private int fDx;
    private int fDy;
    private ILabelProvider fLabelProvider;
    private Hover fHover;
    private StyleSelectionListener fStyleSelectionListener;

    public static void setSmartCue(Control control, ILabelProvider labelProvider, StyleSelectionListener styleSelectionListener) {
        StyleFieldController.setStyleCue(control, labelProvider, styleSelectionListener);
    }

    public static void setSmartCue(Control cueControl, Control control, ILabelProvider labelProvider, StyleSelectionListener styleSelectionListener) {
        StyleFieldController.setStyleCue(cueControl, control, labelProvider, styleSelectionListener);
    }

    public static void updateSmartCue(Control control) {
        StyleFieldController.updateStyleCue(control);
    }

    public static void updateSmartCue(Control cueControl, Control control) {
        StyleFieldController.updateStyleCue(cueControl, control);
    }

    public static void setStyleCue(Control control, ILabelProvider labelProvider, StyleSelectionListener styleSelectionListener) {
        StyleFieldController.setStyleCue(control, control, labelProvider, styleSelectionListener);
    }

    public static void setStyleCue(Control cueControl, Control hoverControl, ILabelProvider labelProvider, StyleSelectionListener styleSelectionListener) {
        StyleFieldController.getStyleFieldController(hoverControl).internalSetStyleCue(cueControl, hoverControl, labelProvider, styleSelectionListener);
    }

    public static void updateStyleCue(Control control) {
        StyleFieldController.updateStyleCue(control, control);
    }

    public static void updateStyleCue(Control cueControl, Control hoverControl) {
        StyleFieldController.getStyleFieldController(hoverControl).internalUpdateStyleCue(cueControl, hoverControl);
    }

    private StyleFieldController(final Control control) {
        control.setData(STYLE_FIELD_CONTROLLER, (Object)this);
        final Shell shell = control.getShell();
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 10: 
                    case 11: {
                        if (StyleFieldController.this.fHover == null) break;
                        StyleFieldController.this.fHover.setLocation(StyleFieldController.this.fHoverControl);
                        break;
                    }
                    case 12: {
                        Object data = control.getData(StyleFieldController.STYLE_FIELD_CONTROLLER);
                        if (data != StyleFieldController.this) break;
                        control.setData(StyleFieldController.STYLE_FIELD_CONTROLLER, null);
                        StyleFieldController.this.handleDispose();
                        shell.removeListener(11, (Listener)this);
                        shell.removeListener(10, (Listener)this);
                        shell.removeListener(21, (Listener)this);
                        shell.removeListener(27, (Listener)this);
                        shell.removeListener(19, (Listener)this);
                        break;
                    }
                    case 19: 
                    case 21: 
                    case 27: {
                        StyleFieldController.this.showHover(null, null);
                    }
                }
            }
        };
        shell.addListener(11, l);
        shell.addListener(10, l);
        control.addListener(12, l);
        shell.addListener(21, l);
        shell.addListener(27, l);
        shell.addListener(19, l);
    }

    private void addFieldFocusListener(final Control hoverControl) {
        FieldFocusListener focuslistener = (FieldFocusListener)hoverControl.getData(STYLE_FOCUS_LISTENER);
        if (focuslistener != null) {
            return;
        }
        focuslistener = new FieldFocusListener();
        hoverControl.setData(STYLE_FOCUS_LISTENER, (Object)focuslistener);
        hoverControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                hoverControl.setData(StyleFieldController.STYLE_FOCUS_LISTENER, null);
            }
        });
        hoverControl.addFocusListener((FocusListener)focuslistener);
    }

    private void addHyperLinkHandler(final Control cueControl) {
        HyperLinkHandler hyperLinkHandler = (HyperLinkHandler)((Object)cueControl.getData(STYLE_HYPERLINK_HANDLER));
        if (hyperLinkHandler != null) {
            return;
        }
        hyperLinkHandler = new HyperLinkHandler();
        cueControl.setData(STYLE_HYPERLINK_HANDLER, (Object)hyperLinkHandler);
        cueControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cueControl.setData(StyleFieldController.STYLE_HYPERLINK_HANDLER, null);
            }
        });
        cueControl.addFocusListener((FocusListener)hyperLinkHandler);
        cueControl.addMouseListener((MouseListener)hyperLinkHandler);
        cueControl.addMouseTrackListener((MouseTrackListener)hyperLinkHandler);
        cueControl.addPaintListener((PaintListener)hyperLinkHandler);
    }

    private void doHideHover() {
        if (this.isHoverVisible()) {
            this.showHover(this.fHoverControl, null);
        }
    }

    private void doShowDialog(MouseEvent e) {
        if (this.isOnCueControl(e) && this.fStyleSelectionListener != null) {
            this.fStyleSelectionListener.handleControlSelected((Control)e.widget);
        }
    }

    private void doShowHover() {
        this.showHover(this.fHoverControl, this.fLabelProvider.getText((Object)this.fHoverControl));
    }

    private Control getCueControl() {
        if (this.fCueControl instanceof Label) {
            return this.fCueControl;
        }
        return this.fCueControl.getParent();
    }

    private Image getCueImage() {
        Image image = null;
        if (this.fLabelProvider != null) {
            image = this.fLabelProvider.getImage((Object)this.getCueControl());
        }
        return image;
    }

    private static StyleFieldController getStyleFieldController(Control control) {
        Object data = control.getData(STYLE_FIELD_CONTROLLER);
        if (!(data instanceof StyleFieldController)) {
            data = new StyleFieldController(control);
        }
        return (StyleFieldController)data;
    }

    private Point getGlobalPoint() {
        Control control = this.getCueControl();
        if (control instanceof Label) {
            GC gc = new GC((Drawable)control);
            int x = gc.stringExtent((String)((Label)control).getText()).x;
            gc.dispose();
            return control.toDisplay(x, this.fDy);
        }
        return control.toDisplay(this.fDx, this.fDy);
    }

    private void handleDispose() {
        this.fCueControl = null;
        this.fHoverControl = null;
        if (this.fHover != null) {
            this.fHover.dispose();
            this.fHover = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
    }

    private void internalSetStyleCue(Control cueControl, Control hoverControl, ILabelProvider labelProvider, StyleSelectionListener styleSelectionListener) {
        this.fCueControl = cueControl;
        this.fHoverControl = hoverControl;
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fLabelProvider = labelProvider;
        this.fStyleSelectionListener = styleSelectionListener;
        this.fDx = -5;
        this.fDy = 1;
        if (fgCarbon) {
            if (cueControl instanceof Text) {
                this.fDy += 3;
            } else if (cueControl instanceof Combo) {
                this.fDx -= 4;
            }
        } else if (fgWin32) {
            if (cueControl instanceof Text) {
                this.fDx -= 2;
                this.fDy -= 2;
            } else if (cueControl instanceof Label) {
                this.fDx -= 2;
                this.fDy -= 2;
            }
        }
        if (labelProvider != null) {
            this.addFieldFocusListener(hoverControl);
            this.addHyperLinkHandler(cueControl);
        } else {
            this.removeFieldFocusListener(hoverControl);
            this.removeHyperLinkHandler(cueControl);
        }
    }

    private void internalUpdateStyleCue(Control cueControl, Control hoverControl) {
        FieldFocusListener focuslistener = (FieldFocusListener)hoverControl.getData(STYLE_FOCUS_LISTENER);
        if (focuslistener != null) {
            cueControl.redraw();
        }
    }

    private boolean isCueEnabled() {
        return this.fLabelProvider.getText((Object)this.getCueControl()) != null;
    }

    private boolean isOnCueControl(MouseEvent e) {
        if (this.isCueEnabled()) {
            Image image = this.getCueImage();
            if (image != null) {
                Rectangle r = image.getBounds();
                Point global = this.getGlobalPoint();
                Point local = ((Control)e.widget).toControl(global);
                r.x = local.x;
                r.y = local.y;
                if (r.contains(e.x, e.y)) {
                    return true;
                }
            }
            Rectangle bounds = this.getCueControl().getBounds();
            bounds.x = 0;
            bounds.y = 0;
            if (bounds.contains(e.x, e.y)) {
                return true;
            }
        }
        return false;
    }

    private boolean isHoverVisible() {
        return this.fHover != null && this.fHover.isVisible();
    }

    private void removeFieldFocusListener(Control hoverControl) {
        FieldFocusListener focuslistener = (FieldFocusListener)hoverControl.getData(STYLE_FOCUS_LISTENER);
        if (focuslistener != null) {
            hoverControl.setData(STYLE_FOCUS_LISTENER, null);
            hoverControl.removeFocusListener((FocusListener)focuslistener);
        }
    }

    private void removeHyperLinkHandler(Control cueControl) {
        HyperLinkHandler hyperLinkHandler = (HyperLinkHandler)((Object)cueControl.getData(STYLE_HYPERLINK_HANDLER));
        if (hyperLinkHandler != null) {
            cueControl.setData(STYLE_HYPERLINK_HANDLER, null);
            cueControl.removeFocusListener((FocusListener)hyperLinkHandler);
            cueControl.removeMouseListener((MouseListener)hyperLinkHandler);
            cueControl.removeMouseTrackListener((MouseTrackListener)hyperLinkHandler);
            cueControl.removePaintListener((PaintListener)hyperLinkHandler);
        }
    }

    private void showHover(Control control, String text) {
        if (text != null) {
            if (this.fHover == null) {
                this.fHover = new Hover(control.getShell());
            }
            this.fHover.setText(text);
            this.fHover.setLocation(control);
            this.fHover.setVisible(true);
        } else if (this.fHover != null) {
            this.fHover.setVisible(false);
        }
    }

    private class CueHandler
    extends HoverHandler
    implements PaintListener {
        private CueHandler() {
        }

        public void paintControl(PaintEvent e) {
            this.paintCueImage(e);
        }

        protected void paintCueImage(PaintEvent e) {
            Image image;
            Control control = StyleFieldController.this.getCueControl();
            if (control.isDisposed() || !control.isEnabled()) {
                return;
            }
            if (StyleFieldController.this.isCueEnabled() && (image = StyleFieldController.this.getCueImage()) != null) {
                Point global = StyleFieldController.this.getGlobalPoint();
                Point local = ((Control)e.widget).toControl(global);
                e.gc.drawImage(image, local.x, local.y);
            }
        }

        @Override
        protected void handleHover(MouseEvent event) {
            this.updateHoverOnCue(event);
        }

        private void updateHoverOnCue(MouseEvent e) {
            if (StyleFieldController.this.isOnCueControl(e)) {
                StyleFieldController.this.doShowHover();
            } else {
                StyleFieldController.this.doHideHover();
            }
        }
    }

    class FieldFocusListener
    implements FocusListener {
        private FieldFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            StyleFieldController.this.doShowHover();
        }

        public void focusLost(FocusEvent e) {
            StyleFieldController.this.doHideHover();
        }
    }

    private class Hover {
        private int HD = 10;
        private int HW = 8;
        private int HH = 10;
        private int LABEL_MARGIN = 2;
        private Shell fHoverShell;
        private String fText = "";

        private Hover(Shell parent) {
            Display display = parent.getDisplay();
            this.fHoverShell = new Shell(parent, 540680);
            this.fHoverShell.setBackground(display.getSystemColor(29));
            this.fHoverShell.setForeground(display.getSystemColor(28));
            this.fHoverShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    pe.gc.drawString(Hover.this.fText, Hover.this.LABEL_MARGIN, Hover.this.LABEL_MARGIN);
                    if (!fgCarbon) {
                        pe.gc.drawPolygon(Hover.this.getPolygon(true));
                    }
                }
            });
            this.fHoverShell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    StyleFieldController.this.showHover(null, null);
                }
            });
        }

        private int[] getPolygon(boolean border) {
            Point e = this.getExtent();
            if (border) {
                int[] nArray = new int[16];
                nArray[2] = e.x - 1;
                nArray[4] = e.x - 1;
                nArray[5] = e.y - 1;
                nArray[6] = this.HD + this.HW;
                nArray[7] = e.y - 1;
                nArray[8] = this.HD + this.HW / 2;
                nArray[9] = e.y + this.HH - 1;
                nArray[10] = this.HD;
                nArray[11] = e.y - 1;
                nArray[13] = e.y - 1;
                return nArray;
            }
            int[] nArray = new int[16];
            nArray[2] = e.x;
            nArray[4] = e.x;
            nArray[5] = e.y;
            nArray[6] = this.HD + this.HW;
            nArray[7] = e.y;
            nArray[8] = this.HD + this.HW / 2;
            nArray[9] = e.y + this.HH;
            nArray[10] = this.HD;
            nArray[11] = e.y;
            nArray[13] = e.y;
            return nArray;
        }

        private void dispose() {
            if (!this.fHoverShell.isDisposed()) {
                this.fHoverShell.dispose();
            }
        }

        private void setVisible(boolean visible) {
            if (visible) {
                if (!this.fHoverShell.isVisible()) {
                    this.fHoverShell.setVisible(true);
                }
            } else if (this.fHoverShell.isVisible()) {
                this.fHoverShell.setVisible(false);
            }
        }

        private void setText(String t) {
            if (t == null) {
                t = "";
            }
            if (!t.equals(this.fText)) {
                Point oldSize = this.getExtent();
                this.fText = t;
                this.fHoverShell.redraw();
                Point newSize = this.getExtent();
                if (!oldSize.equals((Object)newSize)) {
                    Region region = new Region();
                    region.add(this.getPolygon(false));
                    this.fHoverShell.setRegion(region);
                    region.dispose();
                }
            }
        }

        private boolean isVisible() {
            return this.fHoverShell.isVisible();
        }

        private void setLocation(Control control) {
            if (control != null) {
                int h = this.getExtent().y;
                this.fHoverShell.setLocation(control.toDisplay(-this.HD + this.HW / 2, -h - this.HH + 1));
            }
        }

        private Point getExtent() {
            GC gc = new GC((Drawable)this.fHoverShell);
            Point e = gc.textExtent(this.fText);
            gc.dispose();
            e.x += this.LABEL_MARGIN * 2;
            e.y += this.LABEL_MARGIN * 2;
            return e;
        }
    }

    private class HoverHandler
    extends MouseTrackAdapter {
        private HoverHandler() {
        }

        public void mouseHover(MouseEvent e) {
            this.handleHover(e);
        }

        public void mouseExit(MouseEvent e) {
            StyleFieldController.this.doHideHover();
        }

        protected void handleHover(MouseEvent e) {
            StyleFieldController.this.doShowHover();
        }
    }

    private class HyperLinkHandler
    extends CueHandler
    implements FocusListener,
    MouseListener {
        private Cursor fCursor;
        private Color fColor;
        private Color fLinkColor;

        private HyperLinkHandler() {
            StyleFieldController.this.getCueControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (HyperLinkHandler.this.fCursor != null) {
                        HyperLinkHandler.this.fCursor.dispose();
                        HyperLinkHandler.this.fCursor = null;
                    }
                    if (HyperLinkHandler.this.fColor != null) {
                        HyperLinkHandler.this.fColor.dispose();
                        HyperLinkHandler.this.fColor = null;
                    }
                }
            });
        }

        private void doHideCursor() {
            StyleFieldController.this.getCueControl().setCursor(null);
        }

        private void doShowCursor() {
            if (this.fCursor == null) {
                this.fCursor = new Cursor((Device)StyleFieldController.this.getCueControl().getDisplay(), 21);
            }
            StyleFieldController.this.getCueControl().setCursor(this.fCursor);
        }

        public void focusGained(FocusEvent e) {
            this.handleEnter((TypedEvent)e);
        }

        public void focusLost(FocusEvent e) {
            this.handleExit((TypedEvent)e);
        }

        @Override
        public void paintControl(PaintEvent e) {
            super.paintControl(e);
            this.paintHyperLink(e);
            this.updateCursor();
        }

        protected void handleEnter(TypedEvent e) {
            this.updateHyperLinkColor(JFaceColors.getActiveHyperlinkText((Display)e.widget.getDisplay()));
        }

        protected void handleExit(TypedEvent e) {
            this.updateHyperLinkColor(JFaceColors.getHyperlinkText((Display)e.widget.getDisplay()));
        }

        protected void handleUp(MouseEvent e) {
            if (this.isHyperLinkAvailable()) {
                StyleFieldController.this.doShowDialog(e);
            }
        }

        protected boolean isHyperLinkAvailable() {
            Control control = StyleFieldController.this.getCueControl();
            if (control.isDisposed() || !control.isEnabled()) {
                return false;
            }
            return control instanceof Label;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            super.mouseEnter(e);
            this.handleEnter((TypedEvent)e);
        }

        @Override
        public void mouseExit(MouseEvent e) {
            super.mouseExit(e);
            this.handleExit((TypedEvent)e);
        }

        public void mouseUp(MouseEvent e) {
            this.handleUp(e);
        }

        protected void paintHyperLink(PaintEvent e) {
            if (!this.isHyperLinkAvailable()) {
                return;
            }
            Label label = (Label)StyleFieldController.this.getCueControl();
            if (this.fLinkColor == null) {
                this.fLinkColor = JFaceColors.getHyperlinkText((Display)label.getDisplay());
            }
            if (this.fColor == null) {
                this.fColor = label.getForeground();
            }
            if (StyleFieldController.this.isCueEnabled()) {
                label.setForeground(this.fLinkColor);
                GC gc = e.gc;
                gc.setForeground(this.fLinkColor);
                int marginWidth = 0;
                int marginHeight = 0;
                Rectangle carea = label.getBounds();
                int textWidth = gc.stringExtent((String)label.getText()).x;
                Rectangle bounds = new Rectangle(marginWidth, marginHeight, textWidth - marginWidth - marginWidth, carea.height - marginHeight - marginHeight);
                int descent = gc.getFontMetrics().getDescent();
                int lineY = bounds.y + bounds.height - descent + 1;
                gc.drawLine(bounds.x, lineY, bounds.x + bounds.width, lineY);
            } else {
                label.setForeground(this.fColor);
            }
        }

        private void updateCursor() {
            if (!this.isHyperLinkAvailable()) {
                return;
            }
            if (StyleFieldController.this.isCueEnabled()) {
                this.doShowCursor();
            } else {
                this.doHideCursor();
            }
        }

        private void updateHyperLinkColor(Color color) {
            if (!this.isHyperLinkAvailable()) {
                return;
            }
            Control control = StyleFieldController.this.getCueControl();
            if (control.getForeground() != color) {
                this.fLinkColor = color;
                control.redraw();
            }
        }
    }
}

