/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.attrview;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPushButtonPart;
import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;
import com.ibm.etools.webedit.common.internal.attrview.StyleFieldController;
import com.ibm.etools.webedit.common.internal.attrview.StyleLabelEnabler;
import com.ibm.etools.webedit.common.internal.attrview.StyleLabelProvider;
import com.ibm.etools.webedit.common.internal.attrview.StyleMenuProvider;
import com.ibm.etools.webedit.common.internal.attrview.StyleSelectionListener;
import com.ibm.etools.webedit.common.internal.attrview.StyleValidator;
import com.ibm.etools.webedit.common.internal.utils.ImageDescriptorUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class StyleButtonPart
extends AVPushButtonPart
implements StyleSelectionListener,
StyleLabelEnabler {
    private StyleMenuProvider provider;
    private ILabelProvider labelProvider;
    private Menu menu;
    private MenuItem[] menuItems;
    private Control styleLabel;
    private Control styleControl;
    private static final String MENU_ITEM_DATA_KEY = "StyleButtonPart.menuItems";

    public StyleButtonPart(AVData data, Composite parent, StyleMenuProvider provider, Control styleLabel, Control styleControl) {
        super(data, parent, null, ResourceHandler._UI_Label_ShowRelatedStyleProperties, ImageDescriptorUtil.createFullEView16ImageDescriptor("s.gif").createImage());
        this.provider = provider;
        this.styleLabel = styleLabel != null ? styleLabel : styleControl;
        this.styleControl = styleControl;
        StyleLabelProvider styleLabelProvider = new StyleLabelProvider(this);
        StyleFieldController.setStyleCue(this.styleLabel, this.styleControl, (ILabelProvider)styleLabelProvider, this);
        ((AttributeData)data).addValidator(new StyleValidator((ILabelProvider)styleLabelProvider));
    }

    protected void addImageDisposeListener(MenuItem item) {
        if (item == null) {
            return;
        }
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img;
                if (e.widget instanceof MenuItem && (img = ((MenuItem)e.widget).getImage()) != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
    }

    protected void createContents() {
        super.createContents();
        Composite container = this.getContainer();
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setEnabled(false);
    }

    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        StyleButtonPart.dispose((Widget)this.menu);
        this.menu = null;
        StyleButtonPart.dispose(this.menuItems);
        this.menuItems = null;
    }

    protected static void dispose(MenuItem[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                StyleButtonPart.dispose((Widget)items[i]);
                items[i] = null;
                ++i;
            }
        }
    }

    protected void handleButtonSelected() {
        this.internalSelected((Control)this.button);
    }

    @Override
    public void handleControlSelected(Control control) {
        this.internalSelected(control);
    }

    private void internalSelected(Control control) {
        if (this.provider == null || control == null) {
            return;
        }
        Object[] items = this.provider.getMenuItems(this.getDataComponent());
        if (items == null) {
            return;
        }
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu((Control)this.button);
        }
        StyleButtonPart.dispose(this.menuItems);
        this.menuItems = new MenuItem[items.length];
        if (this.labelProvider == null) {
            this.labelProvider = this.provider.getMenuLabelProvider(this.button);
        }
        if (this.labelProvider == null) {
            return;
        }
        int index = 0;
        while (index < items.length) {
            String text = this.labelProvider.getText(items[index]);
            if (text == null || text.length() == 0) {
                this.menuItems[index] = new MenuItem(this.menu, 2);
            } else {
                MenuItem menuItem = new MenuItem(this.menu, 8);
                menuItem.setText(text);
                Image image = this.labelProvider.getImage(items[index]);
                if (image != null) {
                    menuItem.setImage(image);
                    this.addImageDisposeListener(menuItem);
                }
                menuItem.addSelectionListener((SelectionListener)this);
                menuItem.setData(MENU_ITEM_DATA_KEY, items[index]);
                this.menuItems[index] = menuItem;
            }
            ++index;
        }
        Point p = control.getLocation();
        Rectangle r = control.getBounds();
        p.y += r.height;
        p = control.getParent().toDisplay(p);
        this.menu.setLocation(p.x, p.y);
        this.menu.setVisible(true);
    }

    @Override
    public boolean isLabelEnabled() {
        return this.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setVisible(this.isEnabled());
        this.setExclude(!this.isEnabled());
    }

    protected void setExclude(boolean exclude) {
        Composite containerParent = this.getContainer().getParent();
        Object layoutData = containerParent.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = exclude;
        } else {
            GridData gridData = new GridData();
            gridData.exclude = exclude;
            containerParent.setLayoutData((Object)gridData);
        }
        if (exclude) {
            containerParent.moveBelow(null);
        } else {
            containerParent.moveAbove(null);
        }
        this.getPage().getPageContainer().layout(new Control[]{containerParent});
    }

    protected void update() {
        super.update();
        StyleFieldController.updateStyleCue(this.styleLabel, this.styleControl);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.menuItems != null) {
            int index = -1;
            int i = 0;
            while (i < this.menuItems.length) {
                if (e.widget == this.menuItems[i]) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                this.provider.handleMenuSelected(this.menu, index, this.menuItems[index].getData(MENU_ITEM_DATA_KEY));
            }
        }
        super.widgetSelected(e);
    }
}

