/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.attrview;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.folders.HTMLFolder;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.attrview.pairs.HTMLPair;
import com.ibm.etools.webedit.common.internal.attrview.StyleButtonPair;
import com.ibm.etools.webedit.common.internal.attrview.StyleMenuProvider;
import com.ibm.etools.webedit.common.internal.attrview.StyleSelector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class HTMLStylePair
extends HTMLPair {
    protected AVPage page;
    protected String[] tagNames;
    protected String attrName;
    protected String[] attrNames;
    protected Composite parent;
    protected String title;
    protected static final int STYLE_CONTROL_LEFT = 1;
    protected static final int STYLE_CONTROL_RIGHT = 2;
    protected Composite root;
    private Composite styleComposite;
    private HTMLPair stylePair;
    private StyleMenuProvider styleMenuProvider;
    private String[] styleTagNames;
    private String styleAttrName;
    private String[] styleAttrNames;
    private static final String[] STYLE_PREFIX_ITEMS;
    protected static final boolean STYLE_BUTTON_IN_PART = false;

    static {
        String[] stringArray = new String[2];
        stringArray[0] = ResourceHandler._UI_StylePrefixItems;
        STYLE_PREFIX_ITEMS = stringArray;
    }

    protected HTMLStylePair() {
    }

    protected HTMLStylePair(AVPage page, String[] tagNames, String attrName, Composite parent, String title) {
        this(page, tagNames, (String[])null, parent, title);
        this.attrName = attrName;
        this.styleAttrName = attrName;
    }

    protected HTMLStylePair(AVPage page, String[] tagNames, String[] attrNames, Composite parent, String title) {
        this();
        this.page = page;
        this.tagNames = tagNames;
        this.attrNames = attrNames;
        this.parent = parent;
        this.title = title;
        this.styleTagNames = tagNames;
        this.styleAttrNames = attrNames;
    }

    protected boolean canUseStyleButton() {
        if (this.page instanceof HTMLPage) {
            return ((HTMLPage)this.page).canUseStyleButton();
        }
        return false;
    }

    protected boolean canUseStylePage() {
        if (this.page instanceof HTMLPage && this.page.getFolder() instanceof HTMLFolder) {
            return ((HTMLFolder)this.page.getFolder()).getStylePage() != null;
        }
        return false;
    }

    private boolean canUseStyleSelector() {
        return this.getStyleSelector() != null;
    }

    protected void createControllerComposite(Composite composite) {
        if (composite == null) {
            return;
        }
        this.styleComposite = WidgetUtil.createAreaComposite((AVWidgetFactory)this.page.getWidgetFactory(), (Composite)composite, (int)1);
        this.styleComposite.setLayoutData((Object)new GridData(68));
    }

    protected void createParentComposite(Composite composite) {
        if (composite == null) {
            return;
        }
        if (this.canUseStyleSelector() && this.canUseStyleButton()) {
            this.root = WidgetUtil.createAreaComposite((AVWidgetFactory)this.page.getWidgetFactory(), (Composite)composite, (int)2);
            if (this.getControllerPosition() == 1) {
                this.createControllerComposite(this.root);
            }
            this.parent = WidgetUtil.createAreaComposite((AVWidgetFactory)this.page.getWidgetFactory(), (Composite)this.root, (int)1);
            if (this.getControllerPosition() == 2) {
                this.createControllerComposite(this.root);
            }
        }
    }

    protected int getControllerPosition() {
        return 1;
    }

    public String getStyleAttrName() {
        return this.styleAttrName;
    }

    public String[] getStyleAttrNames() {
        return this.styleAttrNames;
    }

    protected StyleMenuProvider getStyleMenuProvider() {
        if (this.styleMenuProvider == null && this.page instanceof HTMLPage) {
            this.styleMenuProvider = ((HTMLPage)this.page).getStyleMenuProvider();
        }
        return this.styleMenuProvider;
    }

    public HTMLPair getStylePair() {
        return this.stylePair;
    }

    protected StyleSelector getStyleSelector() {
        if (this.page instanceof HTMLPage && this.page.getFolder() instanceof HTMLFolder) {
            return ((HTMLFolder)this.page.getFolder()).getStyleSelector();
        }
        return null;
    }

    public String[] getStyleTagNames() {
        return this.styleTagNames;
    }

    @Override
    protected void postCreate() {
        if (this.canUseStyleSelector()) {
            if (this.canUseStyleButton()) {
                MyStyleMenuProvider menuProvider = new MyStyleMenuProvider();
                this.stylePair = new StyleButtonPair(this.page, this.tagNames, "style", this.styleComposite, menuProvider, (Control)this.getLabel(), this.getControl());
                Object layoutData = this.part.getContainer().getLayoutData();
                if (layoutData instanceof GridData) {
                    GridData gridData = (GridData)layoutData;
                    this.root.setLayoutData((Object)new GridData(gridData.horizontalAlignment, gridData.verticalAlignment, gridData.grabExcessHorizontalSpace, gridData.grabExcessVerticalSpace));
                    this.parent.setLayoutData((Object)new GridData(gridData.horizontalAlignment, gridData.verticalAlignment, gridData.grabExcessHorizontalSpace, gridData.grabExcessVerticalSpace));
                }
            }
            if (this.canUseStylePage()) {
                StyleSelector selector = this.getStyleSelector();
                selector.addPairComponent(this);
            }
        }
        super.postCreate();
    }

    @Override
    protected void preCreate() {
        this.createParentComposite(this.parent);
        super.preCreate();
    }

    public void setStyleAttrName(String styleAttrName) {
        this.styleAttrName = styleAttrName;
    }

    public void setStyleAttrNames(String[] styleAttrNames) {
        this.styleAttrNames = styleAttrNames;
    }

    public void setStyleTagNames(String[] styleTagNames) {
        this.styleTagNames = styleTagNames;
    }

    private void showStylePage() {
        StyleSelector selector = this.getStyleSelector();
        selector.setSelection(this);
        HTMLFolder folder = (HTMLFolder)this.page.getFolder();
        HTMLPage sPage = folder.getStylePage();
        if (sPage != null) {
            folder.setPageDescriptor(sPage.getPageDescriptor());
            folder.getAttributesView().refreshContents();
        }
    }

    private class MyStyleMenuProvider
    implements StyleMenuProvider {
        private MyStyleMenuProvider() {
        }

        @Override
        public Object[] getMenuItems(Object object) {
            Object[] items = HTMLStylePair.this.getStyleMenuProvider().getMenuItems(HTMLStylePair.this);
            if (HTMLStylePair.this.canUseStylePage() && items != null && items.length > 0) {
                Object[] newItems = new Object[STYLE_PREFIX_ITEMS.length + items.length];
                System.arraycopy(STYLE_PREFIX_ITEMS, 0, newItems, 0, STYLE_PREFIX_ITEMS.length);
                System.arraycopy(items, 0, newItems, STYLE_PREFIX_ITEMS.length, items.length);
                return newItems;
            }
            return items;
        }

        @Override
        public ILabelProvider getMenuLabelProvider(Object object) {
            return HTMLStylePair.this.getStyleMenuProvider().getMenuLabelProvider(object);
        }

        @Override
        public void handleMenuSelected(Menu menu, int menuItemIndex, Object object) {
            if (HTMLStylePair.this.canUseStylePage() && menuItemIndex < STYLE_PREFIX_ITEMS.length) {
                HTMLStylePair.this.showStylePage();
                return;
            }
            HTMLStylePair.this.getStyleMenuProvider().handleMenuSelected(menu, menuItemIndex - STYLE_PREFIX_ITEMS.length, object);
        }
    }
}

