/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.AbstractEditRange;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class RemoveTag
extends AbstractEditRange {
    private boolean withChildren = false;

    public RemoveTag(Range range) {
        super(range);
    }

    public RemoveTag(Range range, boolean withChildren) {
        super(range);
        this.withChildren = withChildren;
    }

    public Element remove(Element element) {
        return (Element)this.removeNode(element);
    }

    public Node removeNode(Node element) {
        return this.removeNode(element, false);
    }

    public Node removeNode(Node element, boolean removeWhiteSpace) {
        Range range;
        if (element == null) {
            return null;
        }
        EditModelQuery squery = EditQueryUtil.getEditQuery(element);
        if (squery == null) {
            return null;
        }
        Node parent = element.getParentNode();
        boolean removeBefore = false;
        Node before = null;
        if (removeWhiteSpace && (before = element.getPreviousSibling()) instanceof IDOMText && ((IDOMText)before).isElementContentWhitespace()) {
            removeBefore = true;
        }
        boolean removeAfter = false;
        Node after = null;
        if (removeWhiteSpace && (!this.withChildren || !removeBefore) && (after = element.getNextSibling()) instanceof IDOMText && ((IDOMText)after).isElementContentWhitespace()) {
            removeAfter = true;
        }
        if ((range = this.getRange()) != null) {
            int offset;
            Node pre = range.getStartContainer();
            int preOffset = range.getStartOffset();
            Node post = range.getEndContainer();
            int postOffset = range.getEndOffset();
            int index = squery.getChildIndex(element);
            if (element == pre) {
                offset = index;
                if (!this.withChildren) {
                    offset += preOffset;
                }
                if (removeBefore) {
                    --offset;
                }
                range.setStart(parent, offset);
            } else if (parent == pre) {
                if (index < preOffset) {
                    --preOffset;
                    if (removeBefore) {
                        --preOffset;
                    }
                    range.setStart(parent, preOffset);
                }
            } else if (squery.isAncestor(element, pre)) {
                if (this.withChildren) {
                    offset = index;
                    if (removeBefore) {
                        --offset;
                    }
                    range.setStart(parent, offset);
                }
            } else if (removeBefore && before == pre) {
                range.setStart(parent, index - 1);
            } else if (removeAfter && after == pre) {
                range.setStart(parent, index - (removeBefore ? 1 : 0));
            }
            if (element == post) {
                offset = index;
                if (!this.withChildren) {
                    offset += postOffset;
                }
                if (removeBefore) {
                    --offset;
                }
                range.setEnd(parent, offset);
            } else if (parent == post) {
                if (index < postOffset) {
                    --postOffset;
                    if (removeBefore) {
                        --postOffset;
                    }
                    range.setEnd(parent, postOffset);
                }
            } else if (squery.isAncestor(element, post)) {
                if (this.withChildren) {
                    offset = index;
                    if (removeBefore) {
                        --offset;
                    }
                    range.setEnd(parent, offset);
                }
            } else if (removeBefore && before == post) {
                range.setEnd(parent, index - 1);
            } else if (removeAfter && after == post) {
                range.setEnd(parent, index - (removeBefore ? 1 : 0));
            }
        }
        if (!this.withChildren) {
            Node child = element.getFirstChild();
            while (child != null) {
                Node next = child.getNextSibling();
                child = element.removeChild(child);
                parent.insertBefore(child, element);
                child = next;
            }
        }
        if (parent != null) {
            if (removeBefore) {
                parent.removeChild(before);
            }
            if (removeAfter) {
                parent.removeChild(after);
            }
            return parent.removeChild(element);
        }
        return element;
    }
}

