/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.CommandRangeUtil;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class RangeNormalizer {
    private Range range = null;

    public RangeNormalizer(Range range) {
        this.range = range;
    }

    public boolean isRangeNormalized() {
        if (this.range == null) {
            return true;
        }
        Node startNode = this.range.getStartContainer();
        Node endNode = this.range.getEndContainer();
        int startOffset = this.range.getStartOffset();
        int endOffset = this.range.getEndOffset();
        return CommandRangeUtil.isRangeNormalized(startNode, startOffset, endNode, endOffset);
    }

    public static boolean isRangeNormalized(Node startNode, Node endNode) {
        return CommandRangeUtil.isRangeNormalized(startNode, 0, endNode, 0);
    }

    public boolean fixRange() {
        if (this.range == null) {
            return false;
        }
        Node startNode = this.range.getStartContainer();
        Node endNode = this.range.getEndContainer();
        int startOffset = this.range.getStartOffset();
        int endOffset = this.range.getEndOffset();
        if (startNode == null || endNode == null) {
            return false;
        }
        if (startNode.getNextSibling() == endNode) {
            if (endOffset == 0 && startNode.getNodeType() == 3 && startOffset == ((Text)startNode).getData().length()) {
                this.range.collapse(false);
                return true;
            }
        } else if (endNode.getNextSibling() == startNode && startOffset == 0 && endNode.getNodeType() == 3 && endOffset == ((Text)endNode).getData().length()) {
            this.range.collapse(true);
            return true;
        }
        return false;
    }
}

