/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.URLFixupUtil;
import com.ibm.etools.webedit.common.commands.utils.URLFixupper;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.editdomain.HTMLURLContext;
import com.ibm.etools.webedit.common.utils.ModelTypeUtil;
import java.io.IOException;
import org.eclipse.wst.html.core.internal.document.UnknownTagAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class ImportSource {
    private Document doc;
    private boolean fixUp = true;
    private HTMLSubModelContext context;

    public ImportSource(Document doc, HTMLSubModelContext context) {
        this.doc = doc;
        this.context = context;
    }

    public final void doFixup(boolean fixup) {
        this.fixUp = fixup;
    }

    private final Document getDomDocument(String source) {
        IStructuredModel structuredModel;
        IDOMModel currentModel = ((IDOMNode)this.doc).getModel();
        if (currentModel == null) {
            return null;
        }
        if (!ModelTypeUtil.isHTMLFamily((IStructuredModel)currentModel)) {
            return null;
        }
        try {
            structuredModel = currentModel.newInstance();
        }
        catch (IOException iOException) {
            structuredModel = null;
        }
        if (structuredModel == null) {
            return null;
        }
        if (!ModelTypeUtil.isHTMLFamily(structuredModel)) {
            return null;
        }
        IStructuredDocument flatModel = structuredModel.getStructuredDocument();
        flatModel.setText((Object)this, source);
        IDOMDocument newDocument = ((IDOMModel)structuredModel).getDocument();
        this.importDocumentType(currentModel.getDocument(), newDocument);
        return newDocument;
    }

    private final void releaseTempDocument(Document tempdoc) {
        if (tempdoc == null) {
            return;
        }
        if (!(tempdoc instanceof IDOMDocument)) {
            return;
        }
        IDOMModel model = ((IDOMDocument)tempdoc).getModel();
        if (model != null) {
            model.releaseFromEdit();
        }
    }

    public final DocumentFragment getFragment(String source) {
        Document tempdoc;
        if (this.doc == null) {
            return null;
        }
        if (this.fixUp) {
            URLFixupper fixupper;
            String newSource;
            IDOMModel model;
            IDOMModel iDOMModel = model = this.doc instanceof IDOMNode ? ((IDOMNode)this.doc).getModel() : null;
            if (model != null && (newSource = (fixupper = URLFixupUtil.getURLFixupper((IStructuredModel)model, (HTMLURLContext)this.context)).performLinkFixup(source, null)) != null && newSource.length() > 0) {
                source = newSource;
            }
        }
        if ((tempdoc = this.getDomDocument(source)) == null) {
            return null;
        }
        DocumentFragment fragment = this.doc.createDocumentFragment();
        if (fragment != null) {
            Node child = tempdoc.getFirstChild();
            if (child != null && child.getNodeType() == 10) {
                child = child.getNextSibling();
            }
            while (child != null) {
                Node next = child.getNextSibling();
                Node clone = this.doc.importNode(child, true);
                if (clone != null) {
                    fragment.appendChild(clone);
                }
                child = next;
            }
            this.importTag(tempdoc, fragment);
        }
        this.releaseTempDocument(tempdoc);
        return fragment;
    }

    private final void importDocumentType(IDOMDocument currentDocument, IDOMDocument newDocument) {
        if (currentDocument == null || newDocument == null) {
            return;
        }
        String currentPublicId = currentDocument.getDocumentTypeId();
        String newPublicId = newDocument.getDocumentTypeId();
        if (newPublicId != null && newPublicId.equals(currentPublicId)) {
            return;
        }
        IDOMDocumentType documentType = (IDOMDocumentType)newDocument.getDoctype();
        if (documentType != null) {
            documentType.setPublicId(currentPublicId);
        } else {
            documentType = (IDOMDocumentType)newDocument.createDoctype("HTML");
            documentType.setPublicId(currentPublicId);
            newDocument.insertBefore((Node)documentType, newDocument.getFirstChild());
        }
    }

    private final void importTag(Document document, DocumentFragment fragment) {
        DocumentTraversal traversal = (DocumentTraversal)((Object)document);
        NodeIterator from = traversal.createNodeIterator(document, 1, null, false);
        if (from == null) {
            return;
        }
        traversal = (DocumentTraversal)((Object)fragment.getOwnerDocument());
        NodeIterator to = traversal.createNodeIterator(fragment, 1, null, false);
        if (to == null) {
            return;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery == null) {
            return;
        }
        Node fromNode = from.nextNode();
        Node toNode = to.nextNode();
        while (fromNode != null && toNode != null) {
            IDOMElement element = (IDOMElement)fromNode;
            if (element.isGlobalTag() && modelQuery.getCMElementDeclaration((Element)element) == null) {
                UnknownTagAdapter adapter = new UnknownTagAdapter();
                IStructuredDocumentRegion startTag = element.getStartStructuredDocumentRegion();
                if (startTag != null) {
                    adapter.setStartTag(startTag.getText());
                } else {
                    adapter.setStartTag(new String());
                }
                IStructuredDocumentRegion endTag = element.getEndStructuredDocumentRegion();
                if (endTag != null) {
                    adapter.setEndTag(endTag.getText());
                } else {
                    adapter.setEndTag(new String());
                }
                ((IDOMNode)toNode).addAdapter((INodeAdapter)adapter);
            }
            fromNode = from.nextNode();
            toNode = to.nextNode();
        }
    }
}

