/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.DOMTreeWaker;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import java.util.ArrayList;
import org.eclipse.wst.xml.core.internal.document.XMLGeneratorImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class CommandSourceUtil {
    public static final String generateElementSource(Element element) {
        ISourceGenerator generator = XMLGeneratorImpl.getInstance();
        return generator.generateElement(element);
    }

    public static final String generateSource(Node node) {
        EditModelQuery query = EditQueryUtil.getEditQuery(node);
        switch (node.getNodeType()) {
            case 1: {
                String end;
                if (query.isSolidElement(node) || query.isEmptyNode(node)) break;
                String source = CommandSourceUtil.generateStartTag((Element)node);
                StringBuffer buf = new StringBuffer();
                CommandSourceUtil.getSelectedSource(buf, node, 0, node, node.getChildNodes().getLength(), false);
                if (buf.length() > 0) {
                    source = String.valueOf(source) + buf.toString();
                }
                if ((end = CommandSourceUtil.generateEndTag((Element)node)) != null && end.length() > 0) {
                    source = String.valueOf(source) + end;
                }
                return source;
            }
            case 3: {
                return CommandSourceUtil.getTextSource((Text)node, 0, ((Text)node).getLength());
            }
        }
        ISourceGenerator generator = XMLGeneratorImpl.getInstance();
        return generator.generateSource(node);
    }

    public static void getSelectedSource(StringBuffer buf, Range range, boolean textOnly) {
        if (range == null) {
            return;
        }
        CommandSourceUtil.getSelectedSource(buf, range.getStartContainer(), range.getStartOffset(), range.getEndContainer(), range.getEndOffset(), textOnly);
    }

    public static void getSelectedSource(StringBuffer buf, Node pre, int preOffset, Node post, int postOffset, boolean textOnly) {
        NodeList childNodes;
        if (pre == null || post == null) {
            return;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(pre);
        if (pre == post && preOffset == postOffset && (pre.getNodeType() == 3 || !query.isSolidElement(pre) && !query.isEmptyNode(pre))) {
            return;
        }
        if (!(pre.getNodeType() != 1 && pre.getNodeType() != 9 || query.isSolidElement(pre) || query.isEmptyNode(pre) || (childNodes = pre.getChildNodes()).getLength() <= 0 || childNodes.getLength() <= preOffset)) {
            pre = childNodes.item(preOffset);
            preOffset = 0;
        }
        if (!(post.getNodeType() != 1 && post.getNodeType() != 9 || query.isSolidElement(post) || query.isEmptyNode(post) || (childNodes = post.getChildNodes()).getLength() <= 0 || postOffset <= 0)) {
            String value;
            post = childNodes.item(postOffset - 1);
            postOffset = post.getNodeType() == 3 ? ((value = ((Text)post).getNodeValue()) != null ? value.length() : 0) : post.getChildNodes().getLength();
        }
        Node postLeaf = null;
        Node end = null;
        Node last = post;
        block0 : switch (post.getNodeType()) {
            case 1: {
                if (query.shouldCopy(post)) break;
                last = null;
                if (postOffset == 0) {
                    end = post;
                    break;
                }
                NodeList c = post.getChildNodes();
                if (postOffset == c.getLength()) {
                    Node lastParent = post;
                    end = lastParent.getNextSibling();
                    while (end == null) {
                        if ((lastParent = lastParent.getParentNode()) == null) break block0;
                        end = lastParent.getNextSibling();
                    }
                    break;
                }
                end = c.item(postOffset);
            }
        }
        boolean bParent = false;
        Node node = pre;
        switch (pre.getNodeType()) {
            case 3: {
                if (pre == post) {
                    String strSub = CommandSourceUtil.getTextSource((Text)post, preOffset, postOffset);
                    if (strSub != null) {
                        buf.append(strSub);
                    }
                    postLeaf = pre;
                    break;
                }
                int length = ((Text)pre).getLength();
                String strSub = CommandSourceUtil.getTextSource((Text)pre, preOffset, length);
                if (strSub != null) {
                    buf.append(strSub);
                }
                DOMTreeWaker tw = new DOMTreeWaker(node);
                node = pre;
                node = tw.toNext();
                if (node != null) {
                    bParent = false;
                    break;
                }
                node = tw.toParent();
                bParent = true;
                break;
            }
            case 1: {
                IDOMNode impl;
                String strTemp;
                if (query.shouldCopy(pre)) {
                    if (pre == post) {
                        if (!textOnly && (strTemp = (impl = (IDOMNode)pre).getSource()) != null) {
                            buf.append(strTemp);
                        }
                        postLeaf = pre;
                        break;
                    }
                    bParent = false;
                    break;
                }
                NodeList c = pre.getChildNodes();
                if (preOffset == c.getLength()) {
                    DOMTreeWaker tw = new DOMTreeWaker(node);
                    node = pre;
                    node = tw.toNext();
                    if (node != null) {
                        bParent = false;
                        break;
                    }
                    node = tw.toParent();
                    bParent = true;
                    break;
                }
                node = c.item(preOffset);
                break;
            }
            default: {
                IDOMNode impl;
                String strTemp;
                if (pre == post) {
                    if (!textOnly && (strTemp = (impl = (IDOMNode)pre).getSource()) != null) {
                        buf.append(strTemp);
                    }
                    postLeaf = pre;
                    break;
                }
                bParent = false;
            }
        }
        if (postLeaf == null) {
            ArrayList<Node> elementList = new ArrayList<Node>();
            StringBuffer postStartBuf = null;
            StringBuffer postEndBuf = null;
            while (node != null && node != last && node != end) {
                Node cand = node;
                boolean bIgnoreChildren = true;
                if (node.getNodeType() == 1 && query.isAncestor(node, post)) {
                    if (bParent) {
                        if (elementList.contains(node)) {
                            elementList.remove(node);
                            break;
                        }
                        if (node.getNodeName().equalsIgnoreCase("BODY") || textOnly) break;
                        CommandSourceUtil.surroundBufWithTag(buf, (Element)node);
                        break;
                    }
                    if (!elementList.contains(node)) {
                        elementList.add(node);
                    }
                    String startTag = CommandSourceUtil.generateStartTag((Element)node);
                    String endTag = CommandSourceUtil.generateEndTag((Element)node);
                    if (startTag != null && startTag.length() > 0) {
                        if (postStartBuf == null) {
                            postStartBuf = new StringBuffer();
                        }
                        if (!textOnly) {
                            postStartBuf.append(startTag);
                        }
                    }
                    if (endTag != null && endTag.length() > 0) {
                        if (postEndBuf == null) {
                            postEndBuf = new StringBuffer();
                        }
                        if (!textOnly) {
                            postEndBuf.insert(0, endTag);
                        }
                    }
                    if (postLeaf == null) {
                        postLeaf = node;
                    }
                    cand = null;
                    bIgnoreChildren = false;
                }
                if (cand != null) {
                    DOMTreeWaker tw;
                    String strTemp;
                    IDOMNode impl;
                    StringBuffer currentBuf;
                    StringBuffer stringBuffer = currentBuf = postStartBuf != null ? postStartBuf : buf;
                    if (bParent) {
                        if (cand.getNodeType() == 1 && !textOnly) {
                            CommandSourceUtil.surroundBufWithTag(buf, (Element)cand);
                            postLeaf = cand;
                        }
                    } else if (cand.getNodeType() == 3) {
                        impl = (IDOMNode)cand;
                        strTemp = impl.getValueSource();
                        if (strTemp != null) {
                            currentBuf.append(strTemp);
                        }
                    } else if (!textOnly && (strTemp = (impl = (IDOMNode)cand).getSource()) != null) {
                        currentBuf.append(strTemp);
                    }
                    if ((node = (tw = new DOMTreeWaker(node)).toNext()) != null) {
                        bParent = false;
                        continue;
                    }
                    node = tw.toParent();
                    bParent = true;
                    continue;
                }
                node = node.hasChildNodes() ? node.getFirstChild() : query.getNextNode(node, bIgnoreChildren);
                bParent = false;
            }
            if (last != null) {
                StringBuffer currentBuf = postStartBuf != null ? postStartBuf : buf;
                switch (last.getNodeType()) {
                    case 3: {
                        String strSub = CommandSourceUtil.getTextSource((Text)last, 0, postOffset);
                        if (strSub != null) {
                            currentBuf.append(strSub);
                        }
                        if (postLeaf != null) break;
                        postLeaf = last;
                        break;
                    }
                    default: {
                        IDOMNode impl;
                        String strTemp;
                        if (textOnly || (strTemp = (impl = (IDOMNode)last).getSource()) == null) break;
                        currentBuf.append(strTemp);
                    }
                }
            }
            if (postStartBuf != null) {
                buf.append(postStartBuf);
            }
            if (postEndBuf != null) {
                buf.append(postEndBuf);
            }
            if (elementList != null) {
                elementList.clear();
            }
        }
        if (postLeaf != null && !textOnly) {
            Node parent = postLeaf.getParentNode();
            while (parent != null) {
                if (parent.getNodeType() == 1 && (parent.getNodeName().equalsIgnoreCase("A") || query.isTextAttribute((Element)parent))) {
                    CommandSourceUtil.surroundBufWithTag(buf, (Element)parent);
                }
                parent = parent.getParentNode();
            }
        }
    }

    public static String getTextSource(Text text, int start, int end) {
        String strTemp;
        if (text == null || start >= end) {
            return null;
        }
        Text clone = (Text)text.cloneNode(true);
        if (clone != null) {
            String data = clone.getData();
            if (data != null && data.length() > end) {
                clone.splitText(end);
            }
            if (start > 0) {
                clone = clone.splitText(start);
            }
        }
        String val = null;
        if (clone != null && clone instanceof IDOMNode) {
            val = ((IDOMNode)clone).getValueSource();
        }
        if ((val == null || val.length() == 0) && (strTemp = text.getData()) != null) {
            val = strTemp.substring(start, end);
        }
        return val;
    }

    public static final String generateStartTag(Element element) {
        ISourceGenerator generator = XMLGeneratorImpl.getInstance();
        return generator.generateStartTag(element);
    }

    public static final String generateEndTag(Element element) {
        ISourceGenerator generator = XMLGeneratorImpl.getInstance();
        return generator.generateEndTag(element);
    }

    public static void surroundBufWithTag(StringBuffer buf, Element element) {
        String startTag = CommandSourceUtil.generateStartTag(element);
        String endTag = CommandSourceUtil.generateEndTag(element);
        if (startTag != null && startTag.length() > 0) {
            buf.insert(0, startTag);
        }
        if (endTag != null && endTag.length() > 0) {
            buf.append(endTag);
        }
    }
}

