/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.RangeNormalizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class CommandRangeUtil {
    public static final boolean isContainerBefore(Node node, Range range, boolean checkStartContainer) {
        int offset;
        if (node == null || range == null) {
            return false;
        }
        Node start = checkStartContainer ? range.getStartContainer() : range.getEndContainer();
        int n = offset = checkStartContainer ? range.getStartOffset() : range.getEndOffset();
        if (start == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent != start) {
            return false;
        }
        NodeList list = parent.getChildNodes();
        try {
            return list.item(offset) == node;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isContainerAfter(Node node, Range range, boolean checkStartContainer) {
        int offset;
        if (node == null || range == null) {
            return false;
        }
        Node start = checkStartContainer ? range.getStartContainer() : range.getEndContainer();
        int n = offset = checkStartContainer ? range.getStartOffset() : range.getEndOffset();
        if (start == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent != start) {
            return false;
        }
        NodeList list = parent.getChildNodes();
        try {
            Node item = list.item(offset);
            if (item != null) {
                return item.getPreviousSibling() == node;
            }
            item = list.item(offset - 1);
            return item == node;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRangeNormalized(Node startNode, int startOffset, Node endNode, int endOffset) {
        if (startNode == null || endNode == null) {
            return true;
        }
        if (startNode == endNode) {
            return startOffset <= endOffset;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(startNode);
        if (query == null) {
            return true;
        }
        Node start1 = startNode;
        Node child1 = null;
        while (start1 != null) {
            Node start2 = endNode;
            Node child2 = null;
            while (start2 != null) {
                if (start1 == start2) {
                    int nIndex2;
                    int nIndex1;
                    if (start1 == startNode || start2 == endNode) {
                        nIndex1 = start1 == startNode ? startOffset : query.getChildIndex(child1);
                        nIndex2 = start2 == endNode ? endOffset : query.getChildIndex(child2);
                    } else {
                        nIndex1 = query.getChildIndex(child1);
                        nIndex2 = query.getChildIndex(child2);
                    }
                    if (nIndex1 != nIndex2) {
                        return nIndex1 <= nIndex2;
                    }
                    return start1 == startNode;
                }
                child2 = start2;
                start2 = start2.getParentNode();
            }
            child1 = start1;
            start1 = start1.getParentNode();
        }
        return true;
    }

    public static boolean isChildOfStartNode(Range range, Node elm, boolean check_Ancestor) {
        if (range == null) {
            return false;
        }
        Node start = range.getStartContainer();
        do {
            if (start == elm) {
                return true;
            }
            start = start.getParentNode();
        } while (check_Ancestor && start != null);
        return false;
    }

    public static boolean isChildOfEndNode(Range range, Node elm, boolean check_Ancestor) {
        if (range == null) {
            return false;
        }
        Node start = range.getEndContainer();
        do {
            if (start == elm) {
                return true;
            }
            start = start.getParentNode();
        } while (check_Ancestor && start != null);
        return false;
    }

    public static boolean isOnlyText(Range range) {
        Node pre = null;
        Node post = null;
        int preOffset = -1;
        int postOffset = -1;
        RangeNormalizer normalizer = new RangeNormalizer(range);
        boolean normalized = normalizer.isRangeNormalized();
        if (normalized) {
            pre = range.getStartContainer();
            post = range.getEndContainer();
            preOffset = range.getStartOffset();
            postOffset = range.getEndOffset();
        } else {
            post = range.getStartContainer();
            pre = range.getEndContainer();
            postOffset = range.getStartOffset();
            preOffset = range.getEndOffset();
        }
        if (CommandRangeUtil.isUnitTextNode(pre, post)) {
            return true;
        }
        if (CommandRangeUtil.isTextNodeSequence(pre, post)) {
            return true;
        }
        Node preTextNode = CommandRangeUtil.getOverlappedPreTextNode(pre, preOffset);
        Node postTextNode = CommandRangeUtil.getOverlappedPostTextNode(post, postOffset);
        if (preTextNode != null && postTextNode != null) {
            if (CommandRangeUtil.isUnitTextNode(preTextNode, postTextNode)) {
                return true;
            }
            if (CommandRangeUtil.isTextNodeSequence(preTextNode, postTextNode)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCollapse(Range range) {
        Node pre = null;
        Node post = null;
        int preOffset = -1;
        int postOffset = -1;
        RangeNormalizer normalizer = new RangeNormalizer(range);
        boolean normalized = normalizer.isRangeNormalized();
        if (normalized) {
            pre = range.getStartContainer();
            post = range.getEndContainer();
            preOffset = range.getStartOffset();
            postOffset = range.getEndOffset();
        } else {
            post = range.getStartContainer();
            pre = range.getEndContainer();
            postOffset = range.getStartOffset();
            preOffset = range.getEndOffset();
        }
        return pre.equals(post) && preOffset == postOffset;
    }

    private static boolean isUnitTextNode(Node start, Node end) {
        return start.getNodeType() == 3 && start.equals(end);
    }

    private static boolean isTextNodeSequence(Node start, Node end) {
        Node next = start;
        while (next.getNextSibling() != null) {
            if ((next = next.getNextSibling()).getNodeType() != 3) {
                return false;
            }
            if (!next.equals(end)) continue;
            return true;
        }
        return false;
    }

    private static Node getOverlappedPreTextNode(Node node, int offset) {
        if (node.getNodeType() == 3) {
            return node;
        }
        Node child = CommandRangeUtil.findChild(node, offset);
        if (child != null && child.getNodeType() == 3) {
            return child;
        }
        return null;
    }

    private static Node getOverlappedPostTextNode(Node node, int offset) {
        if (node.getNodeType() == 3) {
            return node;
        }
        if (offset == 0) {
            return null;
        }
        Node child = CommandRangeUtil.findChild(node, offset - 1);
        if (child != null && child.getNodeType() == 3) {
            return child;
        }
        return null;
    }

    private static Node findChild(Node node, int n) {
        if (node.getFirstChild() == null) {
            return null;
        }
        Node child = node.getFirstChild();
        int i = 0;
        while (i < n) {
            if (child.getNextSibling() == null) {
                return null;
            }
            child = child.getNextSibling();
        }
        return child;
    }
}

