/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.AbstractEditRange;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class CleanupTag
extends AbstractEditRange {
    private boolean garbageSiblingAncestor = true;

    public CleanupTag(Range range) {
        super(range);
    }

    private boolean canCleanupChildren(Element element) {
        return this.canAdjustElement(element);
    }

    private boolean canCleanupSibling(Element element) {
        if (element.getNodeName().equalsIgnoreCase("A")) {
            return false;
        }
        return this.canAdjustElement(element);
    }

    private boolean canCleanupParent(Element element) {
        return this.canAdjustElement(element);
    }

    private boolean canAdjustElement(Element element) {
        if (element == null) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(element);
        if (query == null) {
            return false;
        }
        if (query.isTextAttribute(element)) {
            return true;
        }
        String nodename = element.getNodeName();
        if (nodename.equalsIgnoreCase("A")) {
            return true;
        }
        if (nodename.equalsIgnoreCase("ACRONYM")) {
            return true;
        }
        return nodename.equalsIgnoreCase("ABBR");
    }

    private boolean canSwapNode(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1 == node2) {
            return false;
        }
        Node parent1 = node1.getParentNode();
        Node parent2 = node2.getParentNode();
        EditModelQuery query = EditQueryUtil.getEditQuery(node1);
        if (query == null) {
            return false;
        }
        if (!query.canContain(parent1, node2) || !query.canContain(parent2, node1)) {
            return false;
        }
        if (node1.getNodeType() == 1 && node2.getNodeType() == 1 && query.isEqual((Element)node1, (Element)node2)) {
            return false;
        }
        Range range = this.getRange();
        if (query.isAncestor(node1, node2)) {
            Node check = node2;
            while (check != null) {
                if (!CleanupTag.isNoSibling(check, range)) {
                    return false;
                }
                if ((check = check.getParentNode()) != node1) continue;
                return true;
            }
            return false;
        }
        if (query.isAncestor(node2, node1)) {
            Node check = node1;
            while (check != null) {
                if (!CleanupTag.isNoSibling(check, range)) {
                    return false;
                }
                if ((check = check.getParentNode()) != node2) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void cleanup(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        if (this.canCleanupChildren((Element)node)) {
            this.cleanupChildren(node);
        }
        if (this.canCleanupSibling((Element)node)) {
            this.cleanupSibling(node);
        }
        if (this.canCleanupParent((Element)node)) {
            this.cleanupParent(node, false);
        }
    }

    private void cleanupChildren(Node node) {
        if (node == null) {
            return;
        }
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return;
        }
        Node child = firstChild;
        while (child != null) {
            this.cleanupChildren(child);
            child = child.getNextSibling();
        }
        this.cleanupSibling(firstChild);
    }

    private boolean cleanupNextSibling(Node sibling, boolean bNext) {
        boolean bRC = false;
        EditModelQuery query = EditQueryUtil.getEditQuery(sibling);
        if (query == null) {
            return false;
        }
        Range range = this.getRange();
        while (sibling != null) {
            Node next = CleanupTag.getadjustSibling(sibling, bNext, range);
            if (next == null) break;
            if (sibling.getNodeType() == 1 && next.getNodeType() == 1) {
                Element siblingElement = (Element)sibling;
                boolean bAdjust = false;
                if (this.canAdjustElement(siblingElement)) {
                    if (sibling.getNodeName().equalsIgnoreCase(next.getNodeName())) {
                        bAdjust = true;
                    } else if (this.garbageSiblingAncestor) {
                        Element adjustableAncestor = this.getNoSiblingParent(next, sibling.getNodeName());
                        if (adjustableAncestor != null) {
                            bAdjust = this.swapNode(adjustableAncestor, next);
                            if (bAdjust) {
                                next = adjustableAncestor;
                            }
                        } else {
                            Element adjustableSibling;
                            boolean AdjustChildren = false;
                            Element adjustableNext = this.getNoSiblingChild(next, sibling.getNodeName());
                            if (adjustableNext != null && (bAdjust = this.swapNode(next, adjustableNext))) {
                                next = adjustableNext;
                                AdjustChildren = true;
                            }
                            if (!AdjustChildren && (bAdjust = this.swapNode(sibling, adjustableSibling = this.getNoSiblingChild(sibling, next.getNodeName())))) {
                                sibling = adjustableSibling;
                            }
                        }
                    }
                }
                if (bAdjust) {
                    bAdjust = false;
                    Element nextElement = (Element)next;
                    if (query.isEqual(siblingElement, nextElement)) {
                        bAdjust = true;
                    }
                    if (bAdjust) {
                        if (sibling.hasChildNodes()) {
                            if (next.hasChildNodes()) {
                                Node nextFirstChild;
                                Node node = nextFirstChild = bNext ? next.getFirstChild() : next.getLastChild();
                                if (nextFirstChild != null) {
                                    if (bNext) {
                                        this.moveNodeBefore(nextFirstChild, sibling.getFirstChild(), sibling.getLastChild());
                                    } else {
                                        this.moveNodeAfter(nextFirstChild, sibling.getFirstChild(), sibling.getLastChild());
                                    }
                                } else {
                                    this.moveNodeParent(next, sibling.getFirstChild(), sibling.getLastChild());
                                }
                            } else {
                                this.moveNodeParent(next, sibling.getFirstChild(), sibling.getLastChild());
                            }
                        }
                        if (next.hasChildNodes()) {
                            this.cleanupSibling(next.getFirstChild());
                        }
                        RemoveTag rtag = new RemoveTag(range);
                        sibling = rtag.removeNode(sibling);
                        bRC = true;
                    }
                }
            }
            sibling = next;
        }
        return bRC;
    }

    private void cleanupParent(Node node, boolean all) {
        Node parent = node.getParentNode();
        while (parent != null) {
            Node grandParent = parent.getParentNode();
            this.cleanupSibling(parent);
            if (!all) break;
            parent = grandParent;
        }
    }

    private void cleanupSibling(Node node) {
        Node sibling;
        Node node2 = sibling = node != null ? this.getFirstSibling(node) : null;
        if (sibling == null) {
            return;
        }
        this.cleanupNextSibling(sibling, true);
    }

    private static Node getadjustSibling(Node sibling, boolean bNext, Range range) {
        if (sibling == null) {
            return null;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(sibling);
        if (query == null) {
            return null;
        }
        Node start = null;
        Node end = null;
        if (range != null) {
            start = range.getStartContainer();
            end = range.getEndContainer();
        }
        Node next = bNext ? sibling.getNextSibling() : sibling.getPreviousSibling();
        while (next != null) {
            if (next.getNodeType() != 3 || !query.isEmptyText((Text)next) || next == start || next == end) break;
            Node node = next = bNext ? next.getNextSibling() : next.getPreviousSibling();
        }
        return next;
    }

    private Node getFirstSibling(Node node) {
        while (node != null) {
            Node prev = node.getPreviousSibling();
            if (prev == null) break;
            node = prev;
        }
        return node;
    }

    private Element getNoSiblingChild(Node node, String tagName) {
        Node next;
        if (node == null || tagName == null) {
            return null;
        }
        Node check = node.getFirstChild();
        if (check == null) {
            return null;
        }
        Range range = this.getRange();
        Element checkElement = null;
        if (check.getNodeType() == 1) {
            checkElement = (Element)check;
        } else {
            next = CleanupTag.getadjustSibling(check, true, range);
            if (next == null || next.getNodeType() != 1) {
                return null;
            }
            Node prev = CleanupTag.getadjustSibling(next, false, range);
            if (prev != check) {
                return null;
            }
            checkElement = (Element)next;
        }
        if (checkElement == null) {
            return null;
        }
        if (!checkElement.getNodeName().equalsIgnoreCase(tagName)) {
            return null;
        }
        next = CleanupTag.getadjustSibling(checkElement, true, range);
        if (next != null) {
            return null;
        }
        return checkElement;
    }

    private Element getNoSiblingParent(Node node, String tagName) {
        if (node == null || tagName == null) {
            return null;
        }
        Node check = node.getParentNode();
        Range range = this.getRange();
        while (check != null) {
            if (check.getNodeType() != 1 || !CleanupTag.isNoSibling(check, range)) break;
            if (check.getNodeName().equalsIgnoreCase(tagName)) {
                return (Element)check;
            }
            if (!this.canAdjustElement((Element)check)) break;
            check = check.getParentNode();
        }
        return null;
    }

    public static boolean isNoSibling(Node node, Range range) {
        if (node == null) {
            return true;
        }
        Node prev = CleanupTag.getadjustSibling(node, false, range);
        if (prev != null) {
            return false;
        }
        Node next = CleanupTag.getadjustSibling(node, true, range);
        return next == null;
    }

    private void moveNodeAfter(Node after, Node first, Node end) {
        Node newParent;
        Node node = newParent = after != null ? after.getParentNode() : null;
        if (newParent == null) {
            return;
        }
        Range range = this.getRange();
        EditModelQuery query = EditQueryUtil.getEditQuery(newParent);
        if (query == null) {
            return;
        }
        Node parent = first.getParentNode();
        NodeList children = parent != null ? parent.getChildNodes() : null;
        int numChildren = children != null ? children.getLength() : 0;
        int firstIndex = first != null ? query.getChildIndex(first) : 0;
        int endIndex = end != null ? query.getChildIndex(end) : numChildren;
        int afterIndex = query.getChildIndex(after);
        int startOffset = range != null ? range.getStartOffset() : -1;
        int endOffset = range != null ? range.getEndOffset() : -1;
        Node startContainer = range != null ? range.getStartContainer() : null;
        Node endContainer = range != null ? range.getEndContainer() : null;
        int numAdd = 0;
        Node child = first;
        Node insBefore = after.getNextSibling();
        while (child != null) {
            Node next = child.getNextSibling();
            if (parent != null) {
                child = parent.removeChild(child);
            }
            newParent.insertBefore(child, insBefore);
            ++numAdd;
            if (child == end) break;
            child = next;
        }
        if (startContainer == parent && parent != null) {
            if (firstIndex <= startOffset && startOffset <= endIndex) {
                range.setStart(newParent, startOffset - firstIndex + afterIndex + 1);
            }
        } else if (startContainer == newParent && newParent != null && startOffset > afterIndex) {
            range.setStart(newParent, startOffset + numAdd + 1);
        }
        if (endContainer == parent && parent != null) {
            if (firstIndex <= endOffset && endOffset <= endIndex + 1) {
                range.setEnd(newParent, endOffset - firstIndex + afterIndex + 1);
            }
        } else if (endContainer == newParent && newParent != null && endOffset > afterIndex) {
            range.setEnd(newParent, endOffset + numAdd + 1);
        }
    }

    private void moveNodeBefore(Node before, Node first, Node end) {
        this.moveNodeBefore(before, first, end, null);
    }

    private void moveNodeBefore(Node before, Node first, Node end, Node newParent) {
        Node node = newParent != null ? newParent : (newParent = before != null ? before.getParentNode() : null);
        if (newParent == null) {
            return;
        }
        Range range = this.getRange();
        EditModelQuery query = EditQueryUtil.getEditQuery(newParent);
        if (query == null) {
            return;
        }
        Node parent = first.getParentNode();
        NodeList children = parent != null ? parent.getChildNodes() : null;
        int numChildren = children != null ? children.getLength() : 0;
        int firstIndex = first != null ? query.getChildIndex(first) : 0;
        int endIndex = end != null ? query.getChildIndex(end) : numChildren;
        int beforeIndex = query.getChildIndex(before);
        int startOffset = range != null ? range.getStartOffset() : -1;
        int endOffset = range != null ? range.getEndOffset() : -1;
        Node startContainer = range != null ? range.getStartContainer() : null;
        Node endContainer = range != null ? range.getEndContainer() : null;
        int numAdd = 0;
        Node child = first;
        Node insBefore = before;
        while (child != null) {
            Node next = child.getNextSibling();
            if (parent != null) {
                child = parent.removeChild(child);
            }
            newParent.insertBefore(child, insBefore);
            ++numAdd;
            if (child == end) break;
            child = next;
        }
        if (startContainer == parent && parent != null) {
            if (firstIndex <= startOffset && startOffset <= endIndex + 1) {
                range.setStart(newParent, startOffset - firstIndex + beforeIndex);
            }
        } else if (startContainer == newParent && newParent != null && startOffset >= beforeIndex) {
            range.setStart(newParent, startOffset + numAdd);
        }
        if (endContainer == parent && parent != null) {
            if (firstIndex <= endOffset && endOffset <= endIndex + 1) {
                range.setEnd(newParent, endOffset - firstIndex + beforeIndex);
            }
        } else if (endContainer == newParent && newParent != null && endOffset >= beforeIndex) {
            range.setEnd(newParent, endOffset + numAdd);
        }
    }

    private void moveNodeParent(Node parent, Node first, Node end) {
        if (parent == null || first == null) {
            return;
        }
        if (first.getParentNode() == parent) {
            return;
        }
        Node lastChild = parent.getLastChild();
        if (lastChild != null) {
            this.moveNodeAfter(lastChild, first, end);
        } else {
            this.moveNodeBefore(null, first, end, parent);
        }
    }

    private boolean swapNode(Node node1, Node node2) {
        if (!this.canSwapNode(node1, node2)) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(node1);
        if (query == null) {
            return false;
        }
        if (query.isAncestor(node1, node2)) {
            return this.swapNodeAnchestor(node1, node2);
        }
        if (query.isAncestor(node2, node2)) {
            return this.swapNodeAnchestor(node2, node1);
        }
        Node parent1 = node1.getParentNode();
        Node parent2 = node2.getParentNode();
        Node next1 = node1.getNextSibling();
        Node next2 = node2.getNextSibling();
        node1 = parent1.removeChild(node1);
        node2 = parent1.removeChild(node2);
        parent2.insertBefore(node1, next2);
        parent1.insertBefore(node2, next1);
        return true;
    }

    private boolean swapNodeAnchestor(Node anc, Node cld) {
        Node cloneAnc = anc.cloneNode(false);
        Node cloneCld = cld.cloneNode(false);
        Range range = this.getRange();
        if (range != null) {
            if (range.getStartContainer() == anc) {
                range.setStart(cloneCld, range.getStartOffset());
            } else if (range.getStartContainer() == cld) {
                range.setStart(cloneAnc, range.getStartOffset());
            }
            if (range.getEndContainer() == anc) {
                range.setEnd(cloneCld, range.getEndOffset());
            } else if (range.getEndContainer() == cld) {
                range.setEnd(cloneAnc, range.getEndOffset());
            }
        }
        cld.getParentNode().insertBefore(cloneAnc, cld.getNextSibling());
        this.moveNodeParent(cloneAnc, cld.getFirstChild(), cld.getLastChild());
        cld = cld.getParentNode().removeChild(cld);
        anc.getParentNode().insertBefore(cloneCld, anc.getNextSibling());
        this.moveNodeParent(cloneCld, anc.getFirstChild(), anc.getLastChild());
        anc = anc.getParentNode().removeChild(anc);
        return false;
    }
}

