/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.factories;

import com.ibm.etools.webedit.common.commands.factories.AbstractNodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class TableFactory
extends AbstractNodeFactory {
    private int row = 1;
    private int col = 1;
    private int ins_row = 0;
    private int ins_col = 0;
    public static final String HIDE_BORDER_VALUE = "0";
    public static final String SHOW_BORDER_VALUE = "1";

    public TableFactory() {
        super("TABLE");
    }

    public TableFactory(int row, int col) {
        super("TABLE");
        this.row = row;
        this.col = col;
    }

    @Override
    public Node createNode(Document doc, Range range) {
        String line_delim;
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return null;
        }
        CMElementDeclaration decl_tbody = query.getElementDeclaration(query.getTbodyElementName(), doc);
        Element table = doc.createElement(query.getTableElementName());
        String value = null;
        if (query.isAttributeAvailable(table, "width") && (value = this.getAttribute("width")) != null) {
            table.setAttribute("width", value);
        }
        if (query.isAttributeAvailable(table, "border") && (value = this.getAttribute("border")) != null) {
            table.setAttribute("border", value);
        }
        if (query.isAttributeAvailable(table, "cellpadding") && (value = this.getAttribute("cellpadding")) != null) {
            table.setAttribute("cellpadding", value);
        }
        if (query.isAttributeAvailable(table, "cellspacing") && (value = this.getAttribute("cellspacing")) != null) {
            table.setAttribute("cellspacing", value);
        }
        if (query.isAttributeAvailable(table, "columns")) {
            table.setAttribute("columns", String.valueOf(this.col));
        }
        if ((line_delim = this.getLineDelimiter((IDOMDocument)doc)) == null) {
            line_delim = new String();
        }
        String indent = new HTMLFormatProcessorImpl().getFormatPreferences().getIndent();
        String row_delim = line_delim;
        String cell_delim = line_delim;
        String body_delim = null;
        if (indent != null) {
            row_delim = String.valueOf(row_delim) + indent;
            cell_delim = String.valueOf(cell_delim) + indent;
            cell_delim = String.valueOf(cell_delim) + indent;
        }
        Element tr_parent = null;
        if (decl_tbody != null) {
            tr_parent = doc.createElement(query.getTbodyElementName());
            body_delim = line_delim;
            if (indent != null) {
                body_delim = String.valueOf(body_delim) + indent;
            }
            table.appendChild(doc.createTextNode(body_delim));
            table.appendChild(tr_parent);
            row_delim = String.valueOf(row_delim) + indent;
            cell_delim = String.valueOf(cell_delim) + indent;
        } else {
            tr_parent = table;
        }
        Element firstCell = this.createTableRow(doc, range, query, row_delim, cell_delim, tr_parent);
        if (body_delim != null) {
            tr_parent.appendChild(doc.createTextNode(body_delim));
        }
        table.appendChild(doc.createTextNode(line_delim));
        range.setStart(firstCell, 0);
        range.setEnd(firstCell, 0);
        return table;
    }

    protected Element createTableRow(Document doc, Range range, EditModelQuery query, String row_delim, String cell_delim, Element tr_parent) {
        return this.createTableRow(doc, query, row_delim, cell_delim, tr_parent);
    }

    protected Element createTableRow(Document doc, EditModelQuery query, String row_delim, String cell_delim, Element tr_parent) {
        Element firstCell = null;
        int r = 0;
        while (r < this.row) {
            Element tr = doc.createElement(query.getTrElementName());
            int c = 0;
            while (c < this.col) {
                Element td = doc.createElement(query.getTdElementName());
                if (r == this.ins_row && c == this.ins_col) {
                    firstCell = td;
                }
                tr.appendChild(doc.createTextNode(cell_delim));
                tr.appendChild(td);
                ++c;
            }
            tr.appendChild(doc.createTextNode(row_delim));
            tr_parent.appendChild(doc.createTextNode(row_delim));
            tr_parent.appendChild(tr);
            ++r;
        }
        return firstCell;
    }

    @Override
    public boolean canCreateNode(Document doc) {
        if (doc == null) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return false;
        }
        CMElementDeclaration decl_table = query.getElementDeclaration(query.getTableElementName(), doc);
        return decl_table != null;
    }

    private String getLineDelimiter(IDOMDocument document) {
        IStructuredDocument flatModel;
        IDOMModel model = document.getModel();
        if (model != null && (flatModel = model.getStructuredDocument()) != null) {
            return flatModel.getLineDelimiter();
        }
        return null;
    }
}

