/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.DocLevelEditCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.utils.JSPRootAttributeModifier;
import com.ibm.etools.webedit.common.utils.DocumentUtilDispatcher;
import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPRootTaglibDirectiveCommand
extends DocLevelEditCommand {
    private static final String XMLNS = "xmlns:";
    private Element jspRoot = null;
    private String prefix = null;
    private String uri = null;

    public JSPRootTaglibDirectiveCommand(String name, Element jspRoot, String prefix, String uri) {
        super(name);
        this.jspRoot = jspRoot;
        this.prefix = prefix;
        this.uri = uri;
    }

    public Element getJspRoot() {
        return this.jspRoot;
    }

    @Override
    protected void doExecute() {
        if (this.jspRoot == null) {
            return;
        }
        if (this.prefix == null) {
            return;
        }
        if (this.prefix.length() == 0) {
            return;
        }
        this.storeSelection();
        JSPRootAttributeModifier attrModifier = AttributeModifierUtil.getAttributeModifier(this, this.jspRoot);
        String attrName = XMLNS + this.prefix;
        if (this.uri == null) {
            attrModifier.removeAttribute(this.jspRoot, attrName);
        } else {
            attrModifier.setAttribute(this.jspRoot, attrName, this.uri);
        }
        this.restoreSelection();
    }

    private static class AttributeModifierUtil {
        private AttributeModifierUtil() {
        }

        public static JSPRootAttributeModifier getAttributeModifier(HTMLCommand command, Node node) {
            DocumentUtilDispatcher dispatcher = AttributeModifierUtil.getDocumentUtilDispatcher(node);
            JSPRootAttributeModifier result = null;
            if (dispatcher != null) {
                result = (JSPRootAttributeModifier)dispatcher.getCommandDelegation(command, JSPRootAttributeModifier.class);
            }
            if (result != null) {
                return result;
            }
            return new DefaultAttributeModifier();
        }

        private static DocumentUtilDispatcher getDocumentUtilDispatcher(Node node) {
            if (node != null && node.getOwnerDocument() != null) {
                return AttributeModifierUtil.getDocumentUtilDispatcher(node.getOwnerDocument());
            }
            if (node instanceof INodeNotifier) {
                return (DocumentUtilDispatcher)((INodeNotifier)node).getAdapterFor(DocumentUtilDispatcher.class);
            }
            return null;
        }
    }

    private static class DefaultAttributeModifier
    implements JSPRootAttributeModifier {
        private DefaultAttributeModifier() {
        }

        @Override
        public void setAttribute(Element element, String name, String value) {
            NodeDataAccessor.setAttribute(element, name, value);
        }

        @Override
        public void removeAttribute(Element element, String name) {
            if (element != null) {
                element.removeAttribute(name);
            }
        }
    }
}

