/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertNodeCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.CommandTreeManipulator;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.utils.ReadOnlySupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertSolidCommand
extends InsertNodeCommand {
    HTMLCommand.Condition freelayCondition = FLM_ADD_CELL;

    public InsertSolidCommand(NodeFactory factory) {
        super(factory);
    }

    @Override
    protected Range doInsert(Document document, Range range, NodeFactory factory) {
        Node n;
        EditModelQuery query = this.getEditQuery();
        if (query == null) {
            return null;
        }
        Range textTargetRange = ((DocumentRange)((Object)document)).createRange();
        Node node = factory.createNode(document, textTargetRange);
        if (node == null) {
            return null;
        }
        this.deleteRange(false);
        Node targetNode = range.getEndContainer();
        int targetOffset = range.getEndOffset();
        boolean isReadOnly = false;
        if (targetNode.getNodeType() == 3) {
            isReadOnly = !ReadOnlySupport.isDataEditable(targetNode);
        } else if (query.isEmptyNode(targetNode) && query.isSolidElement(targetNode)) {
            isReadOnly = !ReadOnlySupport.isRemovableNode(targetNode);
        } else {
            boolean bl = isReadOnly = !ReadOnlySupport.isChildEditable(targetNode);
        }
        if (isReadOnly && (n = this.getRemovableNode(targetNode)) != null && n != targetNode) {
            targetOffset = query.getChildIndex(n) + 1;
            targetNode = n.getParentNode();
            if (targetNode == null) {
                return null;
            }
        }
        new CommandTreeManipulator(range).insertNode(node, null, targetNode, targetOffset, true);
        return range;
    }

    @Override
    public HTMLCommand.Condition getFreeLayoutSupport() {
        return this.freelayCondition;
    }

    @Override
    public void setFreeLayoutSupport(HTMLCommand.Condition condition) {
        this.freelayCondition = condition;
    }
}

