/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.InsertNodeCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.CommandSourceUtil;
import com.ibm.etools.webedit.common.commands.utils.CommandTreeManipulator;
import com.ibm.etools.webedit.common.commands.utils.ImportSource;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import com.ibm.etools.webedit.common.internal.commands.utils.CommonCommandLabel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertCustomTagCommand
extends InsertNodeCommand {
    public InsertCustomTagCommand(NodeFactory factory) {
        super(factory);
    }

    @Override
    protected Range doInsert(Document document, Range range, NodeFactory factory) {
        Range textTargetRange = ((DocumentRange)((Object)document)).createRange();
        Node node = factory.createNode(document, textTargetRange);
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Range nr = this.getNormalizedRange(range);
        if (nr == null) {
            return null;
        }
        CommandSourceUtil.getSelectedSource(buf, nr, false);
        Node end = range.getEndContainer();
        this.deleteRange(false);
        new CommandTreeManipulator(range).insertNode(node, null, end, range.getEndOffset(), true);
        if (!this.getEditQuery().isSolidElement(node) && !this.getEditQuery().isEmptyNode(node)) {
            ImportSource imp;
            DocumentFragment frag;
            String strHtml;
            String string = strHtml = buf != null ? buf.toString() : null;
            if (strHtml != null && strHtml.length() > 0 && (frag = (imp = new ImportSource(document, this.getCommandTarget().getActiveSubModelContext())).getFragment(strHtml)) != null) {
                Node first = null;
                Node last = null;
                Element body = this.getBodyElement(frag);
                if (body != null) {
                    first = body.getFirstChild();
                    last = body.getLastChild();
                }
                if (first != null) {
                    new CommandTreeManipulator(range).insertNodes(first, last, node, 0);
                    if (first == last && end.getNodeType() != 3 && (this.getEditQuery().isSolidElement(end) || this.getEditQuery().isEmptyNode(end))) {
                        new RemoveTag(range, true).removeNode(end, false);
                    }
                }
            }
        }
        this.setRange(range);
        this.setLabel(CommonCommandLabel.LABEL_INSERT_A_CUSTOM_TAG);
        return range;
    }

    protected Element getBodyElement(Node frag) {
        if (frag == null) {
            return null;
        }
        if (frag.getNodeType() == 1 && frag.getNodeName().equalsIgnoreCase("BODY")) {
            return (Element)frag;
        }
        Node child = frag.getFirstChild();
        while (child != null) {
            Element body = this.getBodyElement(child);
            if (body != null) {
                return body;
            }
            child = child.getNextSibling();
        }
        return null;
    }
}

