/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertNodeCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.CommandSourceUtil;
import com.ibm.etools.webedit.common.commands.utils.CommandTreeManipulator;
import com.ibm.etools.webedit.common.commands.utils.DOMTreeWaker;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.utils.ReadOnlySupport;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertContainerCommand
extends InsertNodeCommand {
    public InsertContainerCommand(NodeFactory factory) {
        super(factory);
    }

    protected void prepareRange(Range range) {
        EditModelQuery query = this.getEditQuery();
        if (range != null && range.getCollapsed()) {
            boolean isReadOnly = false;
            Node node = range.getStartContainer();
            if (node.getNodeType() == 3) {
                isReadOnly = !ReadOnlySupport.isDataEditable(node);
            } else if (query.isEmptyNode(node) && query.isSolidElement(node)) {
                isReadOnly = !ReadOnlySupport.isRemovableNode(node);
            } else {
                boolean bl = isReadOnly = !ReadOnlySupport.isChildEditable(node);
            }
            if (isReadOnly) {
                isReadOnly = false;
                Node n = this.getRemovableNode(node);
                if (n != null) {
                    node = n;
                    isReadOnly = true;
                }
            }
            if (node != null && node.getNodeType() == 1 && (query.isSolidElement(node) || query.isEmptyNode(node) || isReadOnly)) {
                Node parent = node.getParentNode();
                int index = 0;
                Node n = parent.getFirstChild();
                while (n != null) {
                    if (n == node) {
                        range.setStart(parent, index);
                        range.setEnd(parent, index + 1);
                        break;
                    }
                    ++index;
                    n = n.getNextSibling();
                }
            }
        }
    }

    @Override
    protected Range doInsert(Document document, Range range, NodeFactory factory) {
        EditModelQuery query = this.getEditQuery();
        if (query == null) {
            return null;
        }
        this.prepareRange(range);
        Range normalizedRange = this.getNormalizedRange(range);
        if (normalizedRange == null) {
            return null;
        }
        boolean isNormalized = normalizedRange.getStartContainer() == range.getStartContainer() && normalizedRange.getStartOffset() == range.getStartOffset() && normalizedRange.getEndContainer() == range.getEndContainer() && normalizedRange.getEndOffset() == range.getEndOffset();
        CommandTreeManipulator manipulator = new CommandTreeManipulator(range);
        Range rangeAfterCreate = ((DocumentRange)((Object)document)).createRange();
        Element element = this.createElementWithSelectedTags(document, normalizedRange, rangeAfterCreate, isNormalized, factory);
        if (element == null) {
            return null;
        }
        Node child = element.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            manipulator.promote(child, child, element, false);
            child = next;
        }
        this.deleteRange(true);
        if (isNormalized) {
            normalizedRange.setStart(range.getStartContainer(), range.getStartOffset());
            normalizedRange.setEnd(range.getEndContainer(), range.getEndOffset());
        } else {
            normalizedRange.setStart(range.getEndContainer(), range.getEndOffset());
            normalizedRange.setEnd(range.getStartContainer(), range.getStartOffset());
        }
        Node pre = null;
        Node post = null;
        int preOffset = -1;
        Range insertRange = this.getInsertRange();
        if (insertRange == null) {
            insertRange = normalizedRange;
        }
        pre = insertRange.getStartContainer();
        post = insertRange.getEndContainer();
        preOffset = insertRange.getStartOffset();
        if (pre == null || post == null) {
            return null;
        }
        Node end = rangeAfterCreate.getEndContainer();
        Text text = null;
        if (end != null) {
            if (query.canContainText(end)) {
                text = document.createTextNode("");
                end.appendChild(text);
            } else if (query.isBr(end)) {
                Node parent = end.getParentNode();
                while (parent != null) {
                    if (query.canContainText(parent)) {
                        text = document.createTextNode("");
                        parent.appendChild(text);
                        break;
                    }
                    parent = parent.getParentNode();
                }
            }
        }
        manipulator.insertNode(element, text, pre, preOffset, true);
        String nodeName = element.getNodeName();
        if (nodeName.equalsIgnoreCase("UL") || nodeName.equalsIgnoreCase("OL") || nodeName.equalsIgnoreCase("DL") || nodeName.equalsIgnoreCase("DIR") || nodeName.equalsIgnoreCase("MENU")) {
            manipulator.normalizeList(element);
        }
        return range;
    }

    private Element createElementWithSelectedTags(Document document, Range orgRange, Range rangeAfterCreate, boolean normalized, NodeFactory factory) {
        NodeList c;
        int len;
        Node newNode = factory.createNode(document, rangeAfterCreate);
        if (newNode == null || newNode.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)newNode;
        Node target = rangeAfterCreate.getStartContainer();
        if (target == null) {
            return null;
        }
        Node pre = orgRange.getStartContainer();
        Node post = orgRange.getEndContainer();
        int preOffset = orgRange.getStartOffset();
        int postOffset = orgRange.getEndOffset();
        Node handled = null;
        Node over = null;
        Node last = post;
        if (!(post.getNodeType() != 1 && post.getNodeType() != 9 || this.getEditQuery().isSolidElement(post) || this.getEditQuery().isEmptyNode(post))) {
            last = null;
            if (postOffset == 0) {
                over = post;
            } else {
                NodeList c2 = post.getChildNodes();
                if (postOffset == c2.getLength()) {
                    Node lastParent = post;
                    over = lastParent.getNextSibling();
                    while (over == null) {
                        if ((lastParent = lastParent.getParentNode()) != null) {
                            over = lastParent.getNextSibling();
                            continue;
                        }
                        break;
                    }
                } else {
                    over = c2.item(postOffset);
                }
            }
        }
        boolean bParent = false;
        Node node = pre;
        switch (pre.getNodeType()) {
            case 3: {
                if (pre == post) {
                    handled = this.createTextNodeForSubString((Text)pre, preOffset, postOffset);
                    target.appendChild(handled);
                    this.setParentNodes(node, handled, true);
                    if (normalized) {
                        rangeAfterCreate.setStart(target, 0);
                        rangeAfterCreate.setEnd(target, target.getChildNodes().getLength());
                    } else {
                        rangeAfterCreate.setEnd(target, 0);
                        rangeAfterCreate.setStart(target, target.getChildNodes().getLength());
                    }
                    return element;
                }
                int length = ((Text)pre).getLength();
                handled = this.createTextNodeForSubString((Text)pre, preOffset, length);
                target.appendChild(handled);
                DOMTreeWaker tw = new DOMTreeWaker(node);
                node = pre;
                node = tw.toNext();
                if (node != null) {
                    bParent = false;
                    break;
                }
                node = tw.toParent();
                bParent = true;
                break;
            }
            case 1: 
            case 9: {
                DOMTreeWaker tw;
                if (this.getEditQuery().isSolidElement(pre) || this.getEditQuery().isEmptyNode(pre)) {
                    if (pre != post) break;
                    handled = pre.cloneNode(true);
                    target.appendChild(handled);
                    this.setParentNodes(pre, handled, false);
                    pre = target;
                    post = target;
                    if (normalized) {
                        rangeAfterCreate.setStart(pre, preOffset);
                        rangeAfterCreate.setEnd(post, postOffset);
                    } else {
                        rangeAfterCreate.setEnd(pre, preOffset);
                        rangeAfterCreate.setStart(post, postOffset);
                    }
                    return element;
                }
                NodeList c3 = pre.getChildNodes();
                if (preOffset == c3.getLength()) {
                    tw = new DOMTreeWaker(node);
                    node = pre;
                    node = tw.toNext();
                    if (node != null) {
                        bParent = false;
                        break;
                    }
                    node = tw.toParent();
                    bParent = true;
                    break;
                }
                node = c3.item(preOffset);
                break;
            }
            default: {
                if (pre == post) {
                    handled = pre.cloneNode(true);
                    target.appendChild(handled);
                    if (normalized) {
                        rangeAfterCreate.setStart(target, 0);
                        rangeAfterCreate.setEnd(target, target.getChildNodes().getLength());
                    } else {
                        rangeAfterCreate.setEnd(target, 0);
                        rangeAfterCreate.setStart(target, target.getChildNodes().getLength());
                    }
                    return element;
                }
                bParent = false;
            }
        }
        if (orgRange.getCollapsed()) {
            if (normalized) {
                rangeAfterCreate.setStart(target, 0);
                rangeAfterCreate.setEnd(target, target.getChildNodes().getLength());
            } else {
                rangeAfterCreate.setEnd(target, 0);
                rangeAfterCreate.setStart(target, target.getChildNodes().getLength());
            }
            return element;
        }
        Node postLeaf = null;
        while (node != null && node != last && node != over) {
            Node clone;
            Node cand = node;
            boolean bIgnoreChildren = true;
            if (node.getNodeType() == 1 && this.getEditQuery().isAncestor(node, post)) {
                if (bParent) {
                    Node parent;
                    if (node.getNodeType() != 1) break;
                    Node node2 = parent = handled != null ? handled.getParentNode() : target;
                    if (parent == null || !this.getEditQuery().canContain(parent, node)) break;
                    Element clone2 = (Element)node.cloneNode(false);
                    if (handled != null) {
                        handled = this.insertElementAsParent(clone2, handled);
                        break;
                    }
                    handled = clone2;
                    target.appendChild(handled);
                    break;
                }
                if (!(node instanceof IDOMElement) || !((IDOMElement)node).isImplicitTag()) {
                    clone = node.cloneNode(false);
                    if (handled != null) {
                        if (postLeaf != null) {
                            postLeaf.appendChild(clone);
                            postLeaf = null;
                        } else {
                            handled.getParentNode().insertBefore(clone, handled.getNextSibling());
                            this.setParentNodes(node, clone, true);
                        }
                        handled = clone;
                    } else {
                        handled = clone;
                        target.appendChild(handled);
                    }
                    postLeaf = clone;
                }
                cand = null;
                bIgnoreChildren = false;
            }
            if (!bParent && node instanceof IDOMElement && ((IDOMElement)node).isImplicitTag()) {
                cand = null;
                bIgnoreChildren = false;
            }
            if (cand != null) {
                DOMTreeWaker tw;
                if (bParent) {
                    if (!(node instanceof IDOMElement && ((IDOMElement)node).isImplicitTag() || cand.getNodeType() != 1)) {
                        clone = (Element)cand.cloneNode(false);
                        if (handled != null) {
                            handled = this.insertElementAsParent((Element)clone, handled);
                        } else {
                            handled = clone;
                            target.appendChild(handled);
                        }
                    }
                } else {
                    clone = cand.cloneNode(true);
                    if (handled != null) {
                        if (postLeaf != null) {
                            postLeaf.appendChild(clone);
                            postLeaf = null;
                        } else {
                            handled.getParentNode().insertBefore(clone, handled.getNextSibling());
                        }
                        handled = clone;
                    } else {
                        handled = clone;
                        target.appendChild(handled);
                    }
                }
                if ((node = (tw = new DOMTreeWaker(node)).toNext()) != null) {
                    bParent = false;
                    continue;
                }
                node = tw.toParent();
                bParent = true;
                continue;
            }
            node = node.hasChildNodes() ? node.getFirstChild() : this.getEditQuery().getNextNode(node, bIgnoreChildren);
            bParent = false;
        }
        if (last != null) {
            Node clone;
            boolean isText = last.getNodeType() == 3;
            Node node3 = clone = isText ? this.createTextNodeForSubString((Text)last, 0, postOffset) : last.cloneNode(false);
            if (postLeaf != null) {
                postLeaf.appendChild(clone);
            } else {
                if (handled != null) {
                    handled.getParentNode().insertBefore(clone, handled.getNextSibling());
                } else {
                    target.appendChild(clone);
                    handled = clone;
                }
                this.setParentNodes(last, handled, isText);
            }
        }
        int n = len = (c = target.getChildNodes()) != null ? c.getLength() : 0;
        if (normalized) {
            rangeAfterCreate.setStart(target, 0);
            rangeAfterCreate.setEnd(target, len);
        } else {
            rangeAfterCreate.setEnd(target, 0);
            rangeAfterCreate.setStart(target, len);
        }
        return element;
    }

    private Text createTextNodeForSubString(Text text, int start, int end) {
        Text ret;
        Document doc;
        Document document = doc = text != null ? text.getOwnerDocument() : null;
        if (doc == null) {
            return null;
        }
        String source = CommandSourceUtil.getTextSource(text, start, end);
        if (source != null && (ret = text.getOwnerDocument().createTextNode("")) != null && ret instanceof IDOMNode) {
            try {
                ((IDOMNode)ret).setSource(source);
                return ret;
            }
            catch (InvalidCharacterException invalidCharacterException) {}
        }
        String str = text.getData();
        return doc.createTextNode(str.substring(start, end));
    }

    /*
     * Unable to fully structure code
     */
    private Element insertElementAsParent(Element insert, Node sibling) {
        if (insert != null && sibling != null) ** GOTO lbl5
        return null;
        while ((prev = sibling.getPreviousSibling()) != null) {
            sibling = prev;
lbl5:
            // 2 sources

            if (sibling != null) continue;
        }
        parent = sibling.getParentNode();
        if (parent == null) {
            return null;
        }
        parent.insertBefore(insert, sibling);
        while (sibling != null) {
            next = sibling.getNextSibling();
            insert.appendChild(sibling);
            sibling = next;
        }
        return insert;
    }

    private Node setParentNodes(Node sourceNode, Node targetNode, boolean isText) {
        Node parent = sourceNode.getParentNode();
        while (parent != null && parent.getNodeType() == 1 && (parent.getNodeName().equalsIgnoreCase("A") || isText && this.getEditQuery().isTextAttribute((Element)parent))) {
            Element clone = (Element)parent.cloneNode(false);
            targetNode = this.insertElementAsParent(clone, targetNode);
            parent = parent.getParentNode();
        }
        return targetNode;
    }

    @Override
    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }
}

