/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.RangeNormalizer;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import com.ibm.etools.webedit.common.internal.commands.utils.UpdatedNodeFormatter;
import com.ibm.etools.webedit.common.utils.ReadOnlySupport;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public abstract class EditRangeCommand
extends RangeCommand {
    private EditModelQuery query = null;
    private UpdatedNodeFormatter fmd = null;

    public EditRangeCommand(String name) {
        super(name);
    }

    @Override
    protected final void afterEdit() {
        super.afterEdit();
        if (this.fmd != null) {
            Range range = this.getRange();
            this.fmd.cleanupHtml(range);
            this.fmd.deactivate();
            if (range != null) {
                this.fmd.format(range);
            }
            this.fmd.clear();
            this.fmd = null;
        }
    }

    @Override
    protected final void beforeEdit() {
        super.beforeEdit();
        if (this.fmd == null) {
            Document domdoc = this.getDocument();
            this.fmd = new UpdatedNodeFormatter(domdoc);
        }
        this.fmd.clear();
        this.fmd.activate();
    }

    @Override
    protected boolean bufferModelEvent() {
        int targetNodeNum = 1;
        NodeList nodeList = this.getNodeList();
        if (nodeList != null) {
            return nodeList.getLength() > targetNodeNum;
        }
        Range range = this.getRange();
        if (range == null || range.getCollapsed()) {
            return false;
        }
        Range r = this.getNormalizedRange(range);
        if (r == null) {
            return false;
        }
        Node pre = r.getStartContainer();
        Node post = r.getEndContainer();
        int preOffset = r.getStartOffset();
        int postOffset = r.getEndOffset();
        if (pre == null || post == null) {
            return false;
        }
        if (pre == post) {
            EditModelQuery query = this.getEditQuery();
            if (query == null) {
                return false;
            }
            if (pre.getNodeType() == 3) {
                return false;
            }
            int i = 0;
            int num = 0;
            boolean start = false;
            Node node = pre.getFirstChild();
            while (node != null) {
                if (start) {
                    if (num > targetNodeNum) {
                        return true;
                    }
                    if (i == postOffset) {
                        break;
                    }
                } else if (i == preOffset) {
                    start = true;
                }
                ++i;
                if (start && node.getNodeType() == 3 && query.isEmptyText((Text)node)) {
                    ++num;
                }
                node = node.getNextSibling();
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean canDoExecute() {
        if (this.getEditQuery() == null) {
            return false;
        }
        NodeList n = this.getNodeList();
        if (n != null) {
            return n.getLength() > 0;
        }
        Range r = this.getRange();
        return r != null && r.getStartContainer() != null && r.getEndContainer() != null;
    }

    protected final EditModelQuery getEditQuery() {
        if (this.query == null) {
            this.query = EditQueryUtil.getEditQuery(this.getDocument());
        }
        return this.query;
    }

    protected Document getDocument() {
        Range range;
        NodeList c = this.getNodeList();
        if (c != null) {
            int i = 0;
            while (i < c.getLength()) {
                Document doc;
                Node node = c.item(i);
                if (node != null && (doc = this.getDocument(node)) != null) {
                    return doc;
                }
                ++i;
            }
        }
        if ((range = this.getRange()) != null) {
            Document doc = null;
            Node start = range.getStartContainer();
            if (start != null && (doc = this.getDocument(start)) != null) {
                return doc;
            }
            Node end = range.getEndContainer();
            if (end != null && (doc = this.getDocument(end)) != null) {
                return doc;
            }
        }
        return null;
    }

    protected final Document getDocument(Node node) {
        if (node == null) {
            return null;
        }
        Document doc = node.getOwnerDocument();
        if (doc == null && node instanceof Document) {
            return (Document)node;
        }
        return doc;
    }

    protected final Range getNormalizedRange(Range range) {
        if (range == null || range.getStartContainer() == null || range.getEndContainer() == null) {
            return null;
        }
        Range newRange = range.cloneRange();
        RangeNormalizer normalizer = new RangeNormalizer(range);
        if (!normalizer.isRangeNormalized()) {
            Node node = range.getStartContainer();
            int offset = range.getStartOffset();
            newRange.setStart(range.getEndContainer(), range.getEndOffset());
            newRange.setEnd(node, offset);
        }
        return newRange;
    }

    protected final void deleteRange() {
        this.deleteRange(true);
    }

    protected final void deleteRange(boolean remove_solid_on_caret) {
        this.internalDeleteRange(remove_solid_on_caret);
        Range range = this.getRange();
        if (range == null) {
            return;
        }
        if (this.unboundImplicitTags(range)) {
            this.unboundImplicitTags(range);
        }
        this.setRange(range);
    }

    private boolean unboundImplicitTags(Range range) {
        if (range == null) {
            return false;
        }
        Node start = range.getStartContainer();
        if (start != null && start.getNodeType() == 3 && this.getEditQuery().isEmptyText((Text)start)) {
            start = start.getParentNode();
        }
        if (start != null && start.getNodeType() == 1 && this.isEmptyChildren(start.getChildNodes()) && ((IDOMElement)start).isImplicitTag()) {
            RemoveTag rTag = new RemoveTag(range, true);
            rTag.removeNode(start, true);
            return true;
        }
        if (!range.getCollapsed()) {
            Node end = range.getEndContainer();
            if (end != null && end.getNodeType() == 3 && this.getEditQuery().isEmptyText((Text)end)) {
                end = end.getParentNode();
            }
            if (end != null && end.getNodeType() == 1 && this.isEmptyChildren(end.getChildNodes()) && ((IDOMElement)end).isImplicitTag()) {
                RemoveTag rTag = new RemoveTag(range, true);
                rTag.removeNode(end, true);
                return true;
            }
        }
        return false;
    }

    private boolean isEmptyChildren(NodeList list) {
        int i = 0;
        while (list != null && i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() != 3 || !this.getEditQuery().isEmptyText((Text)node)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final void internalDeleteRange(boolean remove_solid_on_caret) {
        range = this.getRange();
        if (range == null) {
            return;
        }
        query = this.getEditQuery();
        if (query == null) {
            return;
        }
        pre = null;
        post = null;
        preOffset = -1;
        postOffset = -1;
        normalizer = new RangeNormalizer(range);
        normalized = normalizer.isRangeNormalized();
        if (normalized) {
            pre = range.getStartContainer();
            post = range.getEndContainer();
            preOffset = range.getStartOffset();
            postOffset = range.getEndOffset();
        } else {
            post = range.getStartContainer();
            pre = range.getEndContainer();
            postOffset = range.getStartOffset();
            preOffset = range.getEndOffset();
        }
        if (pre == null || post == null) {
            return;
        }
        rc = false;
        if (range.getCollapsed()) {
            if (remove_solid_on_caret && pre.getNodeType() != 3) {
                parent = pre.getParentNode();
                if (query.isSolidElement(pre) || query.isEmptyNode(pre)) {
                    rt = new RemoveTag(range, true);
                    rt.removeNode(pre, true);
                    rc = true;
                }
                if (parent != null && parent.getNodeType() == 1 && query.isEmptyBlock((Element)parent) && parent.getNodeName().equalsIgnoreCase("P")) {
                    rt = new RemoveTag(range, true);
                    rt.removeNode(parent, true);
                    rc = true;
                }
            }
            if (rc) {
                this.setRange(range);
            }
            return;
        }
        end = null;
        last = post;
        block0 : switch (post.getNodeType()) {
            case 1: 
            case 9: {
                if (query.isSolidElement(post)) break;
                last = null;
                if (postOffset == 0) {
                    end = post;
                    break;
                }
                c = post.getChildNodes();
                if (postOffset == c.getLength()) {
                    lastParent = post;
                    end = lastParent.getNextSibling();
                    while (end == null) {
                        if ((lastParent = lastParent.getParentNode()) == null) break block0;
                        end = lastParent.getNextSibling();
                    }
                    break;
                }
                end = c.item(postOffset);
            }
        }
        node = pre;
        switch (pre.getNodeType()) {
            case 3: {
                if (pre == post) {
                    ((Text)post).deleteData(preOffset, postOffset - preOffset);
                    if (normalized) {
                        range.setEnd(pre, preOffset);
                    } else {
                        range.setStart(pre, preOffset);
                    }
                    this.setRange(range);
                    return;
                }
                length = ((Text)pre).getLength() - preOffset;
                ((Text)pre).deleteData(preOffset, length);
                if (normalized) {
                    range.setStart(pre, preOffset);
                } else {
                    range.setEnd(pre, preOffset);
                }
                node = query.getNextNode(pre, true);
                rc = true;
                ** GOTO lbl156
            }
            case 1: 
            case 9: {
                if (this.getEditQuery().isSolidElement(pre)) {
                    if (pre == post) {
                        if (!query.isViewable(pre) && !query.canRemoveByDelkey(pre, true)) {
                            return;
                        }
                        offset = -1;
                        parent = pre.getParentNode();
                        c = parent.getChildNodes();
                        i = 0;
                        while (i < c.getLength()) {
                            if (c.item(i).equals(pre)) {
                                offset = i;
                            }
                            ++i;
                        }
                        if (offset > 0) {
                            range.setStart(parent, offset);
                            range.collapse(true);
                        }
                        if (pre.getParentNode() != null) {
                            rtag = new RemoveTag(range, true);
                            pre = rtag.remove((Element)pre);
                            rc = true;
                        }
                        this.setRange(range);
                        return;
                    }
                } else {
                    c = pre.getChildNodes();
                    node = preOffset == c.getLength() ? query.getNextNode(pre, true) : c.item(preOffset);
                }
                ** GOTO lbl156
            }
            default: {
                if (pre != post) ** GOTO lbl156
                offset = -1;
                parent = pre.getParentNode();
                c = parent.getChildNodes();
                i = 0;
                while (i < c.getLength()) {
                    if (c.item(i).equals(pre)) {
                        offset = i;
                    }
                    ++i;
                }
                if (offset > 0) {
                    range.setStart(parent, offset);
                    range.collapse(true);
                }
                if (pre.getParentNode() != null) {
                    rtag = new RemoveTag(range, true);
                    pre = rtag.removeNode(pre);
                    rc = true;
                }
                this.setRange(range);
                return;
            }
        }
lbl-1000:
        // 1 sources

        {
            cand = node;
            bIgnoreChildren = true;
            switch (node.getNodeType()) {
                case 1: {
                    elm = (Element)node;
                    if (query.isSolidElement(elm)) {
                        bIgnoreChildren = true;
                        if (query.isViewable(elm) || query.canRemoveByDelkey(elm, true)) break;
                        cand = null;
                        break;
                    }
                    if (query.isAncestor(node, post)) {
                        cand = null;
                        bIgnoreChildren = false;
                        break;
                    }
                    if (node.getNodeName().equalsIgnoreCase("TD") || node.getNodeName().equalsIgnoreCase("TH") || node.getNodeName().equalsIgnoreCase("TR")) {
                        cand = null;
                        bIgnoreChildren = false;
                        break;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("THEAD") && !node.getNodeName().equalsIgnoreCase("TFOOT") && !node.getNodeName().equalsIgnoreCase("TBODY")) break;
                    cand = null;
                    bIgnoreChildren = false;
                    break;
                }
            }
            node = query.getNextNode(node, bIgnoreChildren, true);
            if (cand != null && cand.getParentNode() != null) {
                rtag = new RemoveTag(range, true);
                cand = rtag.removeNode(cand);
                rc = true;
            }
            if (node == null || end != null && RangeNormalizer.isRangeNormalized(end, node) || last != null && RangeNormalizer.isRangeNormalized(last, node)) break;
lbl156:
            // 5 sources

            ** while (node != null && node != last && node != end)
        }
lbl157:
        // 2 sources

        if (last != null) {
            switch (last.getNodeType()) {
                case 3: {
                    ((Text)last).deleteData(0, postOffset);
                    if (normalized) {
                        range.setEnd(post, 0);
                    } else {
                        range.setStart(post, 0);
                    }
                    rc = true;
                    break;
                }
                case 1: {
                    if (query.isSolidElement(last) && !query.canRemoveByDelkey(last, true)) break;
                }
                default: {
                    if (last.getParentNode() == null) break;
                    rtag = new RemoveTag(range, true);
                    last = rtag.removeNode(last);
                    rc = true;
                }
            }
        }
        if (rc) {
            normalizer.fixRange();
            this.setRange(range);
        }
    }

    protected final void deleteNodeList() {
        NodeList c = this.getNodeList();
        if (c == null) {
            return;
        }
        EditModelQuery query = this.getEditQuery();
        if (query == null) {
            return;
        }
        MyNodeList nodeList = null;
        Node cursor = null;
        int offset = 0;
        int i = 0;
        while (i < c.getLength()) {
            Node node = c.item(i);
            if (node != null) {
                if (query.isEmptyNode(node) || query.isSolidElement(node)) {
                    cursor = node.getParentNode();
                    offset = query.getChildIndex(node);
                    cursor.removeChild(node);
                } else {
                    if (nodeList == null) {
                        nodeList = new MyNodeList();
                    }
                    nodeList.appendNode(node);
                    if (node.hasChildNodes()) {
                        Node child = node.getFirstChild();
                        while (child != null) {
                            Node next = child.getNextSibling();
                            node.removeChild(child);
                            child = next;
                        }
                    }
                }
            }
            ++i;
        }
        this.setNodeList((NodeList)((Object)nodeList));
        if (nodeList == null && cursor != null) {
            Range newRange;
            Document doc = this.getDocument(cursor);
            Range range = newRange = doc != null ? ((DocumentRange)((Object)doc)).createRange() : null;
            if (newRange != null) {
                newRange.setStart(cursor, offset);
                newRange.collapse(true);
                if (this.unboundImplicitTags(newRange)) {
                    this.unboundImplicitTags(newRange);
                }
                this.setRange(newRange);
            }
        }
    }

    protected final Node getRemovableNode(Node node) {
        EditModelQuery query = this.getEditQuery();
        if (query == null) {
            return null;
        }
        Node n = node;
        while (n != null) {
            if (query.isRenderRoot(n)) {
                return null;
            }
            if (ReadOnlySupport.isRemovableNode(n)) break;
            n = n.getParentNode();
        }
        return n;
    }

    private class MyNodeList
    extends NodeListImpl {
        private MyNodeList() {
        }

        protected Node appendNode(Node node) {
            return super.appendNode(node);
        }
    }

    protected class RangeKeeper {
        private Node startNode;
        private Node endNode;
        private final Range range;

        public RangeKeeper(Range range, boolean store) {
            this.range = range;
            if (store) {
                this.storeRange();
            }
        }

        public void storeRange() {
            if (this.range != null) {
                this.startNode = this.getEdgeNode(this.range.getStartContainer(), this.range.getStartOffset());
                this.endNode = this.getEdgeNode(this.range.getEndContainer(), this.range.getEndOffset());
            }
        }

        public final void restoreRange() {
            int offset = this.getChildIndex(this.range.getStartContainer(), this.startNode);
            if (offset >= 0) {
                this.range.setStart(this.startNode != null ? this.startNode.getParentNode() : this.range.getStartContainer(), offset);
            }
            if ((offset = this.getChildIndex(this.range.getEndContainer(), this.endNode)) >= 0) {
                this.range.setEnd(this.endNode != null ? this.endNode.getParentNode() : this.range.getEndContainer(), offset);
            }
            this.endNode = null;
            this.startNode = null;
        }

        public Range getRange() {
            return this.range;
        }

        private Node getEdgeNode(Node container, int offset) {
            if (container == null) {
                return null;
            }
            NodeList nl = container.getChildNodes();
            return offset >= 0 && offset < nl.getLength() ? nl.item(offset) : null;
        }

        private int getChildIndex(Node container, Node child) {
            if (container == null || container.getNodeType() == 3) {
                return -1;
            }
            if (child == null) {
                return container.getChildNodes().getLength();
            }
            Node node = container.getFirstChild();
            int i = 0;
            while (node != null) {
                if (node.equals(child)) {
                    return i;
                }
                ++i;
                node = node.getNextSibling();
            }
            return this.getChildIndex(child.getParentNode(), child);
        }
    }
}

