/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class CompoundHTMLCommand
extends HTMLCommand {
    protected List commandList;
    private int LAST_COMMAND_ALL = Integer.MIN_VALUE;
    private int MERGE_COMMAND_ALL;
    protected int resultIndex = this.MERGE_COMMAND_ALL = Integer.MAX_VALUE;

    public CompoundHTMLCommand(String name) {
        super(name);
        this.commandList = new ArrayList();
    }

    public CompoundHTMLCommand(String name, List commands) {
        super(name);
        this.commandList = commands;
    }

    public CompoundHTMLCommand(int resultIndex) {
        super(null);
        this.commandList = new ArrayList();
        this.resultIndex = resultIndex;
    }

    public CompoundHTMLCommand(int resultIndex, List commands) {
        super(null);
        this.commandList = commands;
        this.resultIndex = resultIndex;
    }

    public void append(HTMLCommand command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public boolean appendIfCanExecute(HTMLCommand command) {
        if (command == null) {
            return false;
        }
        command.setCommandTarget(this.getCommandTarget());
        if (command.canExecute()) {
            this.commandList.add(command);
            return true;
        }
        command.dispose();
        return false;
    }

    @Override
    protected boolean bufferModelEvent() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            if (!command.bufferModelEvent()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canDoExecute() {
        ArrayList<HTMLCommand> list = new ArrayList<HTMLCommand>();
        boolean executable = true;
        HTMLCommand lastCmd = null;
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            command.setCommandTarget(this.getCommandTarget());
            if (lastCmd != null) {
                command.updateState(lastCmd);
                list.add(command);
            }
            if (!(executable = command.canDoExecute())) break;
            lastCmd = command;
        }
        int i = 0;
        while (i < list.size()) {
            ((HTMLCommand)((Object)list.get(i))).updateState(null);
            ++i;
        }
        return executable;
    }

    @Override
    protected HTMLCommand.Condition preCondition() {
        HTMLCommand.Condition lastState = DELEGATE_DECISION;
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            command.setCommandTarget(this.getCommandTarget());
            HTMLCommand.Condition current = command.preCondition();
            if (current == ALWAYS_FALSE) {
                return ALWAYS_FALSE;
            }
            if (current != ALWAYS_TRUE) continue;
            lastState = ALWAYS_TRUE;
        }
        return lastState;
    }

    @Override
    protected void cleanup(boolean enforceUpdate) {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            command.cleanup(enforceUpdate);
        }
    }

    public void dispose() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            command.dispose();
        }
    }

    @Override
    protected void doExecute() {
        HTMLCommand lastCmd = null;
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            command.setCommandTarget(this.getCommandTarget());
            if (lastCmd != null) {
                command.updateState(lastCmd);
            }
            if (this.getModel() == command.getModel()) {
                command.preExecute();
                command.doExecute();
                command.postExecute();
            } else {
                command.execute();
            }
            lastCmd = command;
        }
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label != null) {
            return label;
        }
        if (this.commandList.isEmpty()) {
            return super.getLabel();
        }
        if (this.resultIndex == this.LAST_COMMAND_ALL || this.resultIndex == this.MERGE_COMMAND_ALL) {
            return ((HTMLCommand)((Object)this.commandList.get(this.commandList.size() - 1))).getLabel();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((HTMLCommand)((Object)this.commandList.get(this.resultIndex))).getLabel();
        }
        return super.getLabel();
    }

    public int getSize() {
        return this.commandList.size();
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    @Override
    public boolean toBeRecorded() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            HTMLCommand command = (HTMLCommand)((Object)commands.next());
            if (!command.toBeRecorded()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (commandList: #" + this.commandList.size() + ")");
        result.append(" (resultIndex: " + this.resultIndex + ")");
        return result.toString();
    }

    public List getCommandList() {
        return this.commandList;
    }

    @Override
    protected final int getSelectionStartOffset() {
        if (this.getSelectionMediator() == null) {
            return super.getSelectionStartOffset();
        }
        Range range = this.getSelectionMediator().getRange();
        if (range != null) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)range.getStartContainer(), range.getStartOffset());
        }
        NodeList nodeList = this.getSelectionMediator().getNodeList();
        if (nodeList != null && nodeList.getLength() > 0) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)nodeList.item(nodeList.getLength() - 1), 0);
        }
        return 0;
    }

    @Override
    protected final int getSelectionEndOffset() {
        if (this.getSelectionMediator() == null) {
            return super.getSelectionEndOffset();
        }
        Range range = this.getSelectionMediator().getRange();
        if (range != null) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)range.getEndContainer(), range.getEndOffset());
        }
        NodeList nodeList = this.getSelectionMediator().getNodeList();
        if (nodeList != null && nodeList.getLength() > 0) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)nodeList.item(nodeList.getLength() - 1), 0);
        }
        return 0;
    }

    protected final HTMLSelectionMediator getSelectionMediator() {
        HTMLCommandTarget target = this.getCommandTarget();
        if (target != null) {
            return target.getSelectionMediator();
        }
        return null;
    }
}

