/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.commands.adapters.AttributeAdapter;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributesCommand
extends RangeCommand {
    private NodeList targetNodeList = null;
    private List adapters = null;

    public AttributesCommand(String name) {
        super(name);
    }

    public void setTargetElement(Element element) {
        this.targetNodeList = SelectionUtil.extractNodeList(null, null, null, element, false);
    }

    public void setTargetNodeList(NodeList targetNodeList) {
        this.targetNodeList = targetNodeList;
    }

    public void addAttributeChangeAdapter(AttributeAdapter adapter) {
        if (this.adapters == null) {
            this.adapters = new ArrayList(1);
        }
        this.adapters.add(adapter);
    }

    public void removeAttributeChangeAdapter(AttributeAdapter adapter) {
        if (this.adapters != null && this.adapters.contains(adapter)) {
            this.adapters.remove(adapter);
        }
    }

    private NodeList getTargetNodeList() {
        if (this.targetNodeList == null) {
            this.targetNodeList = SelectionUtil.extractNodeList(this.getNodeList(), this.getNodeListData(), this.getRange(), this.getFocusedNode(), true);
        }
        return this.targetNodeList;
    }

    @Override
    protected boolean canDoExecute() {
        NodeList nodeList = this.getTargetNodeList();
        if (nodeList == null) {
            return false;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Iterator itr;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && (itr = this.adapters.iterator()) != null) {
                while (itr.hasNext()) {
                    AttributeAdapter adapter = (AttributeAdapter)itr.next();
                    if (!adapter.canUpdateAttribute((Element)node)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void doExecute() {
        NodeList nodeList = this.getTargetNodeList();
        if (nodeList == null) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Iterator itr;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && (itr = this.adapters.iterator()) != null) {
                while (itr.hasNext()) {
                    AttributeAdapter adapter = (AttributeAdapter)itr.next();
                    if (!adapter.canUpdateAttribute((Element)node)) continue;
                    adapter.updateAttribute((Element)node);
                }
            }
            ++i;
        }
    }
}

