/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.validator.ValueValidator;
import com.ibm.etools.webedit.common.utils.CollectionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TabIndexValidator
extends ValueValidator {
    private static final String INVALID_TABINDEX_MSG = ResourceHandler._UI_TIV_0;
    private static final String USED_TABINDEX_MSG = ResourceHandler._UI_TIV_1;
    private Node node;

    public TabIndexValidator(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super(attrName, tagNames, document, nodeList, value);
    }

    public TabIndexValidator() {
    }

    @Override
    public String getErrorMessage() {
        if (!this.validateJSPValue(this.value)) {
            if (!TabIndexValidator.isValidTabIndex(this.value)) {
                return INVALID_TABINDEX_MSG;
            }
            if (!TabIndexValidator.isUniqueTabIndex(this.value, this.node)) {
                return USED_TABINDEX_MSG;
            }
        }
        return null;
    }

    @Override
    public int getErrorLevel() {
        int level = super.getErrorLevel();
        if (level == 0 && !TabIndexValidator.isUniqueTabIndex(this.value, this.node)) {
            level = 2;
        }
        return level;
    }

    public static boolean isUsedTabIndex(String value, Node node) {
        return TabIndexValidator.isUniqueTabIndex(value, node);
    }

    public static boolean isUniqueTabIndex(String value, Node node) {
        if (value == null || value.equals("0")) {
            return true;
        }
        String[] tabIndexes = CollectionUtil.collectTabIndexes(node);
        if (tabIndexes != null) {
            int i = 0;
            while (i < tabIndexes.length) {
                if (value.compareTo(tabIndexes[i]) == 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isValidTabIndex(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() > 0) {
            String validString = new String("0123456789");
            int j = 0;
            while (j < value.length()) {
                if (validString.indexOf(value.substring(j, j + 1)) == -1) {
                    return false;
                }
                ++j;
            }
        }
        if (value.length() < 5) {
            return true;
        }
        if (value.length() > 5) {
            return false;
        }
        return value.compareTo("32767") <= 0;
    }

    @Override
    protected boolean isValueOK() {
        return TabIndexValidator.isValidTabIndex(this.value);
    }

    public void setTabIndexNode(Node node) {
        this.node = node;
    }
}

