/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.validator.HTMLValidator;
import com.ibm.etools.webedit.common.attrview.validator.ValidationUtil;
import java.text.MessageFormat;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class NodeValidator
extends HTMLValidator {
    private static final String ERR_TAG = ResourceHandler._UI_NDVal_0;
    private static final String ERR_TAG_EMPTY = ResourceHandler._UI_NDVal_1;

    public NodeValidator(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super(attrName, tagNames, document, nodeList, value);
    }

    public NodeValidator() {
    }

    public String getErrorMessage() {
        if (!this.isTagOK()) {
            if (this.tagNames != null && this.tagNames[0] != null) {
                return MessageFormat.format(ERR_TAG, this.tagNames[0]);
            }
            return ERR_TAG_EMPTY;
        }
        return null;
    }

    public int getErrorLevel() {
        if (!this.isTagOK()) {
            return ValidationUtil.getUnknownTagSetting();
        }
        return 0;
    }

    protected final boolean isTagOK() {
        if (this.tagNames != null) {
            int i = 0;
            while (i < this.tagNames.length) {
                if (ValidationUtil.isKnownTag(this.document, this.tagNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isValueAllowed() {
        return this.isTagOK();
    }
}

