/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.validator.HTMLValidator;
import com.ibm.etools.webedit.common.attrview.validator.ValidationUtil;
import java.text.MessageFormat;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class AttributeValidator
extends HTMLValidator {
    private static final String ERR_ATTR = ResourceHandler._UI_AVVal_0;
    private static final String ERR_ATTR_EMPTY = ResourceHandler._UI_AVVal_1;

    public AttributeValidator(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super(attrName, tagNames, document, nodeList, value);
    }

    public AttributeValidator() {
    }

    public String getErrorMessage() {
        if (!this.isAttributeOK()) {
            if (this.attrName != null) {
                return MessageFormat.format(ERR_ATTR, this.attrName);
            }
            return ERR_ATTR_EMPTY;
        }
        return null;
    }

    public int getErrorLevel() {
        if (!this.isAttributeOK()) {
            return ValidationUtil.getUnknownAttributeSetting();
        }
        return 0;
    }

    protected boolean isAttributeOK() {
        if (this.value == null) {
            return true;
        }
        if (this.tagNames != null && this.attrName != null) {
            int i = 0;
            while (i < this.tagNames.length) {
                if (ValidationUtil.isKnownAttribute(this.document, this.tagNames[i], this.attrName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public boolean isValueAllowed() {
        return this.isAttributeOK();
    }
}

