/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.picker;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.webedit.common.attrview.HTMLNodeList;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DefaultNodeListPicker
extends NodeListPicker {
    private String[] tagNames;

    public DefaultNodeListPicker(String[] tagNames) {
        this.tagNames = tagNames;
    }

    private boolean isTarget(Node node) {
        if (node != null && this.tagNames != null) {
            String name = node.getNodeName();
            int i = 0;
            while (i < this.tagNames.length) {
                if (StringUtil.compareIgnoreCase((String)name, (String)this.tagNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public NodeList pickup(Node node) {
        while (node != null) {
            if (node.getNodeType() == 1 || node.getNodeType() == 8) {
                if (!this.isTarget(node)) break;
                return new HTMLNodeList(node);
            }
            node = node.getParentNode();
        }
        return null;
    }
}

