/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.folders;

import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.sdk.AVFolder;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.webedit.common.attrview.HTMLFolderDescriptor;
import com.ibm.etools.webedit.common.attrview.HTMLPageDescriptor;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.internal.attrview.StylePageManager;
import com.ibm.etools.webedit.common.internal.attrview.StyleSelector;
import java.util.ArrayList;

public abstract class HTMLFolder
extends AVFolder {
    private ArrayList pages = new ArrayList();
    private HTMLFolderDescriptor folderDescriptor;
    private HTMLPageDescriptor pageDescriptor;
    private AVEditorContextProvider editorContext;
    private HTMLPage stylePage;
    private StyleSelector styleSelector;

    private void addPage(HTMLPage page) {
        if (page != null && this.pages != null) {
            this.pages.add(page);
        }
    }

    protected boolean canUseStylePage() {
        return false;
    }

    public void createContents() {
        super.createContents();
    }

    protected abstract HTMLPage createPage(HTMLPageDescriptor var1);

    public void dispose() {
        if (this.pages != null) {
            int size = this.pages.size();
            int i = 0;
            while (i < size) {
                AVPage page = (AVPage)this.pages.get(i);
                page.dispose();
                ++i;
            }
            this.pages.clear();
        }
        this.editorContext = null;
        if (this.styleSelector != null) {
            this.styleSelector.dispose();
            this.styleSelector = null;
        }
        super.dispose();
    }

    public AVEditorContextProvider getEditorContext() {
        return this.editorContext;
    }

    public HTMLFolderDescriptor getFolderDescriptor() {
        return this.folderDescriptor;
    }

    public HTMLPageDescriptor getPageDescriptor() {
        return this.pageDescriptor;
    }

    protected AVPage[] getPages() {
        if ((this.pages == null || this.pages.size() <= 0) && this.folderDescriptor != null) {
            HTMLPage sPage;
            HTMLPageDescriptor[] pagesDesc = this.folderDescriptor.getPages();
            if (pagesDesc != null) {
                int i = 0;
                while (i < pagesDesc.length) {
                    HTMLPage page = this.createPage(pagesDesc[i]);
                    if (page != null) {
                        page.setFolder(this);
                        page.setPageDescriptor(pagesDesc[i]);
                        page.setEditorContext(this.editorContext);
                        this.addPage(page);
                    }
                    ++i;
                }
            }
            if ((sPage = this.getStylePage()) != null) {
                sPage.setFolder(this);
                sPage.setEditorContext(this.editorContext);
                this.addPage(sPage);
            }
        }
        if (this.pages != null && this.pages.size() > 0) {
            return this.pages.toArray(new AVPage[this.pages.size()]);
        }
        return null;
    }

    public void selectTab(int tab) {
        AVPage page;
        if (this.pages != null && tab >= 0 && tab < this.pages.size() && (page = (AVPage)this.pages.get(tab)) != null && page instanceof HTMLPage) {
            this.setPageDescriptor(((HTMLPage)page).getPageDescriptor());
        }
        super.selectTab(tab);
    }

    public void setEditorContext(AVEditorContextProvider editorContext) {
        this.editorContext = editorContext;
    }

    public void setFolderDescriptor(HTMLFolderDescriptor folderDescriptor) {
        this.folderDescriptor = folderDescriptor;
    }

    public void setPageDescriptor(HTMLPageDescriptor pageDescriptor) {
        this.pageDescriptor = pageDescriptor;
    }

    public void updateData(AVEditorContextProvider provider) {
        this.setEditorContext(provider);
        if (this.pages != null) {
            int size = this.pages.size();
            int i = 0;
            while (i < size) {
                AVPage page = (AVPage)this.pages.get(i);
                if (page != null) {
                    page.updateData(provider);
                    if (page instanceof HTMLPage && this.pageDescriptor != null && this.pageDescriptor == ((HTMLPage)page).getPageDescriptor()) {
                        this.selectPage(page);
                    }
                }
                ++i;
            }
        }
    }

    public String getHelpId() {
        if (this.pageDescriptor != null) {
            return this.pageDescriptor.getHelpId();
        }
        return super.getHelpId();
    }

    public HTMLPage getStylePage() {
        if (this.canUseStylePage() && this.stylePage == null && this.editorContext instanceof StylePageManager) {
            this.stylePage = ((StylePageManager)this.editorContext).getStylePageFactory().createStylePage();
        }
        return this.stylePage;
    }

    public StyleSelector getStyleSelector() {
        if (this.styleSelector == null && this.editorContext instanceof StylePageManager) {
            this.styleSelector = ((StylePageManager)this.editorContext).getStyleSelectorFactory().createStyleSelector();
        }
        return this.styleSelector;
    }

    public final void setPageName(int i, String name) {
        if (this.pages != null) {
            AVPage page;
            int size = this.pages.size();
            if (i >= 0 && i < size && (page = (AVPage)this.pages.get(i)) != null) {
                page.setName(name);
            }
        }
    }
}

