/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.webedit.common.attrview.HTMLNodeList;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TextData
extends AttributeData
implements AVStringComponent {
    public TextData(AVPage page, String[] tagNames) {
        super(page, tagNames, null, false);
    }

    protected static boolean isEditable(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected static NodeList getTextNodeList(Node node) {
        HTMLNodeList textNodes = new HTMLNodeList();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    textNodes.add(child);
                }
                ++i;
            }
        }
        return textNodes.getLength() > 0 ? textNodes : null;
    }

    protected static String getTextValue(NodeList nodeList) {
        String value = null;
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeValue;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 3 && (nodeValue = NodeDataAccessor.getTextData((Text)node)) != null) {
                    if (value == null) {
                        value = new String(nodeValue);
                    } else {
                        value.concat(nodeValue);
                    }
                }
                ++i;
            }
        }
        return value;
    }

    @Override
    protected void update(AVSelection selection) {
        NodeList target;
        NodeListPicker picker;
        if (selection != null && selection instanceof NodeSelection && this.page != null && this.page instanceof HTMLPage && (picker = ((HTMLPage)this.page).getNodeListPicker(this)) != null && (target = picker.pickup((NodeSelection)selection)) != null) {
            this.setTargetNodeList(target);
            int len = target.getLength();
            int i = 0;
            while (i < len) {
                Node node = target.item(i);
                if (!TextData.isEditable(node)) {
                    this.setEditable(false);
                }
                NodeList textNodes = TextData.getTextNodeList(node);
                if (i == 0) {
                    if (textNodes != null) {
                        this.setValue(TextData.getTextValue(textNodes));
                        this.setValueSpecified(true);
                        this.setValueUnique(true);
                    }
                } else {
                    if (textNodes != null) {
                        this.setValueUnique(StringUtil.compare((String)this.getValue(), (String)TextData.getTextValue(textNodes)));
                    } else {
                        this.setValueUnique(!this.isValueSpecified());
                    }
                    if (!this.isValueUnique()) break;
                }
                ++i;
            }
        }
    }
}

