/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVTableComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;

public abstract class TableData
extends AttributeData
implements AVTableComponent {
    private Object[] activeItems;
    private int[] selectedColumn;
    private int[] selectedRow;

    public TableData(AVPage page, String[] tagNames, String attrName, Object[] items) {
        super(page, tagNames, attrName);
        this.activeItems = items;
    }

    public int getColumnCount() {
        Object[] items = this.getItems();
        int columnCount = 0;
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i] != null && items[i] instanceof AVValueItem[]) {
                    AVValueItem[] valueItems = (AVValueItem[])items[i];
                    columnCount = columnCount < valueItems.length ? valueItems.length : columnCount;
                }
                ++i;
            }
        }
        return columnCount;
    }

    public AVValueItem[] getColumnItems(int column) {
        if (column < 0 || this.getColumnCount() <= column) {
            return null;
        }
        Object[] items = this.getItems();
        if (items != null) {
            AVValueItem[] retItems = new AVValueItem[items.length];
            int i = 0;
            while (i < items.length) {
                AVValueItem[] valueItems;
                if (items[i] != null && items[i] instanceof AVValueItem[] && column < (valueItems = (AVValueItem[])items[i]).length) {
                    retItems[i] = valueItems[column];
                }
                ++i;
            }
            return retItems;
        }
        return null;
    }

    public int[] getColumnSelectionIndex() {
        return this.selectedColumn;
    }

    public int getItemCount() {
        Object[] values = this.getItems();
        if (values != null) {
            return values.length;
        }
        return 0;
    }

    public Object[] getItems() {
        if (this.activeItems != null) {
            return this.activeItems;
        }
        return null;
    }

    public int getRowCount() {
        Object[] items = this.getItems();
        if (items != null) {
            return items.length;
        }
        return 0;
    }

    public AVValueItem[] getRowItems(int row) {
        Object[] items = this.getItems();
        if (items != null && row >= 0 && row < items.length && items[row] != null && items[row] instanceof AVValueItem[]) {
            return (AVValueItem[])items[row];
        }
        return null;
    }

    public int[] getRowSelectionIndex() {
        return this.selectedRow;
    }

    public void setColumnSelectionIndex(int[] indices) {
        this.selectedColumn = indices;
    }

    public void setItems(Object[] items) {
        this.activeItems = items;
    }

    public void setRowSelectionIndex(int[] indices) {
        this.selectedRow = indices;
    }

    @Override
    protected void update(AVSelection selection) {
    }
}

