/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.AVEditorWatcher;
import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStatusReporter;
import com.ibm.etools.attrview.sdk.AVValueTester;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.NodeWatcher;
import com.ibm.etools.webedit.common.attrview.data.AttributeValue;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.attrview.validator.HTMLValidator;
import com.ibm.etools.webedit.common.attrview.validator.HTMLValidatorCollector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class AttributeData
extends AVData {
    private String attrName;
    private String[] tagNames;
    private NodeList targetNodeList;

    public AttributeData(AVPage page, String[] tagNames, String attrName) {
        this(page, tagNames, attrName, true);
    }

    public AttributeData(AVPage page, String[] tagNames, String attrName, boolean ignoreCase) {
        super(page);
        this.tagNames = tagNames;
        this.attrName = attrName;
        this.setValidator(new HTMLValidatorCollector());
        this.setIgnoreCase(ignoreCase);
    }

    public void addValidator(HTMLValidator addValidator) {
        if (this.validator != null && this.validator instanceof HTMLValidatorCollector) {
            ((HTMLValidatorCollector)this.validator).add(addValidator);
        }
    }

    public void addValidatorFirst(HTMLValidator addValidator) {
        if (this.validator != null && this.validator instanceof HTMLValidatorCollector) {
            ((HTMLValidatorCollector)this.validator).add(0, addValidator);
        }
    }

    public void fireValueChange(AVPart part) {
        if (!(part == null || this.isValueUnique() && this.compareValue(part))) {
            this.initValidator(part.getValue());
            if (this.validator.isValueAllowed()) {
                this.setValue(part);
                this.page.fireValueChange((AVData)this);
            }
        }
    }

    public String getAttributeName() {
        return this.attrName;
    }

    public Document getDocument() {
        AVSelection selection = this.getSelection();
        if (selection != null && selection instanceof NodeSelection) {
            return ((NodeSelection)selection).getDocument();
        }
        return null;
    }

    public String[] getTagNames() {
        return this.tagNames;
    }

    protected NodeList getTargetNodeList() {
        return this.targetNodeList;
    }

    protected void initValidator(String value) {
        AVSelection selection = this.getSelection();
        if (selection != null && selection instanceof NodeSelection) {
            NodeSelection domSelection = (NodeSelection)selection;
            if (this.validator != null && this.validator instanceof HTMLValidator) {
                ((HTMLValidator)this.validator).setValue(this.getAttributeName(), this.getTagNames(), domSelection.getDocument(), this.getTargetNodeList(), value);
            }
        }
    }

    public void removeValidator(Class klass) {
        if (this.validator != null && this.validator instanceof HTMLValidatorCollector) {
            ((HTMLValidatorCollector)this.validator).remove(klass);
        }
    }

    public void reportStatus(String value) {
        AVStatusReporter reporter = this.page.getStatusReporter();
        if (reporter != null) {
            this.initValidator(value);
            reporter.report(this.validator);
        }
    }

    public void setAttributeName(String attrName) {
        this.attrName = attrName;
    }

    public void setTagNames(String[] tagNames) {
        this.tagNames = tagNames;
    }

    protected final void setTargetNodeList(NodeList nodeList) {
        this.targetNodeList = nodeList;
        AVEditorWatcher watcher = this.page.getEditorContext().getEditorWatcher();
        if (watcher instanceof NodeWatcher) {
            ((NodeWatcher)watcher).watch(nodeList);
        }
    }

    protected void update(AVSelection selection) {
        if (selection != null && selection instanceof NodeSelection && this.page != null && this.page instanceof HTMLPage) {
            AttributeValue value = new AttributeValue((NodeSelection)selection, this.getAttributeName(), ((HTMLPage)this.page).getNodeListPicker(this), new AVValueTester(){

                public boolean test(String value, String value2) {
                    return AttributeData.this.compareValue(value, value2);
                }
            });
            this.setTargetNodeList(value.getTargetNodeList());
            this.setValue(value.getValue());
            this.setValueSpecified(value.isSpecified());
            this.setValueUnique(value.isUnique());
        }
    }
}

