/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview;

import com.ibm.etools.attrview.AVContents;
import com.ibm.etools.attrview.AVContentsChangeListener;
import com.ibm.etools.attrview.AVContentsChangedEvent;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVGlobalActionProvider;
import com.ibm.etools.attrview.AVHelpProvider;
import com.ibm.etools.attrview.AVTabItem;
import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.AbstractAttributesView;
import com.ibm.etools.attrview.AbstractTabItem;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.AttributesViewContributor;
import com.ibm.etools.attrview.internal.properties.NotAvailableContents;
import com.ibm.etools.webedit.common.attrview.EditorNavigationItem;
import com.ibm.etools.webedit.common.attrview.EditorNavigationProvider;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.PageBook;

public class PDAttributesView
extends AbstractAttributesView
implements AVContents,
AVHelpProvider {
    private AttributesView parentView;
    private Composite root;
    private PageBook pageBook;
    private AVContents activeContents;
    private NotAvailableContents notAvailableContents;
    private AttributesViewContributor activeContributor;
    private ArrayList tabs;
    private AVContentsChangeListener contentsListener = new ContentsChangeListener();
    private ArrayList contentsChangeListeners = new ArrayList();

    public PDAttributesView(AttributesView parentView) {
        this.parentView = parentView;
        this.root = this.getWidgetFactory().createComposite(parentView.getPageContainer(), 0);
        GridLayout layout = new GridLayout();
        this.root.setLayout((Layout)layout);
        this.pageBook = new PageBook(this.root, 0);
        this.pageBook.setLayoutData((Object)new GridData(1808));
        if (parentView instanceof AbstractAttributesView) {
            ((AbstractAttributesView)parentView).addContentsChangeListener(this.contentsListener);
        }
    }

    public void dispose() {
        if (this.parentView instanceof AbstractAttributesView) {
            ((AbstractAttributesView)this.parentView).removeContentsChangeListener(this.contentsListener);
        }
        if (this.notAvailableContents != null) {
            this.notAvailableContents.dispose();
            this.notAvailableContents = null;
        }
        if (this.root != null && !this.root.isDisposed()) {
            this.root.dispose();
        }
        this.root = null;
        this.pageBook = null;
        this.contentsChangeListeners.clear();
    }

    private boolean isSelf(AVContents contents) {
        return this == contents;
    }

    public void setContents(AVContents contents) {
        Control control;
        this.activeContents = contents;
        if (this.isVisible()) {
            ((AbstractAttributesView)this.parentView).addContentsChangeListener(this.contentsListener);
        }
        if (this.activeContents != null && (control = this.activeContents.getControl()) != null && !control.isDisposed()) {
            this.pageBook.showPage(control);
            return;
        }
        if (this.notAvailableContents == null) {
            this.notAvailableContents = new NotAvailableContents((AttributesView)this);
        }
        if ((control = this.notAvailableContents.getControl()) != null && !control.isDisposed()) {
            this.pageBook.showPage(control);
        }
    }

    public void setContributor(AttributesViewContributor contributor) {
        this.activeContributor = contributor;
    }

    public AVWidgetFactory getWidgetFactory() {
        return this.parentView.getWidgetFactory();
    }

    public IWorkbenchPart getActivePart() {
        return this.parentView.getActivePart();
    }

    public Object getData(Object key) {
        return this.parentView.getData(key);
    }

    public AVGlobalActionProvider getGlobalActionProvider() {
        return this.parentView.getGlobalActionProvider();
    }

    public Composite getPageContainer() {
        return this.pageBook;
    }

    public AVTabItem[] getTabs() {
        EditorNavigationItem[] naviItems;
        HTMLEditDomain editDomain = (HTMLEditDomain)this.getActivePart().getAdapter(HTMLEditDomain.class);
        if (editDomain != null && editDomain.getActivePageType() == 2) {
            return null;
        }
        this.tabs = new ArrayList();
        AVTabItem[] tabItems = this.activeContents != null ? this.activeContents.getTabs() : null;
        EditorNavigationProvider editorNavigation = (EditorNavigationProvider)this.getActivePart().getAdapter(EditorNavigationProvider.class);
        if (editorNavigation != null && (naviItems = editorNavigation.getNavigationItems()) != null) {
            int i = 0;
            while (i < naviItems.length) {
                if (naviItems[i].isSelected() && tabItems != null) {
                    int j = 0;
                    while (j < tabItems.length) {
                        this.tabs.add(new PageTab(naviItems[i], tabItems[j], j));
                        ++j;
                    }
                    tabItems = null;
                } else {
                    this.tabs.add(new NavigationTab(naviItems[i], i));
                }
                ++i;
            }
        }
        if (tabItems != null) {
            int i = 0;
            while (i < tabItems.length) {
                this.tabs.add(new PageTab(null, tabItems[i], i));
                ++i;
            }
        }
        return this.tabs.size() > 0 ? this.tabs.toArray(new AVTabItem[this.tabs.size()]) : null;
    }

    public void removeData(Object key) {
        this.parentView.removeData(key);
    }

    public void setData(Object key, Object data) {
        this.parentView.setData(key, data);
    }

    public Control getControl() {
        return this.root;
    }

    public boolean isVisible() {
        if (!this.root.isDisposed()) {
            return this.root.isVisible();
        }
        return false;
    }

    public void setFocus() {
        if (this.activeContents != null) {
            this.activeContents.setFocus();
        } else {
            this.root.setFocus();
        }
    }

    public IActionBars getActionBars() {
        if (this.parentView instanceof AbstractAttributesView) {
            return ((AbstractAttributesView)this.parentView).getActionBars();
        }
        return null;
    }

    public IWorkbenchSite getSite() {
        if (this.parentView instanceof AbstractAttributesView) {
            return ((AbstractAttributesView)this.parentView).getSite();
        }
        return null;
    }

    public void selectTab(int tab) {
        if (this.tabs != null && tab >= 0 && tab < this.tabs.size()) {
            AVTabItem tabItem = (AVTabItem)this.tabs.get(tab);
            if (tabItem instanceof NavigationTab) {
                if (this.activeContents != null && this.activeContents.getFocusControl() != null) {
                    this.getPageContainer().forceFocus();
                }
                EditorNavigationProvider editorNavigation = (EditorNavigationProvider)this.getActivePart().getAdapter(EditorNavigationProvider.class);
                editorNavigation.navigate(((NavigationTab)tabItem).getNavigationIndex());
            } else if (tabItem instanceof PageTab && this.activeContents != null) {
                this.activeContents.selectTab(((PageTab)tabItem).getTabIndex());
            }
        }
    }

    public void setVisible(boolean visible) {
        this.root.setVisible(visible);
    }

    public void updateData(AVEditorContextProvider editorContext) {
        if (this.activeContents != null) {
            this.activeContents.updateData(editorContext);
        }
    }

    public void updateControl() {
        if (this.activeContents != null) {
            this.activeContents.updateControl();
        }
    }

    public Widget getFocusControl() {
        if (this.activeContents != null) {
            return this.activeContents.getFocusControl();
        }
        return this.root.getDisplay().getFocusControl();
    }

    public void refreshContents() {
        if (this.parentView != null) {
            this.parentView.refreshContents();
        }
    }

    public void refreshContents(boolean forceOverrideTabs) {
        if (this.parentView instanceof AbstractAttributesView) {
            ((AbstractAttributesView)this.parentView).refreshContents(forceOverrideTabs);
        }
    }

    public String getHelpId() {
        if (this.activeContents instanceof AVHelpProvider) {
            return ((AVHelpProvider)this.activeContents).getHelpId();
        }
        return null;
    }

    public boolean isEditorEvent() {
        if (this.parentView instanceof AbstractAttributesView) {
            return ((AbstractAttributesView)this.parentView).isEditorEvent();
        }
        return false;
    }

    public void addContentsChangeListener(AVContentsChangeListener listener) {
        if (listener != null && !this.contentsChangeListeners.contains(listener)) {
            this.contentsChangeListeners.add(listener);
        }
    }

    public void removeContentsChangeListener(AVContentsChangeListener listener) {
        if (this.contentsChangeListeners.contains(listener)) {
            this.contentsChangeListeners.remove(listener);
        }
    }

    private class ContentsChangeListener
    implements AVContentsChangeListener {
        private ContentsChangeListener() {
        }

        public void contentsChanged(AVContentsChangedEvent event) {
            if (!PDAttributesView.this.isVisible()) {
                ((AbstractAttributesView)PDAttributesView.this.parentView).removeContentsChangeListener(PDAttributesView.this.contentsListener);
                return;
            }
            if (PDAttributesView.this.isSelf(event.contents)) {
                event = new AVContentsChangedEvent((Object)event.contents, event.reason, event.editorContext, PDAttributesView.this.activeContributor, PDAttributesView.this.activeContents);
            }
            int i = 0;
            while (i < PDAttributesView.this.contentsChangeListeners.size()) {
                AVContentsChangeListener listener = (AVContentsChangeListener)PDAttributesView.this.contentsChangeListeners.get(i);
                listener.contentsChanged(event);
                ++i;
            }
        }
    }

    private class NavigationTab
    extends AbstractTabItem {
        private EditorNavigationItem navigationItem;
        private int navigationIndex;

        public NavigationTab(EditorNavigationItem navigationItem, int navigationIndex) {
            this.navigationItem = navigationItem;
            this.navigationIndex = navigationIndex;
        }

        public Image getImage() {
            if (this.navigationItem != null) {
                return this.navigationItem.getImage();
            }
            return null;
        }

        public String getText() {
            if (this.navigationItem != null) {
                return this.navigationItem.getText();
            }
            return null;
        }

        public boolean isSelected() {
            return this.navigationItem.isSelected();
        }

        public boolean isIndented() {
            return false;
        }

        public Object getModel() {
            return this.navigationItem.getModel();
        }

        public int getNavigationIndex() {
            return this.navigationIndex;
        }

        public EditorNavigationItem getNavigationItem() {
            return this.navigationItem;
        }
    }

    private class PageTab
    extends AbstractTabItem {
        private EditorNavigationItem navigationItem;
        private AVTabItem tabItem;
        private int tabIndex;

        public PageTab(EditorNavigationItem navigationItem, AVTabItem tabItem, int tabIndex) {
            this.navigationItem = navigationItem;
            this.tabItem = tabItem;
            this.tabIndex = tabIndex;
        }

        public Image getImage() {
            return this.tabIndex == 0 && this.navigationItem != null ? this.navigationItem.getImage() : this.tabItem.getImage();
        }

        public String getText() {
            return this.tabIndex == 0 && this.navigationItem != null ? this.navigationItem.getText() : this.tabItem.getText();
        }

        public boolean isSelected() {
            return this.tabItem.isSelected();
        }

        public boolean isIndented() {
            return this.tabIndex != 0 && this.tabItem.isIndented();
        }

        public Object getModel() {
            if (this.tabIndex == 0 && this.navigationItem != null) {
                return this.navigationItem.getModel();
            }
            if (this.tabItem instanceof AbstractTabItem) {
                return ((AbstractTabItem)this.tabItem).getModel();
            }
            return this.tabItem;
        }

        public AVTabItem getTabItem() {
            return this.tabItem;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }
    }
}

