/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview;

import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HTMLNodeSelection
implements NodeSelection {
    private AVEditorContextProvider editorContext;
    private HTMLSelectionMediator mediator;

    public HTMLNodeSelection(AVEditorContextProvider editor, HTMLSelectionMediator mediator) {
        this.editorContext = editor;
        this.mediator = mediator;
    }

    public void dispose() {
        this.editorContext = null;
        this.mediator = null;
    }

    public AVEditorContextProvider getEditorContextProvider() {
        return this.editorContext;
    }

    @Override
    public Document getDocument() {
        NodeList nodeList = this.getNodeList();
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0).getOwnerDocument();
        }
        return null;
    }

    @Override
    public NodeList getNodeList() {
        if (this.mediator != null) {
            return SelectionUtil.extractNodeList(this.mediator.getNodeList(), this.mediator.getNodeListData(), this.mediator.getRange(), this.mediator.getFocusedNode(), true);
        }
        return null;
    }

    public HTMLSelectionMediator getSelectionMediator() {
        return this.mediator;
    }
}

